/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.xmp;

import com.adobe.internal.pdftoolkit.services.pdfa.xmp.MetadataUsageTreeNode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPSimpleType;

class XMPInteger
extends XMPSimpleType {
    private static XMPInteger _xmpInteger = new XMPInteger();
    private static final String EXIF_SCHEMA_NS = "http://ns.adobe.com/tiff/1.0/";
    static final String PHOTOSHOP_SCHEMA_NS = "http://ns.adobe.com/photoshop/1.0/";

    private XMPInteger() {
    }

    public static XMPInteger getInstance() {
        return _xmpInteger;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode a) {
        if (!super.isValid(a)) {
            return false;
        }
        String value = a.getValue();
        Integer i = null;
        try {
            i = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (a.getNameSpaceURI() != null && a.getNameSpaceURI().equalsIgnoreCase(PHOTOSHOP_SCHEMA_NS) && a.getName() != null && a.getName().equals("Urgency")) {
            return i >= 1 && i <= 8;
        }
        return true;
    }

    @Override
    public boolean isValid(MetadataUsageTreeNode m, boolean closedChoice) {
        if (!closedChoice) {
            return this.isValid(m);
        }
        if (!super.isValid(m)) {
            return false;
        }
        String value = m.getValue();
        if (m.getNameSpaceURI() != null && m.getNameSpaceURI().equalsIgnoreCase(EXIF_SCHEMA_NS)) {
            if (m.getName() == null) {
                return false;
            }
            if (m.getName().equals("Compression")) {
                // empty if block
            }
            if (m.getName().equals("Orientation")) {
                Integer i = null;
                try {
                    i = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return i >= 1 && i <= 8;
            }
            if (m.getName().equals("PhotometricInterpretation")) {
                return "2".equals(value) || "6".equals(value);
            }
            if (m.getName().equals("PlanarConfiguration")) {
                return "1".equals(value) || "2".equals(value);
            }
            if (m.getName().equals("ResolutionUnit")) {
                return "2".equals(value) || "3".equals(value);
            }
            if (m.getName().equals("YCbCrPositioning")) {
                return "1".equals(value) || "2".equals(value);
            }
        }
        return false;
    }
}

