/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAExternalSchemas;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAInvalidNamespaceUsage;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAMetadataErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SchemaInserter;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.XMPProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.XMPTypeValidator;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPSchemaUsageValidator;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.Metadata;
import com.adobe.internal.pdftoolkit.services.xmp.MetadataOptions;
import com.adobe.internal.pdftoolkit.services.xmp.XMPMetaFactoryMonitor;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLElementsRemover;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsage;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.options.ParseOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MetadataProcessor {
    private static final boolean DEBUG_SCHEMAS = false;
    private static final String NS_PDFA_ID = "http://www.aiim.org/pdfa/ns/id/";
    private static final String DOC_INFO_CUSTOM_TYPE = "Text";
    private static final String DOC_INFO_CUSTOM_DESCRIPTION = "Custom Property for Entry from the Document Info Dictionary";
    private static final Pattern INVALID_HEADER_ATTRIBUTES_REGEX = Pattern.compile("^(bytes=)|(encoding=)");
    private static final List<Pattern> REQUIRED_HEADER_ATTRIBUTES_REGEX;
    private static final PDFAXMPSchema PDF_SCHEMA;
    private static final PDFAXMPSchema XMPMM_SCHEMA;
    private static final XMLNamespaceUsage XMPMM_USAGE;
    private static final PDFAXMPSchema PDFX_SCHEMA;
    private static final List<PDFAXMPSchema> INSERTION_SCHEMAS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean process(PDFDocument document, PDFAConformanceLevel conformanceLevel, TrackingConversionHandler conversionHandler, PDFAConversionOptions conversionOptions, TrackingValidationHandler validationHandler, PDFAValidationOptions validationOptions) throws PDFIOException, PDFSecurityException {
        if (document == null) {
            return true;
        }
        if (!validationHandler.beginDocMetadataScan()) {
            return false;
        }
        PDFAErrorSetMetadata errorCodes = new PDFAErrorSetMetadata();
        InputStream xmpStream = null;
        try {
            DocumentMetadata metadata = XMPService.getDocumentMetadata(document);
            if (conversionHandler != null) {
                MetadataOptions existingOptions = metadata.getOptions();
                MetadataOptions.MetadataOptionsBuilder builder = MetadataOptions.MetadataOptionsBuilder.newInstance(existingOptions);
                builder.setAutoUpdate(true);
                builder.setRemoveFiltersFromXMP(true);
                builder.setFilterRemovalMarksXMPDirty(true);
                metadata.setOptions(builder.build());
                try {
                    XMPMetaFactory.getSchemaRegistry().registerNamespace("urn:ferd:pdfa:crossindustrydocument:invoice:1p0#", "zf");
                }
                catch (XMPException xMPException) {}
            } else if (!document.requireCatalog().dictionaryContains(ASName.k_Metadata)) {
                errorCodes.addErrorCode(PDFAMetadataErrorCode.catalogMissingMetadata);
            } else {
                String version;
                CosDictionary dict = document.requireCatalog().getDictionaryDictionaryValue(ASName.k_Metadata);
                if (dict.containsKey(ASName.k_Filter)) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.metadataUsesFilter);
                }
                if (!metadata.wasInitialXMPValid()) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.malformedMetadataXML);
                }
                if ((version = metadata.getProperty(NS_PDFA_ID, "part")) == null) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.pdfaInfoNotPresent);
                } else if (conformanceLevel == PDFAConformanceLevel.Level_1b) {
                    if (!"1".equals(version)) {
                        errorCodes.addErrorCode(PDFAMetadataErrorCode.pdfaVersionScanMismatch);
                    }
                } else {
                    throw new RuntimeException("a new PDFAConformanceLevel needs to be supported");
                }
                String conformance = metadata.getProperty(NS_PDFA_ID, "conformance");
                if (conformance == null) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.pdfaInfoNotPresent);
                } else if (conformanceLevel == PDFAConformanceLevel.Level_1b) {
                    if (!"A".equals(conformance) && !"B".equals(conformance)) {
                        errorCodes.addErrorCode(PDFAMetadataErrorCode.pdfaConformanceScanMismatch);
                    }
                } else {
                    throw new RuntimeException("a new PDFAConformanceLevel needs to be supported");
                }
            }
            if (conversionHandler == null) {
                DocumentMetadata.DocInfoConformanceState conformanceState = metadata.initialDocInfoConformanceState();
                if (!MetadataProcessor.checkDocInfoConformance(conformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.TITLE))) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.xmpAndDocInfoTitleMismatch);
                }
                if (!MetadataProcessor.checkDocInfoConformance(conformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.AUTHOR))) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.xmpAndDocInfoAuthorMismatch);
                }
                if (!MetadataProcessor.checkDocInfoConformance(conformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.SUBJECT))) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.xmpAndDocInfoSubjectMismatch);
                }
                if (!MetadataProcessor.checkDocInfoConformance(conformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.KEYWORDS))) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.xmpAndDocInfoKeywordsMismatch);
                }
                if (!MetadataProcessor.checkDocInfoConformance(conformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.CREATOR))) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.xmpAndDocInfoCreatorMismatch);
                }
                if (!MetadataProcessor.checkDocInfoConformance(conformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.PRODUCER))) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.xmpAndDocInfoProducerMismatch);
                }
                if (!MetadataProcessor.checkDocInfoConformance(conformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.CREATION_DATE))) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.xmpAndDocInfoCreationDateMismatch);
                }
                if (!MetadataProcessor.checkDocInfoConformance(conformanceState.getEntryConformanceState(DocumentMetadata.DocInfoConformanceState.DocInfoEntry.MODIFICATION_DATE))) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.xmpAndDocInfoModDateMismatch);
                }
            }
            XMPProcessor xmpProcessor = null;
            xmpProcessor = conversionHandler != null ? new XMPProcessor(document, true) : new XMPProcessor(document, false);
            Map<String, Set<String>> nsQualifierSet = XMPService.getDocumentMetadata(document).getNamespaceQualifierSet();
            XMPSchemaUsageValidator.setQualifierMap(nsQualifierSet);
            Set<PDFAInvalidNamespaceUsage> invalidNamespaceUsageSet = xmpProcessor.getInvalidNamespaceUsage(nsQualifierSet);
            if (!invalidNamespaceUsageSet.isEmpty() && conversionHandler == null) {
                Set<PDFAInvalidNamespaceUsage> invalidUsageSetForHandler = MetadataProcessor.deepCopyInvalidUsageSet(invalidNamespaceUsageSet);
                validationHandler.invalidNamespaceUsage(invalidUsageSetForHandler);
            }
            Map<String, PDFAXMPSchema> existingSchemas = xmpProcessor.getEmbeddedSchemas();
            Map<String, PDFAXMPSchema> referenceSchemas = xmpProcessor.getReferenceSchemas();
            if (conversionHandler != null) {
                PDFAExternalSchemas exteralSchemaHolder = conversionOptions.getExternalSchemas();
                Map<String, PDFAXMPSchema> externalSchemas = exteralSchemaHolder == null ? null : exteralSchemaHolder.getSchemas();
                MetadataProcessor.insertSchemasIntoDocumentXMP(document, conversionHandler, invalidNamespaceUsageSet, existingSchemas, externalSchemas, referenceSchemas);
            }
            if (!MetadataProcessor.checkXMPHeader(document)) {
                errorCodes.addErrorCode(PDFAMetadataErrorCode.invalidXMPHeader);
            }
            XMPTypeValidator typeValidator = new XMPTypeValidator(referenceSchemas, existingSchemas);
            xmpStream = conversionHandler != null ? XMPProcessor.getStreamFromInternalXMP(document) : XMPProcessor.getStreamFromExternalXMP(document);
            if (xmpStream != null) {
                errorCodes.mergeErrorSet(typeValidator.parse(document, xmpStream, null));
                if (!typeValidator.isValid()) {
                    boolean xmpFixed = false;
                    if (conversionHandler == null && errorCodes.schemaUsageNotValid() && validationOptions.getRemoveInvalidXMPProperties() && typeValidator.isSchemaUsageIssueFixable()) {
                        XMLElement historyElem = new XMLElement("http://ns.adobe.com/xap/1.0/mm/", "History");
                        if (typeValidator.getInvalidUsage().containsKey(historyElem)) {
                            errorCodes.unSetErrorFlag(PDFAMetadataErrorCode.schemaUsageNotValid);
                            if (typeValidator.getInvalidUsage().size() == 1) {
                                xmpFixed = true;
                            }
                        }
                    }
                    if (conversionHandler != null && conversionOptions.getRemoveInvalidXMPProperties() && typeValidator.isSchemaUsageIssueFixable()) {
                        HashSet<XMLElement> set = new HashSet<XMLElement>(typeValidator.getInvalidUsage().keySet());
                        InputStream tempXMPStream = null;
                        InputStream xmpInputStream = null;
                        try {
                            tempXMPStream = XMPProcessor.getStreamFromInternalXMP(document);
                            OutputByteStream newXMPStream = document.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, 1024L);
                            InputSource xmpSource = new InputSource(tempXMPStream);
                            XMLReader readerbase = XMLUtils.getXMLReader();
                            XMLElementsRemover elementRemoverFilter = new XMLElementsRemover(readerbase, set, invalidNamespaceUsageSet);
                            elementRemoverFilter.setFeature("http://xml.org/sax/features/namespaces", true);
                            elementRemoverFilter.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                            if (XMLUtils.removeXMLElements(xmpSource, new StreamResult(newXMPStream.toOutputStream()), true, elementRemoverFilter)) {
                                errorCodes.unSetErrorFlag(PDFAMetadataErrorCode.schemaUsageNotValid);
                                xmpFixed = true;
                                xmpInputStream = newXMPStream.closeAndConvert().toInputStream();
                                metadata.importXMP(xmpInputStream);
                            }
                        }
                        catch (IOException e) {
                            throw new PDFIOException(e);
                        }
                        catch (SAXException e) {
                            throw new PDFInvalidXMLException(e);
                        }
                        catch (TransformerException e) {
                            throw new PDFInvalidXMLException(e);
                        }
                        finally {
                            try {
                                if (tempXMPStream != null) {
                                    tempXMPStream.close();
                                }
                            }
                            catch (IOException e) {
                                throw new PDFIOException(e);
                            }
                            try {
                                if (xmpInputStream != null) {
                                    xmpInputStream.close();
                                }
                            }
                            catch (IOException e) {
                                throw new PDFIOException(e);
                            }
                        }
                    }
                    if (!xmpFixed && !validationHandler.invalidTypeUsage(typeValidator.getInvalidUsage())) {
                        boolean set = false;
                        return set;
                    }
                }
            }
            if (conversionHandler != null && (!conversionHandler.errorsFound() || conversionHandler.errorsFixed() && conversionOptions.getUpdatePDFAMetadataOnPartialConversion())) {
                MetadataProcessor.setPDFAInfo(conformanceLevel, metadata);
                if (!conversionHandler.pdfaInfoSetInMetadata(conformanceLevel)) {
                    boolean bl = false;
                    return bl;
                }
            }
            MetadataProcessor.addInvalidNameSpaceUsageErrorCodes(invalidNamespaceUsageSet, errorCodes);
        }
        catch (PDFInvalidParameterException e) {
            errorCodes.addErrorCode(PDFAMetadataErrorCode.malformedMetadataXML);
        }
        catch (PDFInvalidXMLException e) {
            errorCodes.addErrorCode(PDFAMetadataErrorCode.malformedMetadataXML);
        }
        catch (PDFUnableToCompleteOperationException e) {
            errorCodes.addErrorCode(PDFAMetadataErrorCode.pdfaInfoNotPresent);
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFAMetadataErrorCode.pdfGeneralFailure);
        }
        catch (PDFConfigurationException e) {
            errorCodes.addErrorCode(PDFAMetadataErrorCode.pdfGeneralFailure);
        }
        catch (XMPException e) {
            errorCodes.addErrorCode(PDFAMetadataErrorCode.catalogMissingMetadata);
        }
        finally {
            XMPSchemaUsageValidator.getQualifierMap().clear();
            try {
                if (xmpStream != null) {
                    xmpStream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        if (errorCodes.hasErrors() && !validationHandler.docMetadataError(errorCodes)) {
            return false;
        }
        return validationHandler.endDocMetadataScan();
    }

    public static boolean processDictionaryXMP(PDFCosDictionary cosDictionary, PDFAConversionHandler conversionHandler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFMetadata metadata = cosDictionary.getMetadata();
        if (metadata == null) {
            return true;
        }
        try {
            MetadataProcessor.buildXMP(metadata);
        }
        catch (XMPException e) {
            if (conversionHandler != null) {
                cosDictionary.setMetadata(null);
            }
            return false;
        }
        catch (IOException e) {
            if (conversionHandler != null) {
                cosDictionary.setMetadata(null);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildXMP(PDFMetadata pdfMetadata) throws PDFCosParseException, PDFIOException, PDFSecurityException, XMPException, IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream outStm = null;
        try {
            if (pdfMetadata != null) {
                outStm = new ByteArrayOutputStream(pdfMetadata.getLength() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pdfMetadata.getLength());
                pdfMetadata.getStreamData(outStm);
                is = new ByteArrayInputStream(outStm.toByteArray());
                ParseOptions opts = XMPService.XMPCORE_PARSE_OPTIONS;
                XMPMetaFactoryMonitor.parse(is, opts, pdfMetadata.getPDFDocument());
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (outStm != null) {
                    outStm.close();
                }
            }
        }
    }

    static void addInvalidNameSpaceUsageErrorCodes(Set<PDFAInvalidNamespaceUsage> invalidNamespaceUsageSet, PDFAErrorSetMetadata errorCodes) {
        if (!invalidNamespaceUsageSet.isEmpty()) {
            for (PDFAInvalidNamespaceUsage invalidNamespace : invalidNamespaceUsageSet) {
                if (invalidNamespace.prefixError()) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.invalidPrefix);
                }
                if (invalidNamespace.getNamespaceDefinitionLocation() == PDFAInvalidNamespaceUsage.DefinitionLocation.NONE) {
                    errorCodes.addErrorCode(PDFAMetadataErrorCode.missingExtensionSchema);
                    continue;
                }
                if (invalidNamespace.getElements().isEmpty()) continue;
                errorCodes.addErrorCode(PDFAMetadataErrorCode.elementUsedNotDefined);
            }
        }
    }

    private static void setPDFAInfo(PDFAConformanceLevel conformanceLevel, Metadata metadata) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidXMLException {
        String part = "1";
        String conformance = "B";
        if (conformanceLevel == PDFAConformanceLevel.Level_1a) {
            part = "1";
            conformance = "A";
        } else if (conformanceLevel == PDFAConformanceLevel.Level_1b) {
            part = "1";
            conformance = "B";
        }
        metadata.addProperty(NS_PDFA_ID, "part", part);
        metadata.addProperty(NS_PDFA_ID, "conformance", conformance);
    }

    public static String getVersion(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        try {
            return XMPService.getDocumentMetadata(document).getProperty(NS_PDFA_ID, "part");
        }
        catch (PDFUnableToCompleteOperationException e) {
            return null;
        }
    }

    public static String getConformanceLevel(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        try {
            return XMPService.getDocumentMetadata(document).getProperty(NS_PDFA_ID, "conformance");
        }
        catch (PDFUnableToCompleteOperationException e) {
            return null;
        }
    }

    public static String getAmendmentID(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFInvalidParameterException {
        try {
            return XMPService.getDocumentMetadata(document).getProperty(NS_PDFA_ID, "amd");
        }
        catch (PDFUnableToCompleteOperationException e) {
            return null;
        }
    }

    private static boolean checkXMPHeader(PDFDocument pdfDocument) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        DocumentMetadata docMeta = XMPService.getDocumentMetadata(pdfDocument);
        String[] headerAttributes = docMeta.getHeaderAttributesAsArray();
        return MetadataProcessor.checkXMPHeader(headerAttributes);
    }

    static boolean checkXMPHeader(XMPMeta xmpMeta) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        String headerAttribute = xmpMeta.getPacketHeader();
        String[] attributes = null;
        attributes = headerAttribute == null ? new String[]{} : headerAttribute.split(" ");
        return MetadataProcessor.checkXMPHeader(attributes);
    }

    private static boolean checkXMPHeader(String[] headerAttributes) {
        for (String attribute : headerAttributes) {
            Matcher invalidAttributeMatcher = INVALID_HEADER_ATTRIBUTES_REGEX.matcher(attribute);
            if (!invalidAttributeMatcher.find()) continue;
            return false;
        }
        for (Pattern p : REQUIRED_HEADER_ATTRIBUTES_REGEX) {
            boolean patternFound = false;
            for (String attribute : headerAttributes) {
                Matcher requiredAttributeMatcher = p.matcher(attribute);
                patternFound = false;
                if (!requiredAttributeMatcher.find()) continue;
                patternFound = true;
                break;
            }
            if (patternFound) continue;
            return false;
        }
        return true;
    }

    static boolean insertSchemasIntoDocumentXMP(PDFDocument pdfDocument, PDFAConversionHandler conversionHandler, Set<PDFAInvalidNamespaceUsage> invalidUsageSet, Map<String, PDFAXMPSchema> existingSchemas, Map<String, PDFAXMPSchema> externalSchemas, Map<String, PDFAXMPSchema> referenceSchemas) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        boolean xmpHadSchemas = !existingSchemas.isEmpty();
        ArrayList<PDFAXMPSchema> schemasToAdd = new ArrayList<PDFAXMPSchema>();
        if (pdfDocument == null) {
            throw new PDFInvalidDocumentException("No PDF document to process.");
        }
        PDFMetadata pdfMeta = pdfDocument.requireCatalog().getMetadata();
        long originalXMPSize = pdfMeta == null ? 0L : pdfMeta.getLength();
        StreamManager streamManager = pdfDocument.getStreamManager();
        PDFAXMPSchema pdfxSchema = MetadataProcessor.addDocInfoCustomToSchema(pdfDocument, new PDFAXMPSchema(PDFX_SCHEMA));
        schemasToAdd.add(pdfxSchema);
        PDFAInvalidNamespaceUsage xmpMM_copy = new PDFAInvalidNamespaceUsage(XMPMM_USAGE);
        invalidUsageSet.add(xmpMM_copy);
        Iterator<PDFAInvalidNamespaceUsage> invalidUsageIter = invalidUsageSet.iterator();
        while (invalidUsageIter.hasNext()) {
            PDFAInvalidNamespaceUsage invalidNamespace = invalidUsageIter.next();
            for (PDFAXMPSchema knownSchema : INSERTION_SCHEMAS) {
                if (!invalidNamespace.removeSchema(knownSchema)) continue;
                schemasToAdd.add(knownSchema);
            }
            invalidNamespace.removeSchema(pdfxSchema);
            if (externalSchemas != null) {
                for (PDFAXMPSchema knownSchema : externalSchemas.values()) {
                    if (!invalidNamespace.removeSchema(knownSchema)) continue;
                    schemasToAdd.add(knownSchema);
                }
            }
            if (!invalidNamespace.areErrorsCleared()) continue;
            invalidUsageIter.remove();
        }
        if (schemasToAdd.isEmpty()) {
            return true;
        }
        for (PDFAXMPSchema schema : schemasToAdd) {
            PDFAXMPSchema referenceSchema = referenceSchemas.get(schema.getURI());
            if (referenceSchema == null) {
                referenceSchemas.put(schema.getURI(), new PDFAXMPSchema(schema));
                continue;
            }
            referenceSchema.mergeSchema(schema);
            referenceSchemas.put(schema.getURI(), referenceSchema);
        }
        Set<PDFAInvalidNamespaceUsage> invalidUsageSetForHandler = MetadataProcessor.deepCopyInvalidUsageSet(invalidUsageSet);
        if (!conversionHandler.schemasForInsertion(invalidUsageSetForHandler, schemasToAdd)) {
            return false;
        }
        Set<PDFAXMPSchema> mergedSchemas = MetadataProcessor.mergeSchemas(existingSchemas, schemasToAdd);
        OutputByteStream xmpOBS = null;
        SkippingOutputStream xmpOS = null;
        InputByteStream xmpIBS = null;
        InputStream xmpIS = null;
        OutputByteStream newXmpOBS = null;
        OutputStream newXmpOS = null;
        InputByteStream newXmpIBS = null;
        InputStream newXmpIS = null;
        try {
            xmpOBS = streamManager.getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, originalXMPSize);
            xmpOS = xmpOBS.toOutputStream();
            DocumentMetadata metadata = XMPService.getDocumentMetadata(pdfDocument);
            metadata.exportXMP(xmpOS);
            xmpIBS = xmpOBS.closeAndConvert();
            xmpOBS = null;
            xmpOS.close();
            xmpOS = null;
            xmpIS = xmpIBS.toInputStream();
            InputSource xmpSource = new InputSource(xmpIS);
            newXmpOBS = streamManager.getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, originalXMPSize);
            newXmpOS = newXmpOBS.toOutputStream();
            StreamResult newXmpResult = new StreamResult(newXmpOS);
            SchemaInserter inserter = new SchemaInserter(mergedSchemas, xmpHadSchemas);
            try {
                XMLUtils.applyXMLFilter(xmpSource, inserter, newXmpResult, false);
            }
            catch (SAXException e) {
                throw new PDFUnableToCompleteOperationException("Error with XML reader or feature set.", e);
            }
            catch (TransformerException e) {
                throw new PDFUnableToCompleteOperationException("Error XML content.", e);
            }
            newXmpIBS = newXmpOBS.closeAndConvert();
            newXmpOBS = null;
            newXmpIS = newXmpIBS.toInputStream();
            metadata.importXMP(newXmpIS);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (xmpOBS != null) {
                    xmpOBS.close();
                }
                if (xmpOS != null) {
                    xmpOS.close();
                }
                if (xmpIBS != null) {
                    xmpIBS.close();
                }
                if (xmpIS != null) {
                    xmpIS.close();
                }
                if (newXmpOBS != null) {
                    newXmpOBS.close();
                }
                if (newXmpOS != null) {
                    newXmpOS.close();
                }
                if (newXmpIBS != null) {
                    newXmpIBS.close();
                }
                if (newXmpIS != null) {
                    newXmpIS.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException("Error during stream closure.", e);
            }
        }
        return true;
    }

    private static Set<PDFAXMPSchema> mergeSchemas(Map<String, PDFAXMPSchema> baseSchemaSet, List<PDFAXMPSchema> ... addSchemaSets) {
        for (List<PDFAXMPSchema> addSchemaSet : addSchemaSets) {
            for (PDFAXMPSchema addSchema : addSchemaSet) {
                PDFAXMPSchema baseSchema = baseSchemaSet.get(addSchema.getURI());
                if (baseSchema != null) {
                    baseSchema.mergeSchema(addSchema);
                    continue;
                }
                baseSchemaSet.put(addSchema.getURI(), addSchema);
            }
        }
        HashSet<PDFAXMPSchema> mergeSet = new HashSet<PDFAXMPSchema>();
        mergeSet.addAll(baseSchemaSet.values());
        return mergeSet;
    }

    private static PDFAXMPSchema addDocInfoCustomToSchema(PDFDocument pdfDocument, PDFAXMPSchema schema) throws PDFInvalidXMLException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        DocumentMetadata metadata = XMPService.getDocumentMetadata(pdfDocument);
        List<String> customNames = metadata.getCustomPropertyNames();
        Iterator<String> namesIter = customNames.iterator();
        if (!namesIter.hasNext()) {
            return schema;
        }
        while (namesIter.hasNext()) {
            PDFAXMPSchema.PDFAXMPProperty property = new PDFAXMPSchema.PDFAXMPProperty(namesIter.next(), DOC_INFO_CUSTOM_TYPE, PDFAXMPSchema.PDFAXMPProperty.Category.INTERNAL, DOC_INFO_CUSTOM_DESCRIPTION);
            schema.addProperty(property);
        }
        return schema;
    }

    private static Set<PDFAInvalidNamespaceUsage> deepCopyInvalidUsageSet(Set<PDFAInvalidNamespaceUsage> originalSet) {
        HashSet<PDFAInvalidNamespaceUsage> copySet = new HashSet<PDFAInvalidNamespaceUsage>(originalSet.size());
        for (PDFAInvalidNamespaceUsage invalidNamespace : originalSet) {
            PDFAInvalidNamespaceUsage copy = new PDFAInvalidNamespaceUsage((XMLNamespaceUsage)invalidNamespace);
            copySet.add(copy);
        }
        return copySet;
    }

    private static boolean checkDocInfoConformance(DocumentMetadata.DocInfoConformanceState.EntryConformanceState conformanceState) {
        boolean conforms = true;
        if (conformanceState == null) {
            return false;
        }
        if (conformanceState.getDocInfoEntryExists()) {
            if (!conformanceState.getXMPEntryExists()) {
                conforms = false;
            } else if (!conformanceState.getBothEqual()) {
                conforms = false;
            }
        }
        return conforms;
    }

    static {
        ArrayList<Pattern> temp = new ArrayList<Pattern>();
        temp.add(Pattern.compile("^begin="));
        temp.add(Pattern.compile("^id="));
        REQUIRED_HEADER_ATTRIBUTES_REGEX = temp;
        PDF_SCHEMA = new PDFAXMPSchema("http://ns.adobe.com/pdf/1.3/", "pdf", "This schema specifies properties used with Adobe PDF documents.");
        PDFAXMPSchema.PDFAXMPProperty property = new PDFAXMPSchema.PDFAXMPProperty("Trapped", DOC_INFO_CUSTOM_TYPE, PDFAXMPSchema.PDFAXMPProperty.Category.INTERNAL, "A name object indicating whether the document has been modified to include trapping information");
        PDF_SCHEMA.addProperty(property);
        XMPMM_SCHEMA = new PDFAXMPSchema("http://ns.adobe.com/xap/1.0/mm/", "xmpMM", "The XMP Media Management Schema is primarily for use by digital asset management (DAM) systems.");
        property = new PDFAXMPSchema.PDFAXMPProperty("InstanceID", "URI", PDFAXMPSchema.PDFAXMPProperty.Category.INTERNAL, "UUID based identifier for specific incarnation of a document");
        XMPMM_SCHEMA.addProperty(property);
        XMPMM_USAGE = new XMLNamespaceUsage("http://ns.adobe.com/xap/1.0/mm/");
        XMPMM_USAGE.addPrefix("xmpMM");
        XMPMM_USAGE.addElement("InstanceID");
        PDFX_SCHEMA = new PDFAXMPSchema("http://ns.adobe.com/pdfx/1.3/", "pdfx", "PDF Extension schema");
        PDFX_SCHEMA.setDescription("PDF/X ID Schema");
        property = new PDFAXMPSchema.PDFAXMPProperty("GTS_PDFXVersion", DOC_INFO_CUSTOM_TYPE, PDFAXMPSchema.PDFAXMPProperty.Category.INTERNAL, "ID of PDF/X standard");
        PDFX_SCHEMA.addProperty(property);
        property = new PDFAXMPSchema.PDFAXMPProperty("GTS_PDFXConformance", DOC_INFO_CUSTOM_TYPE, PDFAXMPSchema.PDFAXMPProperty.Category.INTERNAL, "Conformance level of PDF/X standard");
        PDFX_SCHEMA.addProperty(property);
        INSERTION_SCHEMAS = new ArrayList<PDFAXMPSchema>();
        INSERTION_SCHEMAS.add(PDF_SCHEMA);
        INSERTION_SCHEMAS.add(XMPMM_SCHEMA);
        INSERTION_SCHEMAS.add(PDFX_SCHEMA);
    }
}

