/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceN;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceSeparation;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntentsList;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetColorSpace;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.common.ColorSpaceAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceDeviceNAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceIndexedAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceMapAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceSeparationAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAColorSpaceErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.PDFAFailFastValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SharedConstraints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.util.Set;

class ColorSpaceProcessor {
    ColorSpaceProcessor() {
    }

    static boolean process(PDFColorSpaceMap colorSpaceMap, Set referencedCSNames, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler handler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        boolean defaultCMYKSet;
        if (colorSpaceMap == null || colorSpaceMap.isEmpty()) {
            return true;
        }
        boolean defaultRGBSet = colorSpaceMap.get(ASName.k_DefaultRGB) != null;
        boolean bl = defaultCMYKSet = colorSpaceMap.get(ASName.k_DefaultCMYK) != null;
        if (validationOptions.validateUnusedResourcesEnabled()) {
            for (ASName name : colorSpaceMap.keySet()) {
                PDFColorSpace colorSpace;
                PDFColorSpaceMapAdapter csAdapter = new PDFColorSpaceMapAdapter(colorSpaceMap, name);
                if (ColorSpaceProcessor.process(csAdapter, name, colorSpace = colorSpaceMap.get(name), docProcessor, defaultRGBSet, defaultCMYKSet, conformance, handler, conversionHandler)) continue;
                return false;
            }
        } else {
            if (referencedCSNames == null || referencedCSNames.isEmpty()) {
                return true;
            }
            for (ASName name : referencedCSNames) {
                PDFColorSpace colorSpace;
                PDFColorSpaceMapAdapter csAdapter = new PDFColorSpaceMapAdapter(colorSpaceMap, name);
                if (ColorSpaceProcessor.process(csAdapter, name, colorSpace = colorSpaceMap.get(name), docProcessor, defaultRGBSet, defaultCMYKSet, conformance, handler, conversionHandler)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean process(ColorSpaceAdapter csAdapter, ASName name, PDFColorSpace colorSpace, DocumentProcessor docProcessor, boolean defaultRGBSet, boolean defaultCMYKSet, PDFAConformanceLevel conformance, PDFAValidationHandler handler, PDFAConversionHandler conversionHandler) throws PDFIOException, PDFSecurityException {
        if (colorSpace == null) {
            return true;
        }
        if (!handler.beginColorSpaceScan(name, colorSpace)) {
            return false;
        }
        PDFAErrorSetColorSpace errorCodes = new PDFAErrorSetColorSpace();
        try {
            if (colorSpace instanceof PDFColorSpaceDeviceRGB) {
                docProcessor.usesDeviceRGBColorSpace = true;
                if (!docProcessor.hasRGBOutputIntent && !defaultRGBSet) {
                    errorCodes.addErrorCode(PDFAColorSpaceErrorCode.notDeviceIndependent);
                }
                if (docProcessor.usesDeviceCMYKColorSpace) {
                    errorCodes.addErrorCode(PDFAColorSpaceErrorCode.bothDeviceRGBAndDeviceCMYKInUse);
                }
            } else if (colorSpace instanceof PDFColorSpaceDeviceCMYK) {
                docProcessor.usesDeviceCMYKColorSpace = true;
                if (!docProcessor.hasCMYKOutputIntent && !defaultCMYKSet) {
                    errorCodes.addErrorCode(PDFAColorSpaceErrorCode.notDeviceIndependent);
                }
                if (docProcessor.usesDeviceRGBColorSpace) {
                    errorCodes.addErrorCode(PDFAColorSpaceErrorCode.bothDeviceRGBAndDeviceCMYKInUse);
                }
            } else if (colorSpace instanceof PDFColorSpaceDeviceGray) {
                if (!(docProcessor.hasRGBOutputIntent || defaultRGBSet || docProcessor.hasCMYKOutputIntent || defaultCMYKSet)) {
                    errorCodes.addErrorCode(PDFAColorSpaceErrorCode.notDeviceIndependent);
                }
            } else if (colorSpace instanceof PDFColorSpaceICCBased) {
                PDFColorSpaceICCBased iccCS = (PDFColorSpaceICCBased)colorSpace;
                if (!ColorSpaceProcessor.processICCProfile(csAdapter, name, iccCS, docProcessor, defaultRGBSet, defaultCMYKSet, conformance, handler, conversionHandler, errorCodes)) {
                    return false;
                }
            } else if (colorSpace instanceof PDFColorSpaceSeparation) {
                PDFColorSpaceSeparation sepCS = (PDFColorSpaceSeparation)colorSpace;
                PDFColorSpace altCS = sepCS.getAlternateColorSpace();
                ColorSpaceProcessor.process(new PDFColorSpaceSeparationAdapter(sepCS), ASName.k_Alternate, altCS, docProcessor, defaultRGBSet, defaultCMYKSet, conformance, handler, conversionHandler);
            } else if (colorSpace instanceof PDFColorSpaceDeviceN) {
                PDFColorSpaceDeviceN devNCS = (PDFColorSpaceDeviceN)colorSpace;
                PDFColorSpace altCS = devNCS.getAlternateColorSpace();
                ColorSpaceProcessor.process(new PDFColorSpaceDeviceNAdapter(devNCS), ASName.k_Alternate, altCS, docProcessor, defaultRGBSet, defaultCMYKSet, conformance, handler, conversionHandler);
            } else if (colorSpace instanceof PDFColorSpaceIndexed) {
                PDFColorSpaceIndexed indCS = (PDFColorSpaceIndexed)colorSpace;
                PDFColorSpace baseCS = indCS.getBaseColorSpace();
                ColorSpaceProcessor.process(new PDFColorSpaceIndexedAdapter(indCS), ASName.k_Base, baseCS, docProcessor, defaultRGBSet, defaultCMYKSet, conformance, handler, conversionHandler);
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFAColorSpaceErrorCode.pdfGeneralFailure);
        }
        if (errorCodes.hasErrors() && !handler.colorSpaceError(errorCodes)) {
            return false;
        }
        return handler.endColorSpaceScan();
    }

    static boolean hasValidPDFAOutputIntentWithRGBCS(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ColorSpaceProcessor.hasValidPDFAOutputIntent(document, 5);
    }

    static boolean hasValidPDFAOutputIntentWithCMYKCS(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ColorSpaceProcessor.hasValidPDFAOutputIntent(document, 9);
    }

    static boolean hasValidPDFAOutputIntent(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ColorSpaceProcessor.hasValidPDFAOutputIntent(document, null);
    }

    private static boolean hasValidPDFAOutputIntent(PDFDocument document, Integer requiredColorSpaceType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOutputIntentsList intents = document.requireCatalog().getOutputIntents();
        if (intents == null) {
            return false;
        }
        for (PDFOutputIntent intent : intents) {
            ASName subtype = intent.getSubType();
            if (!subtype.equals(SharedConstraints.k_GTS_PDFA1)) continue;
            PDFICCProfile iccProfile = intent.getDestOutputProfile();
            if (iccProfile == null) {
                return false;
            }
            try {
                ColorSpace cs = iccProfile.getColorSpace();
                if (requiredColorSpaceType != null) {
                    return cs.getType() == requiredColorSpaceType.intValue();
                }
                return true;
            }
            catch (PDFInvalidDocumentException e) {
                return false;
            }
            catch (PDFIOException e) {
                return false;
            }
        }
        return false;
    }

    private static boolean processICCProfile(ColorSpaceAdapter csAdapter, ASName name, PDFColorSpaceICCBased pIccCS, DocumentProcessor docProcessor, boolean defaultRGBSet, boolean defaultCMYKSet, PDFAConformanceLevel conformance, PDFAValidationHandler handler, PDFAConversionHandler conversionHandler, PDFAErrorSetColorSpace errorCodes) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        try {
            PDFICCProfile pdfProfile = pIccCS.getPDFICCProfile();
            if (!MetadataProcessor.processDictionaryXMP(pdfProfile, conversionHandler)) {
                errorCodes.addErrorCode(PDFAColorSpaceErrorCode.objectXMPMetadataInvalid);
            }
            ICC_ColorSpace iccCS = (ICC_ColorSpace)pdfProfile.getColorSpace();
            ICC_Profile iccProfile = iccCS.getProfile();
            int majorVersion = iccProfile.getMajorVersion();
            if (conformance == PDFAConformanceLevel.Level_1b && majorVersion > 2) {
                PDFICCProfile replacementProfile;
                boolean iccProfileReplaced = false;
                if (conversionHandler != null && (replacementProfile = conversionHandler.getValidICCProfile(pdfProfile)) != null) {
                    iccProfileReplaced = true;
                    pIccCS.setPDFICCProfile(replacementProfile);
                }
                if (!iccProfileReplaced) {
                    errorCodes.addErrorCode(PDFAColorSpaceErrorCode.iccProfileVersionNotAllowed);
                }
            }
            return true;
        }
        catch (PDFInvalidContentException e) {
            PDFColorSpace alternate = pIccCS.getAlternateColorSpace();
            if (alternate == null || csAdapter == null || conversionHandler == null) {
                errorCodes.addErrorCode(PDFAColorSpaceErrorCode.iccProfileCouldNotBeParsed);
                return true;
            }
            PDFAFailFastValidationHandler failFastValidationHandler = new PDFAFailFastValidationHandler();
            if (ColorSpaceProcessor.process(csAdapter, name, alternate, docProcessor, defaultRGBSet, defaultCMYKSet, conformance, failFastValidationHandler, conversionHandler)) {
                csAdapter.setColorSpace(alternate);
                return conversionHandler.alternateColorSpaceUsedAsInvalidICCProfileFound(pIccCS);
            }
            errorCodes.addErrorCode(PDFAColorSpaceErrorCode.iccProfileCouldNotBeParsed);
            return true;
        }
    }
}

