/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.error;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;

public enum PDFACatalogErrorCode implements PDFAErrorCode
{
    pdfGeneralFailure,
    nullPageAsDestination,
    openActionNotAllowed,
    actionLaunchNotAllowed,
    actionSoundNotAllowed,
    actionMovieNotAllowed,
    actionResetFormNotAllowed,
    actionImportDataNotAllowed,
    actionJavaScriptNotAllowed,
    actionSetStateNotAllowed,
    actionNoOpNotAllowed,
    additionalActionsNotAllowed,
    optionalContentNotAllowed,
    namedEmbeddedFilesNotAllowed,
    certifyingSignatureNotAllowed,
    xfaNotAllowed,
    namedJavaScriptsNotAllowed;


    public static PDFACatalogErrorCode getErrorCode(ASName subtype) {
        if (subtype != null) {
            if (subtype == ASName.k_Launch) {
                return actionLaunchNotAllowed;
            }
            if (subtype == ASName.k_Sound) {
                return actionSoundNotAllowed;
            }
            if (subtype == ASName.k_Movie) {
                return actionMovieNotAllowed;
            }
            if (subtype == ASName.k_ResetForm) {
                return actionResetFormNotAllowed;
            }
            if (subtype == ASName.k_ImportData) {
                return actionImportDataNotAllowed;
            }
            if (subtype == ASName.k_JavaScript) {
                return actionJavaScriptNotAllowed;
            }
            String typeString = subtype.asString();
            if ("set-state".equalsIgnoreCase(typeString) || "setstate".equalsIgnoreCase(typeString)) {
                return actionSetStateNotAllowed;
            }
            if ("no-op".equalsIgnoreCase(typeString) || "nop".equalsIgnoreCase(typeString)) {
                return actionNoOpNotAllowed;
            }
        }
        return null;
    }
}

