/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.common;

import com.adobe.internal.pdftoolkit.services.pdfa.common.CharacterWidthHolder;

public class CharacterWidthHolderSimpleFont
implements CharacterWidthHolder {
    private int initialFirstChar;
    private int initialLastChar;
    private int[] initialWidthsArray;
    private int finalFirstChar;
    private int finalLastChar;
    private int[] finalWidthsArray;
    private Boolean widthChanged;

    public void setInitialFirstChar(int initialFirstChar) {
        this.initialFirstChar = initialFirstChar;
    }

    public void setInitialLastChar(int initialLastChar) {
        this.initialLastChar = initialLastChar;
    }

    public void setInitialWidthsArray(int[] initialWidthsArray) {
        this.initialWidthsArray = initialWidthsArray;
    }

    public void setFinalFirstChar(int finalFirstChar) {
        this.finalFirstChar = finalFirstChar;
    }

    public void setFinalLastChar(int finalLastChar) {
        this.finalLastChar = finalLastChar;
    }

    public void setFinalWidthsArray(int[] finalWidthsArray) {
        this.finalWidthsArray = finalWidthsArray;
    }

    @Override
    public int getWidthDifference(int charcode) {
        if (charcode < this.initialFirstChar || charcode > this.initialLastChar) {
            return 0;
        }
        if (charcode < this.finalFirstChar || charcode > this.finalLastChar) {
            return 0;
        }
        if (this.initialWidthsArray == null || this.finalWidthsArray == null) {
            return 0;
        }
        return this.initialWidthsArray[charcode - this.initialFirstChar] - this.finalWidthsArray[charcode - this.finalFirstChar];
    }

    public boolean widthChanged() {
        if (this.widthChanged == null) {
            this.widthChanged = false;
            for (int i = this.finalFirstChar; i <= this.finalLastChar; ++i) {
                if (this.getWidthDifference(i) == 0) continue;
                this.widthChanged = true;
                break;
            }
        }
        return this.widthChanged;
    }
}

