/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsage;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class PDFAInvalidNamespaceUsage
extends XMLNamespaceUsage {
    private DefinitionLocation definitionLocation = DefinitionLocation.NONE;
    private boolean prefixError = false;
    private Set<String> originalPrefixes;

    public PDFAInvalidNamespaceUsage(XMLNamespaceUsage otherNamespaceUsage) {
        super(otherNamespaceUsage);
        super.removeAttributes();
        this.originalPrefixes = new HashSet<String>(otherNamespaceUsage.getPrefixes());
    }

    PDFAInvalidNamespaceUsage(PDFAInvalidNamespaceUsage otherInvalidUsage) {
        this((XMLNamespaceUsage)otherInvalidUsage);
        this.originalPrefixes = new HashSet<String>(otherInvalidUsage.originalPrefixes);
    }

    void setNamespaceDefinitionLocation(DefinitionLocation definitionLocation) {
        this.definitionLocation = definitionLocation;
    }

    public void addNamespaceDefinitionLocation(DefinitionLocation definitionLocation) {
        this.definitionLocation = this.definitionLocation.addLocation(definitionLocation);
    }

    public DefinitionLocation getNamespaceDefinitionLocation() {
        return this.definitionLocation;
    }

    public boolean removeSchema(PDFAXMPSchema schema) {
        Set<PDFAXMPSchema.PDFAXMPType> typeSet;
        boolean namespaceChanged = false;
        if (this.getURI().equals(schema.getURI())) {
            String schemaPrefix = schema.getPrefix();
            super.removePrefix(schemaPrefix);
            Map<String, PDFAXMPSchema.PDFAXMPProperty> properties = schema.getProperties();
            if (properties != null && !properties.isEmpty()) {
                namespaceChanged |= super.removeElements(properties.keySet());
            }
            if (schema.getPrefixIsRequired() && schemaPrefix != null) {
                if (this.originalPrefixes.size() != 1) {
                    this.prefixError = true;
                } else if (!this.originalPrefixes.contains(schemaPrefix)) {
                    this.prefixError = true;
                }
            }
        }
        if ((typeSet = schema.getTypeByURI(this.getURI())) != null && !typeSet.isEmpty()) {
            for (PDFAXMPSchema.PDFAXMPType type : typeSet) {
                boolean typeChanged = false;
                String typePrefix = type.getPrefix();
                super.removePrefix(typePrefix);
                typeChanged |= super.removeElement(type.getType());
                Map<String, PDFAXMPSchema.PDFAXMPField> fieldMap = type.getFields();
                if (fieldMap != null && !fieldMap.isEmpty()) {
                    for (PDFAXMPSchema.PDFAXMPField field : fieldMap.values()) {
                        typeChanged |= super.removeElement(field.getName());
                    }
                }
                if (typeChanged) {
                    namespaceChanged = true;
                }
                if (!type.getPrefixIsRequired() || typePrefix == null) continue;
                if (this.originalPrefixes.size() != 1) {
                    this.prefixError = true;
                    continue;
                }
                if (this.originalPrefixes.contains(typePrefix)) continue;
                this.prefixError = true;
            }
        }
        return namespaceChanged;
    }

    public boolean prefixError() {
        return this.prefixError;
    }

    public boolean areErrorsCleared() {
        if (!super.isEmpty(true)) {
            return false;
        }
        return !this.prefixError();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("\t");
        builder.append("definition location = ");
        builder.append((Object)this.definitionLocation);
        builder.append("\n\t");
        builder.append("original prefixes = ");
        builder.append(this.originalPrefixes);
        return builder.toString();
    }

    public synchronized void removeQualifiers(Map<String, Set<String>> namespaceQualifierSet) {
        String nsURI = this.getURI();
        if (namespaceQualifierSet.containsKey(nsURI)) {
            super.removeElements(namespaceQualifierSet.get(nsURI));
        }
    }

    public static enum DefinitionLocation {
        NONE("no definition"),
        PDFA_SPECIFICATON("defined in the PDF/A specification"),
        PDFA_SCHEMA("defined in a PDF/A schema in the XMP"),
        PDFA_SPECIFICATION_AND_SCHEMA("defined in both the PDF/A specification and an embedded schema in the XMP");

        private final String description;

        private DefinitionLocation(String description) {
            this.description = description;
        }

        DefinitionLocation addLocation(DefinitionLocation other) {
            if (other == NONE) {
                return this;
            }
            if (this == NONE) {
                return other;
            }
            if (this == other) {
                return this;
            }
            return PDFA_SPECIFICATION_AND_SCHEMA;
        }

        public String toString() {
            return "namespace definition = " + this.description;
        }
    }
}

