/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAOutputIntentErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetOutputIntent
extends PDFAErrorSet {
    public PDFAErrorSetOutputIntent() {
        super(PDFAOutputIntentErrorCode.class);
    }

    public PDFAErrorSetOutputIntent(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean multipleDestOutputProfiles() {
        return this.errorCodeSet(PDFAOutputIntentErrorCode.multipleDestOutputProfiles);
    }

    public boolean invalidDestOutputProfile() {
        return this.errorCodeSet(PDFAOutputIntentErrorCode.invalidDestOutputProfile);
    }

    public boolean iccProfileVersionNotAllowed() {
        return this.errorCodeSet(PDFAOutputIntentErrorCode.iccProfileVersionNotAllowed);
    }

    public boolean iccProfileCouldNotBeParsed() {
        return this.errorCodeSet(PDFAOutputIntentErrorCode.iccProfileCouldNotBeParsed);
    }

    public boolean objectXMPMetadataInvalid() {
        return this.errorCodeSet(PDFAOutputIntentErrorCode.objectXMPMetadataInvalid);
    }

    public boolean incorrectValueForKeyN() {
        return this.errorCodeSet(PDFAOutputIntentErrorCode.incorrectValueForKeyN);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAOutputIntentErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(10);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.multipleDestOutputProfiles()) {
            violations.add("multiple distinct DestOutputProfiles not allowed in OutputIntents");
        }
        if (this.invalidDestOutputProfile()) {
            violations.add("DestOutputProfile is not a valid ICC profile stream");
        }
        if (this.iccProfileVersionNotAllowed()) {
            violations.add("ICC profile version not allowed");
        }
        if (this.iccProfileCouldNotBeParsed()) {
            violations.add("ICC profile could not be parsed");
        }
        if (this.objectXMPMetadataInvalid()) {
            violations.add("Object XMP metadata is not valid");
        }
        if (this.incorrectValueForKeyN()) {
            violations.add("Incorrect value for Key N");
        }
        return super.toString() + " " + violations;
    }
}

