/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetFont
extends PDFAErrorSet {
    public PDFAErrorSetFont() {
        super(PDFAFontErrorCode.class);
    }

    public PDFAErrorSetFont(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean mismatchedCIDSystemInfo() {
        return this.errorCodeSet(PDFAFontErrorCode.mismatchedCIDSystemInfo);
    }

    public boolean cidSystemInfoMissingEndDef() {
        return this.errorCodeSet(PDFAFontErrorCode.cidSystemInfoMissingEndDef);
    }

    public boolean detectedSkippedChars() {
        return this.errorCodeSet(PDFAFontErrorCode.detectedSkippedChars);
    }

    public boolean type2CIDFontMissingCIDToGIDMap() {
        return this.errorCodeSet(PDFAFontErrorCode.type2CIDFontMissingCIDToGIDMap);
    }

    public boolean type2CIDFontInvalidCIDToGIDMap() {
        return this.errorCodeSet(PDFAFontErrorCode.type2CIDFontInvalidCIDToGIDMap);
    }

    public boolean CMapNotEmbedded() {
        return this.errorCodeSet(PDFAFontErrorCode.CMapNotEmbedded);
    }

    public boolean mismatchedCMapWModes() {
        return this.errorCodeSet(PDFAFontErrorCode.mismatchedCMapWModes);
    }

    public boolean fontNotEmbedded() {
        return this.errorCodeSet(PDFAFontErrorCode.fontNotEmbedded);
    }

    public boolean fontEmbeddingFailedFontNotInFontSet() {
        return this.errorCodeSet(PDFAFontErrorCode.fontEmbeddingFailedFontNotInFontSet);
    }

    public boolean fontEmbeddingFailedGlyphError() {
        return this.errorCodeSet(PDFAFontErrorCode.fontEmbeddingFailedGlyphError);
    }

    public boolean fontEmbeddingFailedPermissionError() {
        return this.errorCodeSet(PDFAFontErrorCode.fontEmbeddingFailedPermissionError);
    }

    public boolean fontEmbeddingFailure() {
        return this.errorCodeSet(PDFAFontErrorCode.fontEmbeddingFailure);
    }

    public boolean fontDataCorrupt() {
        return this.errorCodeSet(PDFAFontErrorCode.fontDataCorrupt);
    }

    public boolean embeddedFontMissingGlyphs() {
        return this.errorCodeSet(PDFAFontErrorCode.embeddedFontMissingGlyphs) || this.errorCodeSet(PDFAFontErrorCode.trueTypeEmbeddedFontCouldNotMapGlyph);
    }

    public boolean missingOrIncompleteCharSet() {
        return this.errorCodeSet(PDFAFontErrorCode.missingOrIncompleteCharSet);
    }

    public boolean missingOrIncompleteCIDSet() {
        return this.errorCodeSet(PDFAFontErrorCode.missingOrIncompleteCIDSet);
    }

    public boolean mismatchedWidthsInfo() {
        return this.errorCodeSet(PDFAFontErrorCode.mismatchedWidthsInfo);
    }

    public boolean predefinedCMapNotIdentityHOrIdentityV() {
        return this.errorCodeSet(PDFAFontErrorCode.predefinedCMapNotIdentityHOrIdentityV);
    }

    public boolean nonSymbolicTrueTypeEncodingDifferencesNotAllowed() {
        return this.errorCodeSet(PDFAFontErrorCode.nonSymbolicTrueTypeEncodingDifferencesNotAllowed);
    }

    public boolean nonSymbolicTrueTypeEncodingNotMacRomanWinAnsi() {
        return this.errorCodeSet(PDFAFontErrorCode.nonSymbolicTrueTypeEncodingNotMacRomanWinAnsi);
    }

    public boolean symbolicTTProgramCmapTableDoesNotHaveOneEntry() {
        return this.errorCodeSet(PDFAFontErrorCode.symbolicTTProgramCmapTableDoesNotHaveOneEntry);
    }

    public boolean symbolicTrueTypeEncodingNotAllowed() {
        return this.errorCodeSet(PDFAFontErrorCode.symbolicTrueTypeEncodingNotAllowed);
    }

    public boolean openTypeFontEmbeddingNotAllowed() {
        return this.errorCodeSet(PDFAFontErrorCode.openTypeFontEmbeddingNotAllowed);
    }

    public boolean missingOrIncompleteWidthsArray() {
        return this.errorCodeSet(PDFAFontErrorCode.missingOrIncompleteWidthsArray);
    }

    public boolean typeAbsentInCMAP() {
        return this.errorCodeSet(PDFAFontErrorCode.typeAbsentInCMAP);
    }

    public boolean typeIncorrectInCMAP() {
        return this.errorCodeSet(PDFAFontErrorCode.typeIncorrectInCMAP);
    }

    public boolean typeAbsentInFont() {
        return this.errorCodeSet(PDFAFontErrorCode.typeAbsentInFont);
    }

    public boolean typeIncorrectInFont() {
        return this.errorCodeSet(PDFAFontErrorCode.typeIncorrectInFont);
    }

    public boolean typeAbsentInCIDFont() {
        return this.errorCodeSet(PDFAFontErrorCode.typeAbsentInCIDFont);
    }

    public boolean typeIncorrectInCIDFont() {
        return this.errorCodeSet(PDFAFontErrorCode.typeIncorrectInCIDFont);
    }

    public boolean typeAbsentInFontDescriptor() {
        return this.errorCodeSet(PDFAFontErrorCode.typeAbsentInFontDescriptor);
    }

    public boolean typeIncorrectInFontDescriptor() {
        return this.errorCodeSet(PDFAFontErrorCode.typeIncorrectInFontDescriptor);
    }

    public boolean malformedFontDictionary() {
        return this.errorCodeSet(PDFAFontErrorCode.malformedFontDictionary);
    }

    public boolean objectXMPMetadataInvalid() {
        return this.errorCodeSet(PDFAFontErrorCode.objectXMPMetadataInvalid);
    }

    public boolean fontSetNotSuppliedForFallbackRaster() {
        return this.errorCodeSet(PDFAFontErrorCode.fontSetNotSuppliedForFallbackRaster);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAFontErrorCode.pdfGeneralFailure);
    }

    public boolean incorrectLengthEntriesInEmbeddedType1Font() {
        return this.errorCodeSet(PDFAFontErrorCode.incorrectLengthEntriesInEmbeddedType1Font);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(20);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.mismatchedCIDSystemInfo()) {
            violations.add("mismatched CIDSystemInfo");
        }
        if (this.cidSystemInfoMissingEndDef()) {
            violations.add("Missing \"end def\" after CIDSystemInfo definition in CMap");
        }
        if (this.detectedSkippedChars()) {
            violations.add("Characters were skipped in the content stream. Content stream should be updated.");
        }
        if (this.type2CIDFontMissingCIDToGIDMap()) {
            violations.add("CIDToGID table is missing in Type2 CID font");
        }
        if (this.type2CIDFontInvalidCIDToGIDMap()) {
            violations.add("CIDToGID table not Identity or stream in Type2 CID font");
        }
        if (this.CMapNotEmbedded()) {
            violations.add("CMap used in Type 0 font is not embedded");
        }
        if (this.mismatchedCMapWModes()) {
            violations.add("mismatched CMap WModes");
        }
        if (this.fontNotEmbedded()) {
            violations.add("font is not embedded");
        }
        if (this.fontEmbeddingFailedFontNotInFontSet()) {
            violations.add("font embedding failed as font is not is found in font set");
        }
        if (this.fontEmbeddingFailedPermissionError()) {
            violations.add("font embedding failed as the font does not have permission for embedding");
        }
        if (this.fontEmbeddingFailedGlyphError()) {
            violations.add("font embedding failed because of errors related to referenced glyphs");
        }
        if (this.fontEmbeddingFailure()) {
            violations.add("failure while embedding font");
        }
        if (this.fontDataCorrupt()) {
            violations.add("font data is corrupt");
        }
        if (this.embeddedFontMissingGlyphs()) {
            violations.add("glyphs missing in embedded font");
        }
        if (this.missingOrIncompleteCharSet()) {
            violations.add("CharSet missing or incomplete for type1 font");
        }
        if (this.missingOrIncompleteCIDSet()) {
            violations.add("CIDSet missing or incomplete for CIDFont");
        }
        if (this.mismatchedWidthsInfo()) {
            violations.add("Width information inconsistent with font program");
        }
        if (this.missingOrIncompleteWidthsArray()) {
            violations.add("Widths array of font is missing or incomplete");
        }
        if (this.symbolicTrueTypeEncodingNotAllowed()) {
            violations.add("Encoding dictionary cannot be present in symbolic TrueType font");
        }
        if (this.nonSymbolicTrueTypeEncodingDifferencesNotAllowed()) {
            violations.add("Encoding dictionary of non-Symbolic TrueType font cannot have Differences array");
        }
        if (this.nonSymbolicTrueTypeEncodingNotMacRomanWinAnsi()) {
            violations.add("Encoding of non-Symbolic TrueType font is not MacRomanEncoding or WinAnsiEncoding");
        }
        if (this.openTypeFontEmbeddingNotAllowed()) {
            violations.add("OpenType font embedding is not allowed");
        }
        if (this.symbolicTTProgramCmapTableDoesNotHaveOneEntry()) {
            violations.add("symbolic TrueType font does not have exactly one encoding in cmap table");
        }
        if (this.predefinedCMapNotIdentityHOrIdentityV()) {
            violations.add("Predefined CMap is not Identity-H or IdentityV");
        }
        if (this.malformedFontDictionary()) {
            violations.add("font dictionary is malformed");
        }
        if (this.typeAbsentInCMAP()) {
            violations.add("required /Type key missing in cmap");
        }
        if (this.typeIncorrectInCMAP()) {
            violations.add("required /Type key set incorrectly in cmap");
        }
        if (this.typeAbsentInFont()) {
            violations.add("required /Type key missing in font");
        }
        if (this.typeIncorrectInFont()) {
            violations.add("required /Type key set incorrectly in font");
        }
        if (this.typeAbsentInCIDFont()) {
            violations.add("required /Type key missing in cid font");
        }
        if (this.typeIncorrectInCIDFont()) {
            violations.add("required /Type key set incorrectly in cid font");
        }
        if (this.typeAbsentInFontDescriptor()) {
            violations.add("required /Type key missing in font descriptor");
        }
        if (this.typeIncorrectInFontDescriptor()) {
            violations.add("required /Type key set incorrectly in font descriptor");
        }
        if (this.objectXMPMetadataInvalid()) {
            violations.add("Object XMP metadata is not valid");
        }
        if (this.fontSetNotSuppliedForFallbackRaster()) {
            violations.add("Could not fallback to Raster creation due to missing fontSet in PDFOpenOptions in PDFDoc object.");
        }
        if (this.incorrectLengthEntriesInEmbeddedType1Font()) {
            violations.add("Incorrect Length entries in embedded Type1 font");
        }
        return super.toString() + " " + violations;
    }
}

