/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAAnnotationErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetAnnotation
extends PDFAErrorSet {
    public PDFAErrorSetAnnotation() {
        super(PDFAAnnotationErrorCode.class);
    }

    public PDFAErrorSetAnnotation(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean annotNotAllowed() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.annotNotAllowed);
    }

    public boolean annotFlagsMissing() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.annotFlagsMissing);
    }

    public boolean annotFlagPrintNotSet() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.annotFlagPrintNotSet);
    }

    public boolean annotFlagHiddenSet() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.annotFlagHiddenSet);
    }

    public boolean annotFlagInvisibleSet() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.annotFlagInvisibleSet);
    }

    public boolean annotFlagNoViewSet() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.annotFlagNoViewSet);
    }

    public boolean textAnnotFlagNoZoomNotSet() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.textAnnotFlagNoZoomNotSet);
    }

    public boolean textAnnotationFlagNoRotateNotSet() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.textAnnotFlagNoRotateNotSet);
    }

    public boolean markupAnnotHasNonAllowedOpacity() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.markupAnnotHasNonAllowedOpacity);
    }

    public boolean actionNotAllowed() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionNotAllowed);
    }

    public boolean additionalActionsNotAllowed() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.additionalActionsNotAllowed);
    }

    public boolean rgbPDFA1DestOuputProfileNotFound() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.rgbPDFA1DestOuputProfileNotFound);
    }

    public boolean normalAppearanceMissing() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.normalAppearanceMissing);
    }

    public boolean nonNormalAppearancesPresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.nonNormalAppearancesPresent);
    }

    public boolean actionLaunchPresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionLaunchNotAllowed);
    }

    public boolean actionSoundPresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionSoundNotAllowed);
    }

    public boolean actionMoviePresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionMovieNotAllowed);
    }

    public boolean actionResetFormNotPresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionResetFormNotAllowed);
    }

    public boolean actionImportDataPresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionImportDataNotAllowed);
    }

    public boolean actionJavaScriptPresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionJavaScriptNotAllowed);
    }

    public boolean actionSetStatePresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionSetStateNotAllowed);
    }

    public boolean actionNoOpPresent() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.actionNoOpNotAllowed);
    }

    public boolean namedActionNotAllowed() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.namedActionNotAllowed);
    }

    public boolean formFieldOfTypeBtnDoesNotHaveMultipleAppearance() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.formFieldOfTypeBtnDoesNotHaveMultipleAppearance);
    }

    public boolean formFieldHasNoAppearanceDefined() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.formFieldHasNoAppearanceDefined);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAAnnotationErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(10);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.annotNotAllowed()) {
            violations.add("annot type not allowed");
        }
        if (this.annotFlagsMissing()) {
            violations.add("annot flags missing");
        }
        if (this.annotFlagPrintNotSet()) {
            violations.add("annot flag Print not set");
        }
        if (this.annotFlagHiddenSet()) {
            violations.add("annot flag Hidden set");
        }
        if (this.annotFlagInvisibleSet()) {
            violations.add("annot flag Invisible set");
        }
        if (this.annotFlagNoViewSet()) {
            violations.add("annot flag NoView set");
        }
        if (this.textAnnotFlagNoZoomNotSet()) {
            violations.add("text annot flag NoZoom set");
        }
        if (this.textAnnotFlagNoZoomNotSet()) {
            violations.add("text annot flag NoRotate set");
        }
        if (this.markupAnnotHasNonAllowedOpacity()) {
            violations.add("markup annot has non-allowed opacity");
        }
        if (this.actionNotAllowed()) {
            violations.add("action not allowed");
        }
        if (this.actionLaunchPresent()) {
            violations.add("action launch not allowed");
        }
        if (this.actionSoundPresent()) {
            violations.add("action sound not allowed");
        }
        if (this.actionMoviePresent()) {
            violations.add("action movie not allowed");
        }
        if (this.actionResetFormNotPresent()) {
            violations.add("action resetform not allowed");
        }
        if (this.actionImportDataPresent()) {
            violations.add("action import data not allowed");
        }
        if (this.actionJavaScriptPresent()) {
            violations.add("action javascript not allowed");
        }
        if (this.actionSetStatePresent()) {
            violations.add("action set state not allowed");
        }
        if (this.actionNoOpPresent()) {
            violations.add("action no-op not allowed");
        }
        if (this.namedActionNotAllowed()) {
            violations.add("Named actions other than NextPage, PrevPage, FirstPage, and LastPage are not allowed.");
        }
        if (this.additionalActionsNotAllowed()) {
            violations.add("additional actions not allowed");
        }
        if (this.rgbPDFA1DestOuputProfileNotFound()) {
            violations.add("RGB GTS_PDFA1 color space not found in DestOutputProfiles");
        }
        if (this.normalAppearanceMissing()) {
            violations.add("normal appearance stream missing");
        }
        if (this.nonNormalAppearancesPresent()) {
            violations.add("non-normal appearances present");
        }
        if (this.formFieldOfTypeBtnDoesNotHaveMultipleAppearance()) {
            violations.add("Form field of type button does not have multiple appearances.");
        }
        if (this.formFieldHasNoAppearanceDefined()) {
            violations.add("Form Field Has No Appearance Defined.");
        }
        return super.toString() + " " + violations;
    }
}

