/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfParser;

import com.adobe.internal.pdftoolkit.color.ColorSpaceCache;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ColorSpaceCacheImpl;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.Map;

class PDFGState
extends GState {
    private double[] fillColorValues;
    private double[] strokeColorValues;
    private String fillTilingPattern = null;
    private String strokeTilingPattern = null;
    private ColorSpaceCache fillPDFColorSpace = null;
    private ColorSpaceCache strokePDFColorSpace = null;
    private String fillShadingPattern = null;
    private String strokeShadingPattern = null;

    PDFGState(Map<String, ColorSpaceCacheImpl> deviceColorSpaces) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.fillPDFColorSpace = deviceColorSpaces.get(GraphicsUtils.DeviceGray);
        this.strokePDFColorSpace = deviceColorSpaces.get(GraphicsUtils.DeviceGray);
    }

    PDFGState(PDFGState gState) {
        super(gState);
        this.fillColorValues = gState.fillColorValues;
        this.strokeColorValues = gState.strokeColorValues;
        this.fillTilingPattern = gState.fillTilingPattern;
        this.strokeTilingPattern = gState.strokeTilingPattern;
        this.fillPDFColorSpace = gState.fillPDFColorSpace;
        this.strokePDFColorSpace = gState.strokePDFColorSpace;
        this.fillShadingPattern = gState.fillShadingPattern;
        this.strokeShadingPattern = gState.strokeShadingPattern;
    }

    Area getClippingArea() {
        return this.clippingArea;
    }

    void setClippingArea(Area area) {
        this.isClipAreaInfinite = false;
        this.clippingArea = area;
    }

    void addPathToClip(Area clipPath) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.isClipAreaInfinite = false;
        if (this.clippingArea == null) {
            this.initClippingArea();
        } else {
            this.clippingArea = (Area)this.clippingArea.clone();
        }
        Path2D.Double p = new Path2D.Double();
        PathIterator pi = this.clippingArea.getPathIterator(null);
        while (!pi.isDone()) {
            double[] coords = new double[7];
            int type = pi.currentSegment(coords);
            double x1 = coords[0];
            double y1 = coords[1];
            double x2 = coords[2];
            double y2 = coords[3];
            double x3 = coords[4];
            double y3 = coords[5];
            if (type == 0) {
                p.moveTo(x1, y1);
            } else if (type == 1) {
                p.lineTo(x1, y1);
            } else if (type == 2) {
                p.quadTo(x1, y1, x2, y2);
            } else if (type == 3) {
                p.curveTo(x1, y1, x2, y2, x3, y3);
            } else if (type == 4) {
                p.closePath();
            }
            pi.next();
        }
        Area newClippingArea = new Area(p);
        newClippingArea.intersect(clipPath);
        this.clippingArea = newClippingArea;
    }

    String getFillTilingPatternName() {
        return this.fillTilingPattern;
    }

    void setFillTilingPatternName(String tilingPattern) {
        this.fillTilingPattern = tilingPattern;
    }

    String getStrokeTilingPatternName() {
        return this.strokeTilingPattern;
    }

    void setStrokeTilingPatternName(String tilingPattern) {
        this.strokeTilingPattern = tilingPattern;
    }

    double[] getFillColorValues() {
        return this.fillColorValues;
    }

    void setFillColorValues(double[] fillColorValues) {
        this.fillColorValues = fillColorValues;
    }

    double[] getStrokeColorValues() {
        return this.strokeColorValues;
    }

    void setStrokeColorValues(double[] strokeColorValues) {
        this.strokeColorValues = strokeColorValues;
    }

    ColorSpaceCache getFillPDFColorSpace() {
        return this.fillPDFColorSpace;
    }

    void setFillPDFColorSpace(ColorSpaceCache fillPDFColorSpace) {
        this.fillPDFColorSpace = fillPDFColorSpace;
    }

    ColorSpaceCache getStrokePDFColorSpace() {
        return this.strokePDFColorSpace;
    }

    void setStrokePDFColorSpace(ColorSpaceCache strokePDFColorSpace) {
        this.strokePDFColorSpace = strokePDFColorSpace;
    }

    public String getFillShadingPattern() {
        return this.fillShadingPattern;
    }

    public void setFillShadingPattern(String fillShadingPattern) {
        this.fillShadingPattern = fillShadingPattern;
    }

    public String getStrokeShadingPattern() {
        return this.strokeShadingPattern;
    }

    public void setStrokeShadingPattern(String strokeShadingPattern) {
        this.strokeShadingPattern = strokeShadingPattern;
    }
}

