/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfParser;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextObject;
import com.adobe.internal.pdftoolkit.services.pdfParser.ContentStreamParser;
import com.adobe.internal.pdftoolkit.services.pdfParser.PDFGState;
import com.adobe.internal.pdftoolkit.services.pdfParser.TransparencyParameterContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

class PDFContentItemsList<G extends GraphicsState, C extends ContentItem<G>>
implements ContentItemsList<G, C> {
    private static final int BUFFERED_OBJECTS_NUM = 100;
    private ArrayList<C> contentItemsList = new ArrayList();
    private ContentStreamProcessor contentParser = null;
    private Content content = null;
    private GState gState = null;
    private boolean processAnnotations = false;
    private ContentReader reader = null;
    private TransparencyParameterContainer transparencyParameterContainer = null;
    private TextObject currentTextObj = null;

    PDFContentItemsList(ContentStreamProcessor contentParser, Content content, GState gState, TransparencyParameterContainer transparencyParameterContainer) {
        this(contentParser, content, gState, transparencyParameterContainer, false);
    }

    PDFContentItemsList(ContentStreamProcessor contentParser, Content content, GState gState, TransparencyParameterContainer transparencyParameterContainer, boolean processAnnotations) {
        this.contentParser = contentParser;
        this.content = content;
        this.gState = gState;
        this.processAnnotations = processAnnotations;
        this.transparencyParameterContainer = transparencyParameterContainer;
    }

    @Override
    public void add(C newItem) {
        this.contentItemsList.add(newItem);
    }

    @Override
    public C get(int index) {
        return (C)((ContentItem)this.contentItemsList.get(index));
    }

    @Override
    public Iterator<C> iterator() {
        return new PDFContentItemsListIterator();
    }

    private class PDFContentItemsListIterator
    implements Iterator<C> {
        private Iterator<C> itr = null;

        private PDFContentItemsListIterator() {
            this.itr = PDFContentItemsList.this.contentItemsList.listIterator(0);
        }

        @Override
        public C next() {
            return (ContentItem)this.itr.next();
        }

        @Override
        public boolean hasNext() {
            if (this.itr.hasNext()) {
                return true;
            }
            int curSize = PDFContentItemsList.this.contentItemsList.size();
            try {
                this.processObjects(100);
            }
            catch (PDFInvalidDocumentException e) {
                throw new PDFRuntimeException(e);
            }
            catch (PDFIOException e) {
                throw new PDFRuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new PDFRuntimeException(e);
            }
            this.itr = PDFContentItemsList.this.contentItemsList.listIterator(curSize);
            if (PDFContentItemsList.this.processAnnotations && !this.itr.hasNext()) {
                PDFContentItemsList.this.processAnnotations = false;
                ((ContentStreamParser)((PDFContentItemsList)PDFContentItemsList.this).contentParser.getOperatorHandler()).currentContentItemsList = PDFContentItemsList.this;
                ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).processAnnotations();
                this.itr = PDFContentItemsList.this.contentItemsList.listIterator(curSize);
                PDFContentItemsList.this.contentParser = null;
            }
            return this.itr.hasNext();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processObjects(int numberOfObjects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            try {
                if (PDFContentItemsList.this.reader != null && !PDFContentItemsList.this.reader.hasNext()) {
                    return;
                }
                ((ContentStreamParser)((PDFContentItemsList)PDFContentItemsList.this).contentParser.getOperatorHandler()).currentContentItemsList = PDFContentItemsList.this;
                try {
                    if (PDFContentItemsList.this.reader == null) {
                        PDFContentItemsList.this.reader = ContentReader.newInstance(PDFContentItemsList.this.content);
                        ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getGraphicsStateStack().push((PDFGState)PDFContentItemsList.this.gState);
                        ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getContentStack().push(PDFContentItemsList.this.content);
                        if (PDFContentItemsList.this.transparencyParameterContainer != null) {
                            ((ContentStreamParser)((PDFContentItemsList)PDFContentItemsList.this).contentParser.getOperatorHandler()).transparencyParameterContainerStack.push(PDFContentItemsList.this.transparencyParameterContainer);
                        }
                    }
                }
                catch (PDFCosParseException e) {
                    if (PDFContentItemsList.this.reader != null && !PDFContentItemsList.this.reader.hasNext() && !PDFContentItemsList.this.processAnnotations) {
                        if (PDFContentItemsList.this.contentParser != null) {
                            ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getGraphicsStateStack().pop();
                            if (!((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getContentStack().isEmpty()) {
                                ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getContentStack().pop();
                            }
                            if (PDFContentItemsList.this.transparencyParameterContainer != null) {
                                ((ContentStreamParser)((PDFContentItemsList)PDFContentItemsList.this).contentParser.getOperatorHandler()).transparencyParameterContainerStack.pop();
                            }
                        }
                        PDFContentItemsList.this.contentParser = null;
                        PDFContentItemsList.this.content = null;
                        PDFContentItemsList.this.gState = null;
                        PDFContentItemsList.this.currentTextObj = null;
                        PDFContentItemsList.this.transparencyParameterContainer = null;
                        try {
                            if (PDFContentItemsList.this.reader.available()) {
                                PDFContentItemsList.this.reader.close();
                            }
                        }
                        catch (IOException e2) {
                            return;
                        }
                    }
                    return;
                }
                catch (PDFIOException e) {
                    if (PDFContentItemsList.this.reader != null && !PDFContentItemsList.this.reader.hasNext() && !PDFContentItemsList.this.processAnnotations) {
                        if (PDFContentItemsList.this.contentParser != null) {
                            ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getGraphicsStateStack().pop();
                            if (!((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getContentStack().isEmpty()) {
                                ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getContentStack().pop();
                            }
                            if (PDFContentItemsList.this.transparencyParameterContainer != null) {
                                ((ContentStreamParser)((PDFContentItemsList)PDFContentItemsList.this).contentParser.getOperatorHandler()).transparencyParameterContainerStack.pop();
                            }
                        }
                        PDFContentItemsList.this.contentParser = null;
                        PDFContentItemsList.this.content = null;
                        PDFContentItemsList.this.gState = null;
                        PDFContentItemsList.this.currentTextObj = null;
                        PDFContentItemsList.this.transparencyParameterContainer = null;
                        try {
                            if (PDFContentItemsList.this.reader.available()) {
                                PDFContentItemsList.this.reader.close();
                            }
                        }
                        catch (IOException e3) {
                            return;
                        }
                    }
                    return;
                }
                int maxSize = PDFContentItemsList.this.contentItemsList.size() + numberOfObjects;
                ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).setCurrentTextObj(PDFContentItemsList.this.currentTextObj);
                while (PDFContentItemsList.this.contentItemsList.size() < maxSize && PDFContentItemsList.this.reader.hasNext()) {
                    PDFContentItemsList.this.contentParser.process(PDFContentItemsList.this.reader.next());
                }
                PDFContentItemsList.this.currentTextObj = ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getCurrentTextObject();
            }
            finally {
                if (PDFContentItemsList.this.reader != null && !PDFContentItemsList.this.reader.hasNext() && !PDFContentItemsList.this.processAnnotations) {
                    if (PDFContentItemsList.this.contentParser != null) {
                        ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getGraphicsStateStack().pop();
                        if (!((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getContentStack().isEmpty()) {
                            ((ContentStreamParser)PDFContentItemsList.this.contentParser.getOperatorHandler()).getContentStack().pop();
                        }
                        if (PDFContentItemsList.this.transparencyParameterContainer != null) {
                            ((ContentStreamParser)((PDFContentItemsList)PDFContentItemsList.this).contentParser.getOperatorHandler()).transparencyParameterContainerStack.pop();
                        }
                    }
                    PDFContentItemsList.this.contentParser = null;
                    PDFContentItemsList.this.content = null;
                    PDFContentItemsList.this.gState = null;
                    PDFContentItemsList.this.currentTextObj = null;
                    PDFContentItemsList.this.transparencyParameterContainer = null;
                    try {
                        if (PDFContentItemsList.this.reader.available()) {
                            PDFContentItemsList.this.reader.close();
                        }
                    }
                    catch (IOException e) {
                        return;
                    }
                }
            }
        }
    }
}

