/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optionalcontent.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfigList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.services.optionalcontent.impl.OCConfig;
import java.util.Iterator;

public class OCProperties
extends PDFOCProperties {
    private OCProperties(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static OCProperties getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        OCProperties pdfObject = (OCProperties)PDFCosObject.getCachedInstance(cosObject, OCProperties.class);
        if (pdfObject == null) {
            pdfObject = new OCProperties(cosObject);
        }
        return pdfObject;
    }

    public boolean hasDynamicOCConfig() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCConfig pdfOCConfig = this.getDefaultOCConfigDict();
        if (pdfOCConfig == null) {
            return false;
        }
        OCConfig ocConfig = OCConfig.getInstance(pdfOCConfig.getCosObject());
        if (ocConfig.isDynamic()) {
            return true;
        }
        PDFOCConfigList configList = this.getOCConfigsArray();
        if (configList == null) {
            return false;
        }
        Iterator configListIterator = configList.iterator();
        while (configListIterator.hasNext()) {
            if (!((OCConfig)configListIterator.next()).isDynamic()) continue;
            return true;
        }
        return false;
    }
}

