/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optionalcontent.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCBaseState;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfigList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCMembership;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCVExpression;
import com.adobe.internal.pdftoolkit.services.optionalcontent.impl.OCConfig;
import com.adobe.internal.pdftoolkit.services.optionalcontent.impl.OCGroup;
import com.adobe.internal.pdftoolkit.services.optionalcontent.impl.OCProperties;
import java.util.Iterator;

public class OCMembership
extends PDFOCMembership {
    public OCMembership(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static OCMembership getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        OCMembership pdfObject = (OCMembership)PDFCosObject.getCachedInstance(cosObject, OCMembership.class);
        if (pdfObject == null) {
            pdfObject = new OCMembership(cosObject);
        }
        return pdfObject;
    }

    @Override
    public ASName getVisibilityPolicy() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName visibilityPolicy = this.getDictionaryNameValue(ASName.k_P);
        if (visibilityPolicy == null) {
            visibilityPolicy = ASName.k_AnyOn;
        }
        return visibilityPolicy;
    }

    public boolean isDynamic() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OCProperties ocProperties;
        if (this.getVisibilityExpression() != null) {
            return true;
        }
        PDFOCProperties pdfOCProperties = this.getPDFDocument().requireCatalog().getOCProperties();
        OCProperties oCProperties = ocProperties = pdfOCProperties == null ? null : OCProperties.getInstance(pdfOCProperties.getCosObject());
        if (ocProperties == null) {
            return false;
        }
        PDFOCConfig pdfOCDefaultConfig = ocProperties.getDefaultOCConfigDict();
        if (pdfOCDefaultConfig == null) {
            return false;
        }
        OCConfig ocConfig = OCConfig.getInstance(pdfOCDefaultConfig.getCosObject());
        if (!this.isVisible(ocConfig, true)) {
            return true;
        }
        PDFOCConfigList configList = ocProperties.getOCConfigsArray();
        if (configList == null) {
            return false;
        }
        Iterator configListIterator = configList.iterator();
        while (configListIterator.hasNext()) {
            if (this.isVisible((OCConfig)configListIterator.next(), false)) continue;
            return true;
        }
        return false;
    }

    private boolean isVisible(OCConfig ocConfig, boolean isDefaultOCConfig) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean result;
        PDFOCVExpression pdfVExpression = this.getVisibilityExpression();
        if (pdfVExpression != null) {
            VisibilitExpressionValue veResult = new VisibilitExpressionValue(false);
            return !this.evalVisibilityExpression(pdfVExpression, ocConfig, veResult) || veResult.isVisible();
        }
        PDFOCGroupList ocgs = this.getOCGs();
        if (ocgs == null) {
            return true;
        }
        int numOCGs = ocgs.size();
        if (numOCGs == 0) {
            return true;
        }
        this.setInitialVisibility(ocConfig, ocgs, isDefaultOCConfig);
        ASName visibilityPolicy = this.getVisibilityPolicy();
        Iterator ocgsIterator = ocgs.iterator();
        if (visibilityPolicy == ASName.k_AllOn) {
            result = true;
            while (ocgsIterator.hasNext() && result) {
                PDFOCGroup pdfOCG = (PDFOCGroup)ocgsIterator.next();
                OCGroup ocg = OCGroup.getInstance(pdfOCG.getCosObject());
                if (ocg.isVisible()) continue;
                result = false;
            }
        } else if (visibilityPolicy == ASName.k_AnyOn) {
            result = false;
            while (ocgsIterator.hasNext() && !result) {
                PDFOCGroup pdfOCG = (PDFOCGroup)ocgsIterator.next();
                OCGroup ocg = OCGroup.getInstance(pdfOCG.getCosObject());
                if (!ocg.isVisible()) continue;
                result = true;
            }
        } else if (visibilityPolicy == ASName.k_AnyOff) {
            result = false;
            while (ocgsIterator.hasNext() && !result) {
                PDFOCGroup pdfOCG = (PDFOCGroup)ocgsIterator.next();
                OCGroup ocg = OCGroup.getInstance(pdfOCG.getCosObject());
                if (ocg.isVisible()) continue;
                result = true;
            }
        } else if (visibilityPolicy == ASName.k_AllOff) {
            result = true;
            while (ocgsIterator.hasNext() && result) {
                PDFOCGroup pdfOCG = (PDFOCGroup)ocgsIterator.next();
                OCGroup ocg = OCGroup.getInstance(pdfOCG.getCosObject());
                if (!ocg.isVisible()) continue;
                result = false;
            }
        } else {
            throw new PDFInvalidDocumentException("Invalid OCMD Visibility Policy");
        }
        return result;
    }

    private void setInitialVisibility(OCConfig ocConfig, PDFOCGroupList ocgs, boolean isDefaultOCConfig) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray offList;
        PDFOCGroupArray onList;
        PDFOCBaseState baseState = ocConfig.getBaseState();
        if (baseState == null) {
            baseState = isDefaultOCConfig ? PDFOCBaseState.ON : PDFOCBaseState.Unchanged;
        }
        if (baseState == PDFOCBaseState.OFF) {
            Iterator ocgsIterator = ocgs.iterator();
            while (ocgsIterator.hasNext()) {
                PDFOCGroup pdfOCG = (PDFOCGroup)ocgsIterator.next();
                if (pdfOCG == null) continue;
                OCGroup ocg = OCGroup.getInstance(pdfOCG.getCosObject());
                ocg.setVisible(false);
            }
        }
        if ((onList = ocConfig.getONList()) != null) {
            for (PDFOCGroup pdfOCG : onList) {
                if (pdfOCG == null) continue;
                OCGroup ocg = OCGroup.getInstance(pdfOCG.getCosObject());
                ocg.setVisible(true);
            }
        }
        if ((offList = ocConfig.getOFFList()) != null) {
            for (PDFOCGroup pdfOCG : offList) {
                if (pdfOCG == null) continue;
                OCGroup ocg = OCGroup.getInstance(pdfOCG.getCosObject());
                ocg.setVisible(false);
            }
        }
    }

    private boolean evalVisibilityExpression(PDFOCVExpression pdfVExpression, OCConfig ocConfig, VisibilitExpressionValue veResult) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfVExpression.getCosObject() instanceof CosDictionary) {
            OCGroup ocg = OCGroup.getInstance(pdfVExpression.getCosObject());
            if (ocg == null) {
                return false;
            }
            veResult.setVisibility(ocg.isVisible());
            return true;
        }
        if (!(pdfVExpression.getCosObject() instanceof CosArray)) {
            return false;
        }
        if (pdfVExpression.getCosArray().size() <= 1) {
            return false;
        }
        ASName operator = pdfVExpression.getOperator();
        if (operator == null) {
            return false;
        }
        boolean validOperands = false;
        if (operator == ASName.k_Not) {
            VisibilitExpressionValue operandResult;
            if (pdfVExpression.getCosArray().size() != 2) {
                return false;
            }
            PDFOCVExpression operand = PDFOCVExpression.getInstance(pdfVExpression.getCosArray().get(1));
            validOperands = this.evalVisibilityExpression(operand, ocConfig, operandResult = new VisibilitExpressionValue(false));
            if (validOperands) {
                veResult.setVisibility(!operandResult.isVisible());
            }
            return validOperands;
        }
        if (operator == ASName.k_And) {
            int numOperands = pdfVExpression.getCosArray().size();
            boolean tempResult = true;
            VisibilitExpressionValue operandResult = new VisibilitExpressionValue(false);
            for (int i = 1; i < numOperands && tempResult; ++i) {
                PDFOCVExpression operand = PDFOCVExpression.getInstance(pdfVExpression.getCosArray().get(i));
                if (!this.evalVisibilityExpression(operand, ocConfig, operandResult)) continue;
                validOperands = true;
                tempResult &= operandResult.isVisible();
            }
            if (validOperands) {
                veResult.setVisibility(tempResult);
            }
            return validOperands;
        }
        if (operator == ASName.k_Or) {
            int numOperands = pdfVExpression.getCosArray().size();
            boolean tempResult = false;
            VisibilitExpressionValue operandResult = new VisibilitExpressionValue(false);
            for (int i = 1; i < numOperands && !tempResult; ++i) {
                PDFOCVExpression operand = PDFOCVExpression.getInstance(pdfVExpression.getCosArray().get(i));
                if (!this.evalVisibilityExpression(operand, ocConfig, operandResult)) continue;
                validOperands = true;
                tempResult |= operandResult.isVisible();
            }
            if (validOperands) {
                veResult.setVisibility(tempResult);
            }
            return validOperands;
        }
        return false;
    }

    private static class VisibilitExpressionValue {
        private boolean visibility;

        private VisibilitExpressionValue(boolean visibil) {
            this.visibility = visibil;
        }

        private boolean isVisible() {
            return this.visibility;
        }

        private void setVisibility(boolean visibil) {
            this.visibility = visibil;
        }
    }
}

