/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Subset;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.PlaceHolderCompositeFontBuilder;

class SimpleTypeEmbedder {
    SimpleTypeEmbedder() {
    }

    static void embedSimpleFontsAsType0Font(Font afeFont, PDFFontSimple simpleFont, Subset fontSubset, PDFFontFile fontFile, PDFCIDFontWidths pdfCIDFontWidths, String newName) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        PDFCIDFont cidFont;
        String psFontName;
        PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
        if (afeFontDesc == null) {
            return;
        }
        CosDictionary dict = simpleFont.getCosDictionary();
        dict.clear();
        PlaceHolderCompositeFontBuilder bldr = new PlaceHolderCompositeFontBuilder(simpleFont.getPDFDocument());
        PDFFontType0 font = bldr.createType0FontFromDict(afeFont, dict);
        PDFDocument pdfDocument = font.getPDFDocument();
        String string = psFontName = afeFontDesc.getBase14Name() != null ? afeFontDesc.getBase14Name() : afeFontDesc.getPostscriptName();
        if (psFontName == null) {
            psFontName = newName;
        }
        ASName subsetFontName = PDFFontUtils.generateSubsetFontName(fontSubset, psFontName);
        PDFFontDescriptor fontDescriptor = PDFFontUtils.generatePDFFontDescriptor(font, afeFontDesc);
        if (!afeFontDesc.pdfFontIsTrueType()) {
            try {
                fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.CIDFontType0C);
            }
            catch (PDFInvalidParameterException pDFInvalidParameterException) {
                // empty catch block
            }
            fontDescriptor.setFontFile3(fontFile);
            cidFont = PDFCIDFont.newInstance(pdfDocument, subsetFontName, ASName.k_CIDFontType0);
        } else {
            fontDescriptor.setFontFile2(fontFile);
            cidFont = PDFCIDFont.newInstance(pdfDocument, subsetFontName, ASName.k_CIDFontType2);
        }
        cidFont.setDW(1000);
        cidFont.setW(pdfCIDFontWidths);
        cidFont.setCIDSystemInfo(PDFCIDSystemInfo.newInstance(pdfDocument, new ASString("Adobe"), new ASString("Identity"), 0));
        fontDescriptor.setFontName(subsetFontName);
        cidFont.setFontDescriptor(fontDescriptor);
        PDFType0FontEncoding encoding = PDFType0FontEncoding.newInstance(pdfDocument, ASName.k_Identity_H);
        font.setEncoding(encoding);
        font.setDescendantFont(cidFont);
        font.setBaseFont(ASName.create(psFontName));
    }
}

