/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderListContent;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionGoTo;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsPage;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedJavaScripts;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedPages;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedTemplates;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFolder;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionUtil;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabels;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTemplate;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.interchange.structure.StructureListener;
import com.adobe.internal.pdftoolkit.services.manipulations.MaxMcid;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMAcroForms;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMBookmark;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMEditablePDF;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOCManager;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMPageLabels;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMPagesMapping;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMStructure;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PDFPageUtils;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PDFPageWrapperSet;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMNamedDestinations;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMPages;
import com.adobe.internal.pdftoolkit.services.xobjhandler.PageContentXObject;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectApplyOptions;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectContentType;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectUseOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PMMService {
    private boolean repaired;
    private MaxMcid maxMcid;
    private PDFDocument inDoc;
    private CosCloneMgr cloneHandler;

    public PMMService(PDFDocument doc) {
        this.inDoc = doc;
        this.cloneHandler = new CosCloneMgr(this.inDoc.getCosDocument());
    }

    public void deletePages(PDFPage fromPage, int pageCount) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (fromPage == null) {
            return;
        }
        int startPageIndex = fromPage.getIndex();
        int lastPageIndex = startPageIndex + pageCount - 1;
        ArrayList<PDFPage> pagesInRange = this.getPageRange(startPageIndex, pageCount);
        PMMBookmark bookmarks = new PMMBookmark(this.inDoc, this.cloneHandler, null);
        bookmarks.deleteBookmarks(pagesInRange);
        PDFPageWrapperSet pageWrapperSet = new PDFPageWrapperSet(pagesInRange);
        PMMStructure logicalStructure = new PMMStructure(this.inDoc, this.cloneHandler);
        logicalStructure.deleteStructure(pagesInRange, pageWrapperSet);
        PMMNamedDestinations dests = new PMMNamedDestinations(this.inDoc, this.cloneHandler, false);
        dests.deleteNamedDestinations(pageWrapperSet);
        PMMAcroForms forms = new PMMAcroForms(this.inDoc, this.cloneHandler, null);
        forms.deleteAcroForm(pagesInRange);
        PMMEditablePDF editablePDFHandler = new PMMEditablePDF(this.inDoc, pagesInRange);
        editablePDFHandler.deletePrivateInfo();
        int origPageCount = this.inDoc.requirePages().getNumPages();
        Iterator<PDFPage> pageIterator = this.inDoc.requirePages().iterator(startPageIndex);
        while (pageCount-- > 0) {
            if (!pageIterator.hasNext()) continue;
            pageIterator.next();
            pageIterator.remove();
        }
        PMMPageLabels pageLabels = new PMMPageLabels(this.inDoc);
        pageLabels.delete(startPageIndex, lastPageIndex, origPageCount);
        PDFOpenAction openAction = this.inDoc.requireCatalog().getOpenAction();
        PDFDestination openDest = null;
        if (openAction != null) {
            if (openAction.isDestination()) {
                openDest = openAction.getDestination();
            } else {
                PDFAction action = openAction.getAction();
                if (action instanceof PDFActionGoTo) {
                    openDest = ((PDFActionGoTo)action).getDestination();
                }
            }
        }
        if (openDest != null && pageWrapperSet.contains(openDest.getPage())) {
            this.inDoc.requireCatalog().setOpenAction(null);
        }
    }

    public PDFDocument extractPages(PDFPage fromPage, int pageCount, PMMOptions pmmOptions, PDFOpenOptions openOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFDocument result = null;
        int startingPageNum = fromPage.getIndex();
        PDFPage[] srcPages = this.populateListOfPages(this.inDoc, startingPageNum, pageCount);
        if (srcPages.length > 0) {
            result = this.extractPages(srcPages, startingPageNum == 0 && pageCount == fromPage.getPDFDocument().requirePages().getNumPages(), pmmOptions, openOptions);
        }
        return result;
    }

    public PDFDocument extractPages(PDFPage[] pageList, PMMOptions pmmOptions, PDFOpenOptions openOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        PDFDocument result = null;
        if (pageList != null) {
            result = this.extractPages(pageList, false, pmmOptions, openOptions);
        }
        return result;
    }

    public void insertPages(PDFDocument srcDoc, PDFPage afterPage, String title, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (srcDoc != null) {
            this.insertPagesinRange(afterPage, null, false, srcDoc.requirePages().getPage(0), srcDoc.requirePages().getNumPages(), true, title, options, null, false, null, null, false);
        }
    }

    public void insertPages(PDFPage afterPage, PDFPage startPage, int count, String title, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        this.insertPages(afterPage, startPage, count, title, options, null);
    }

    public void insertPages(PDFPage afterPage, PDFPage startPage, int count, String title, PMMOptions options, String[] layersWrapping) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (startPage == null) {
            return;
        }
        boolean insertAllBookmarks = startPage.getIndex() == 0 && count == startPage.getPDFDocument().requirePages().getNumPages();
        this.insertPagesinRange(afterPage, null, false, startPage, count, insertAllBookmarks, title, options, layersWrapping, false, null, null, false);
    }

    public void appendPages(PDFDocument srcDoc, String title, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (srcDoc != null) {
            PDFPageTree curPageTree = this.inDoc.requirePages();
            PDFPage lastPage = curPageTree.getLastPage();
            this.insertPagesinRange(lastPage, null, true, srcDoc.requirePages().getPage(0), srcDoc.requirePages().getNumPages(), true, title, options, null, false, null, null, false);
        }
    }

    public void appendTemplatePage(PDFDocument srcDoc, PDFPage templatePage, String title, PMMOptions options, String templateName, String cesPrefix, boolean rename) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (srcDoc != null) {
            PDFPageTree curPageTree = this.inDoc.requirePages();
            PDFPage lastPage = curPageTree.getLastPage();
            this.insertPagesinRange(lastPage, null, true, templatePage, 0, true, title, options, null, true, templateName, cesPrefix, rename);
        }
    }

    public void overlayPages(PDFDocument srcDoc, Map pagesMapping, boolean onTop, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (pagesMapping == null || pagesMapping.isEmpty()) {
            return;
        }
        if (options == null) {
            options = PMMOptions.newInstanceAll();
        }
        Iterator iter = pagesMapping.entrySet().iterator();
        HashMap<PDFPage, PDFXObjectForm> noMap = new HashMap<PDFPage, PDFXObjectForm>();
        Map.Entry entry = null;
        PDFExtGState pdfExtGState = null;
        PDFPage targetPage = null;
        while (iter.hasNext()) {
            entry = iter.next();
            targetPage = (PDFPage)entry.getValue();
            if (pdfExtGState == null) {
                pdfExtGState = PDFExtGState.newInstance(targetPage.getPDFDocument());
                pdfExtGState.setOpacityFill(options.getOpacity());
                pdfExtGState.setOpacityStroke(options.getOpacity());
            }
            this.overlayPageSet(srcDoc, entry.getKey(), targetPage, noMap, onTop, options, pdfExtGState);
        }
    }

    public void overlayPages(PMMPagesMapping pagesMapping, boolean onTop, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (pagesMapping == null) {
            return;
        }
        if (options == null) {
            options = PMMOptions.newInstanceAll();
        }
        PMMPagesMapping.SourceToTargetPagesHandler srcIter = pagesMapping.getSourcePages();
        PDFDocument srcDoc = pagesMapping.getSourceDocument();
        HashMap<PDFPage, PDFXObjectForm> allXObjects = new HashMap<PDFPage, PDFXObjectForm>();
        PDFExtGState pdfExtGState = PDFExtGState.newInstance(pagesMapping.getTargetDocument());
        pdfExtGState.setOpacityFill(options.getOpacity());
        pdfExtGState.setOpacityStroke(options.getOpacity());
        while (srcIter.hasNext()) {
            PDFPage srcPage = srcIter.getSourcePage();
            PDFPage[] targetPages = srcIter.getTargetPages();
            for (int targetInd = 0; targetInd < targetPages.length; ++targetInd) {
                this.overlayPageSet(srcDoc, srcPage, targetPages[targetInd], allXObjects, onTop, options, pdfExtGState);
            }
        }
    }

    public void overlayPages(Map pagesMapping, boolean onTop, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (pagesMapping == null || pagesMapping.isEmpty()) {
            return;
        }
        if (options == null) {
            options = PMMOptions.newInstanceAll();
        }
        Iterator iter = pagesMapping.entrySet().iterator();
        HashMap<PDFPage, PDFXObjectForm> noMap = new HashMap<PDFPage, PDFXObjectForm>();
        Map.Entry entry = null;
        PDFExtGState pdfExtGState = null;
        PDFPage targetPage = null;
        while (iter.hasNext()) {
            entry = iter.next();
            targetPage = (PDFPage)entry.getValue();
            if (pdfExtGState == null) {
                pdfExtGState = PDFExtGState.newInstance(targetPage.getPDFDocument());
                pdfExtGState.setOpacityFill(options.getOpacity());
                pdfExtGState.setOpacityStroke(options.getOpacity());
            }
            this.overlayPageSet(null, entry.getKey(), targetPage, noMap, onTop, options, pdfExtGState);
        }
    }

    public void deleteBookmarks(PDFPage[] pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pages == null || pages.length == 0) {
            return;
        }
        PMMBookmark bookmarksHandler = new PMMBookmark(this.inDoc, null, null);
        bookmarksHandler.deleteBookmarks(Arrays.asList(pages));
    }

    public void deleteFormFields(PDFPage[] pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PMMAcroForms formsHandler = new PMMAcroForms(this.inDoc, null, null);
        formsHandler.deleteAcroForm(Arrays.asList(pages));
    }

    public void deleteFormFields(PDFFieldList fields, boolean excludingList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PMMAcroForms formsHandler = new PMMAcroForms(this.inDoc, null, null);
        formsHandler.deleteAcroForm(fields, excludingList);
    }

    public PDFActionJavaScript copyNamedJavaScript(PDFDocument sourceDocument, ASString sourceName, ASString targetName) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFActionJavaScript targetScript;
        PDFNameDictionary srcNameDict = sourceDocument.requireCatalog().getNameDictionary();
        if (srcNameDict == null) {
            return null;
        }
        PDFNamedJavaScripts srcNamedScripts = srcNameDict.getNamedJavaScripts();
        if (srcNamedScripts == null) {
            return null;
        }
        PDFActionJavaScript srcScript = (PDFActionJavaScript)srcNamedScripts.getEntry(sourceName);
        if (srcScript == null) {
            return null;
        }
        PDFNameDictionary targetNameDict = this.inDoc.requireCatalog().getNameDictionary();
        PDFNamedJavaScripts targetNamedScripts = null;
        if (targetNameDict != null) {
            targetNamedScripts = targetNameDict.getNamedJavaScripts();
            if (targetNamedScripts != null && targetNamedScripts.getEntry(targetName) != null) {
                return null;
            }
        } else {
            targetNameDict = this.inDoc.requireCatalog().procureNameDictionary();
        }
        if ((targetScript = PDFActionJavaScript.getInstance(this.getCloneManager().clone(srcScript.getCosObject()))) != null) {
            targetNamedScripts = targetNameDict.procureNamedJavaScripts();
            targetNamedScripts.addEntry(targetName, targetScript);
        }
        return targetScript;
    }

    public void copyAllNamedJavaScripts(PDFDocument sourceDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFNameDictionary srcNameDict = sourceDocument.requireCatalog().getNameDictionary();
        if (srcNameDict == null) {
            return;
        }
        PDFNamedJavaScripts srcNamedScripts = srcNameDict.getNamedJavaScripts();
        if (srcNamedScripts == null) {
            return;
        }
        Iterator srcScriptsIter = srcNamedScripts.keyIterator();
        while (srcScriptsIter.hasNext()) {
            ASString srcName = (ASString)srcScriptsIter.next();
            this.copyNamedJavaScript(sourceDocument, srcName, srcName);
        }
    }

    public PDFFileSpecification copyNamedEmbeddedFile(PDFDocument sourceDocument, byte[] sourceName, byte[] targetName) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFFileSpecification targetFileSpec;
        PDFNameDictionary srcNameDict = sourceDocument.requireCatalog().getNameDictionary();
        if (srcNameDict == null) {
            return null;
        }
        PDFNamedEmbeddedFiles srcEmbeddedFiles = srcNameDict.getNamedEmbeddedFiles();
        if (srcEmbeddedFiles == null) {
            return null;
        }
        PDFFileSpecification srcFileSpec = srcEmbeddedFiles.getEntry(new ASString(sourceName));
        if (srcFileSpec == null) {
            return null;
        }
        ASString targetNameAS = new ASString(targetName);
        PDFNameDictionary targetNameDict = this.inDoc.requireCatalog().getNameDictionary();
        PDFNamedEmbeddedFiles targetEmbeddedFiles = null;
        if (targetNameDict != null) {
            targetEmbeddedFiles = targetNameDict.getNamedEmbeddedFiles();
            if (targetEmbeddedFiles != null && targetEmbeddedFiles.getEntry(targetNameAS) != null) {
                return null;
            }
        } else {
            targetNameDict = this.inDoc.requireCatalog().procureNameDictionary();
        }
        if ((targetFileSpec = PDFFileSpecification.getInstance(this.getCloneManager().clone(srcFileSpec.getCosObject()))) != null) {
            targetEmbeddedFiles = targetNameDict.procureNamedEmbeddedFiles();
            targetEmbeddedFiles.addEntry(targetNameAS, targetFileSpec);
        }
        return targetFileSpec;
    }

    public void copyAllNamedEmbeddedFiles(PDFDocument sourceDocument) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFNameDictionary srcNameDict = sourceDocument.requireCatalog().getNameDictionary();
        if (srcNameDict == null) {
            return;
        }
        PDFNamedEmbeddedFiles srcEmbeddedFiles = srcNameDict.getNamedEmbeddedFiles();
        if (srcEmbeddedFiles == null) {
            return;
        }
        Iterator srcEmbeddedFilesIter = srcEmbeddedFiles.keyIterator();
        while (srcEmbeddedFilesIter.hasNext()) {
            byte[] srcName = ((ASString)srcEmbeddedFilesIter.next()).getBytes();
            this.copyNamedEmbeddedFile(sourceDocument, srcName, srcName);
        }
    }

    private boolean keyExistsInTargetFolder(List<PDFTree.Entry> targetEmbFiles, String key) throws PDFParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (targetEmbFiles == null) {
            return false;
        }
        for (int i = 0; i < targetEmbFiles.size(); ++i) {
            if (!key.equals(PDFNamedEmbeddedFiles.getFolderFileKey((ASString)targetEmbFiles.get(i).getKey()))) continue;
            return true;
        }
        return false;
    }

    public void copyFolderAndFiles(PDFDocument sourceDocument, PDFCollectionFolder srcFolder, PDFCollectionFolder destFolder, boolean createTopLevelFolder) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (srcFolder == null || sourceDocument == null || destFolder == null) {
            return;
        }
        PDFPortableCollection destCollection = this.inDoc.requireCatalog().getCollection();
        PDFPortableCollection srcCollection = sourceDocument.requireCatalog().getCollection();
        if (destCollection == null || srcCollection == null) {
            return;
        }
        PDFCollectionFolder newFolder = null;
        List<PDFTree.Entry> targetEmbFiles = null;
        try {
            if (createTopLevelFolder) {
                if (destFolder.getChildFolder(srcFolder.getName()) != null) {
                    return;
                }
                newFolder = PDFCollectionFolder.newInstance(destFolder, srcFolder.getName(), srcFolder.getDescription(), null, null, null, null);
            } else {
                newFolder = destFolder;
                targetEmbFiles = PDFCollectionUtil.getEmbeddedFiles(destFolder);
            }
            List<PDFTree.Entry> embFiles = PDFCollectionUtil.getEmbeddedFiles(srcFolder);
            for (int i = 0; i < embFiles.size(); ++i) {
                String key = PDFNamedEmbeddedFiles.getFolderFileKey((ASString)embFiles.get(i).getKey());
                if (this.keyExistsInTargetFolder(targetEmbFiles, key)) continue;
                PDFFileSpecification srcFileSpec = (PDFFileSpecification)embFiles.get(i).getValue();
                PDFFileSpecification targetFileSpec = PDFFileSpecification.getInstance(this.getCloneManager().clone(srcFileSpec.getCosObject()));
                PDFCollectionUtil.addFileToPDFCollectionFolder(key, targetFileSpec, newFolder);
            }
            ArrayList<PDFCollectionFolder> srcChildFolders = srcFolder.getChildren();
            for (PDFCollectionFolder folder : srcChildFolders) {
                this.copyFolderAndFiles(sourceDocument, folder, newFolder, true);
            }
        }
        catch (PDFParseException e) {
            throw new PDFInvalidDocumentException("Invalid Parse Exception: ", e);
        }
    }

    public void copyAllFoldersAndFiles(PDFDocument sourceDocument, boolean createTopLevelFolder) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFNameDictionary srcNameDict = sourceDocument.requireCatalog().getNameDictionary();
        if (srcNameDict == null) {
            return;
        }
        PDFNamedEmbeddedFiles srcEmbeddedFiles = srcNameDict.getNamedEmbeddedFiles();
        if (srcEmbeddedFiles == null) {
            return;
        }
        PDFPortableCollection srcCollection = sourceDocument.requireCatalog().getCollection();
        PDFPortableCollection destCollection = this.inDoc.requireCatalog().getCollection();
        if (srcCollection == null || destCollection == null) {
            this.copyAllNamedEmbeddedFiles(sourceDocument);
        } else {
            PDFCollectionFolder srcRootFolder = srcCollection.getRootFolder();
            PDFCollectionFolder destRootFolder = destCollection.getRootFolder();
            if (srcRootFolder == null) {
                return;
            }
            if (destRootFolder == null) {
                destRootFolder = destCollection.setRootFolder(srcRootFolder.getName(), srcRootFolder.getDescription(), null, null, null, null);
                createTopLevelFolder = false;
            }
            this.copyFolderAndFiles(sourceDocument, srcRootFolder, destRootFolder, createTopLevelFolder);
        }
    }

    public void mergeOCLayers() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCOrderList order;
        PDFOCProperties ocProps = this.inDoc.requireCatalog().getOCProperties();
        if (ocProps == null) {
            return;
        }
        PDFOCConfig defaultConfig = ocProps.getDefaultOCConfigDict();
        PDFOCOrderList pDFOCOrderList = order = defaultConfig == null ? null : defaultConfig.getOrderList();
        if (order == null) {
            return;
        }
        HashMap<PDFOCOrderListContent, PDFOCGroup> ocgs = new HashMap<PDFOCOrderListContent, PDFOCGroup>(order.size());
        HashSet<PDFOCOrderList> seenOCOrders = new HashSet<PDFOCOrderList>();
        PMMOCManager.collectRepeatingOCGs(order, ocgs, seenOCOrders);
        if (!ocgs.isEmpty()) {
            PMMService.replaceDocumentOCGs(this.inDoc, ocgs);
        }
    }

    PDFDocument getPDFDocument() {
        return this.inDoc;
    }

    CosCloneMgr getCloneManager() {
        return this.cloneHandler;
    }

    private void overlayPageSet(PDFDocument srcDoc, Object overlayKey, PDFPage targetPage, Map<PDFPage, PDFXObjectForm> xObjectsMapping, boolean onTop, PMMOptions options, PDFExtGState pdfExtGState) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        Iterator<Map.Entry<PDFPage, PDFPage>> itr;
        if (overlayKey == null || targetPage == null) {
            return;
        }
        boolean isSameDoc = false;
        if (srcDoc == null) {
            isSameDoc = true;
            srcDoc = this.inDoc;
        }
        Map<PDFPage, PDFPage> mapPages = this.createOverlayPageMap(srcDoc, overlayKey, targetPage);
        PMMNamedDestinations curDests = new PMMNamedDestinations(this.inDoc, this.getCloneManager(), !isSameDoc);
        Map<PDFAnnotation, PDFAnnotation> mapAnnots = null;
        Map<PDFFieldNode, PDFFieldNode> mapFields = null;
        if (options.contains(PMMOptions.AnnotationsForms)) {
            HashMap<ASString, PDFDestinationNamed> allDests = new HashMap<ASString, PDFDestinationNamed>();
            HashMap<PDFAction, PDFAction> allActions = new HashMap<PDFAction, PDFAction>();
            HashMap<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions = new HashMap<PDFAdditionalActions, PDFAdditionalActions>();
            PMMPages pages = new PMMPages(this.inDoc, this.getCloneManager());
            mapAnnots = pages.propagateAnnots(mapPages, curDests, allDests, allActions, allAdditionalActions);
            PMMAcroForms forms = new PMMAcroForms(this.inDoc, this.getCloneManager(), pages);
            mapFields = forms.appendAcroForms(srcDoc, mapPages, mapAnnots, curDests, allDests, allActions, allAdditionalActions);
            this.transformAnnotations(mapPages, mapAnnots, options);
        }
        PDFXObjectForm contentXObj = this.createContentXObjects((itr = mapPages.entrySet().iterator()).hasNext() ? itr.next().getKey() : null, targetPage, xObjectsMapping, options);
        if (options.contains(PMMOptions.Structure)) {
            PMMStructure srcStruct = new PMMStructure(srcDoc, this.cloneHandler);
            PMMStructure curStruct = new PMMStructure(this.inDoc, this.cloneHandler);
            if (srcStruct.getRootNode() != null) {
                if (this.maxMcid == null) {
                    this.maxMcid = new MaxMcid(this.inDoc);
                }
                int addMCID = this.maxMcid.getMaxMcid() + 1;
                curStruct.appendStructure(srcStruct, mapPages, mapAnnots, mapFields, null, null, addMCID, this.maxMcid);
                StructureListener maxMCIDCache = StructureListener.getInstance(srcDoc);
                maxMCIDCache.removeCacheMaxMCID(targetPage.getCosObject().getObjNum());
                HashSet seenObjects = new HashSet();
                curStruct.replaceMCIDs(contentXObj, addMCID, seenObjects, this.maxMcid);
            }
        }
        this.overlayContent(contentXObj, targetPage, onTop, options, pdfExtGState);
    }

    private void transformAnnotations(Map<PDFPage, PDFPage> mapPages, Map<PDFAnnotation, PDFAnnotation> mapAnnots, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        for (Map.Entry<PDFPage, PDFPage> entry : mapPages.entrySet()) {
            PDFPage overlayPage = entry.getKey();
            PDFPage targetPage = entry.getValue();
            ASMatrix matrix = this.getOverlayPageTransformation(overlayPage, targetPage, options);
            int targetPageRotation = targetPage.getRotation().getValue();
            int overlayPageRotation = overlayPage.getRotation().getValue();
            int pageDiffRotation = targetPageRotation - overlayPageRotation;
            double rotationAngle = Math.toRadians(pageDiffRotation + options.getRotation().getValue()) % (Math.PI * 2);
            PDFAnnotationList annots = overlayPage.getAnnotationList();
            if (annots == null) continue;
            PDFAnnotationIterator annotsIterator = annots.iterator();
            while (annotsIterator.hasNext()) {
                PDFAnnotation overlayPageAnnot = annotsIterator.next();
                PDFAnnotation clonedAnnot = mapAnnots.get(overlayPageAnnot);
                if (clonedAnnot == null) continue;
                clonedAnnot.transform(matrix, rotationAngle);
            }
        }
    }

    private ASMatrix getOverlayPageTransformation(PDFPage overlayPage, PDFPage targetPage, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix targetPageRotationMatrix;
        ASMatrix overlayPageAlignmentMatrix;
        ASMatrix overlayPageRotationMatrix;
        PDFRectangle overlayPageCropBox = overlayPage.getArtBox();
        double overlayPageCropWidth = overlayPageCropBox.width();
        double overlayPageCropHeight = overlayPageCropBox.height();
        PDFRotation overlayPageRotation = overlayPage.getRotation();
        if (overlayPageRotation == PDFRotation.ROTATE_90) {
            overlayPageRotationMatrix = new ASMatrix(0.0, -1.0, 1.0, 0.0, 0.0, 0.0);
            overlayPageAlignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -overlayPageCropWidth, 0.0);
        } else if (overlayPageRotation == PDFRotation.ROTATE_180) {
            overlayPageRotationMatrix = new ASMatrix(-1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
            overlayPageAlignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -overlayPageCropWidth, -overlayPageCropHeight);
        } else if (overlayPageRotation == PDFRotation.ROTATE_270) {
            overlayPageRotationMatrix = new ASMatrix(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
            overlayPageAlignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, -overlayPageCropHeight);
        } else {
            overlayPageRotationMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            overlayPageAlignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        }
        ASMatrix overlayPageTransformMatrix = overlayPageAlignmentMatrix.concat(overlayPageRotationMatrix);
        PDFRectangle transOverlayPageCropBox = overlayPageCropBox;
        if (overlayPageRotation.getValue() != 0) {
            PDFDocument overlayPageDoc = overlayPage.getPDFDocument();
            ASRectangle asRectangle = overlayPageCropBox.getRectangle().transform(overlayPageTransformMatrix);
            transOverlayPageCropBox = PDFRectangle.newInstance(overlayPageDoc, asRectangle).normalized(overlayPageDoc);
        }
        PDFRotation targetPageRotation = targetPage.getRotation();
        PDFRectangle targetPageCropBox = targetPage.getCropBox();
        double targetPageHeight = targetPageCropBox.height();
        double targetPageWidth = targetPageCropBox.width();
        if (targetPageRotation == PDFRotation.ROTATE_90 || targetPageRotation == PDFRotation.ROTATE_270) {
            double temp = targetPageHeight;
            targetPageHeight = targetPageWidth;
            targetPageWidth = temp;
        }
        double scale = options.getScalingFactor();
        ASMatrix alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, targetPageCropBox.left(), targetPageCropBox.bottom());
        ASMatrix transMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -(scale * transOverlayPageCropBox.left()), -(scale * transOverlayPageCropBox.bottom()));
        ASMatrix rotationMatrix = new ASMatrix(ASMatrix.createIdentityMatrix().rotate(Math.toRadians(options.getRotation().getValue())));
        ASMatrix scaleMatrix = new ASMatrix(scale, 0.0, 0.0, scale, 0.0, 0.0);
        ASCoordinate oldCenter = new ASCoordinate((transOverlayPageCropBox.left() + transOverlayPageCropBox.right()) * scale / 2.0, (transOverlayPageCropBox.bottom() + transOverlayPageCropBox.top()) * scale / 2.0);
        ASCoordinate newCenter = oldCenter.transform(rotationMatrix);
        transMatrix = transMatrix.translate(oldCenter.x() - newCenter.x(), oldCenter.y() - newCenter.y());
        transMatrix = transMatrix.translate(options.getTranslationCoords().x(), options.getTranslationCoords().y());
        if (targetPageRotation == PDFRotation.ROTATE_90) {
            targetPageRotationMatrix = new ASMatrix(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(targetPageHeight, 0.0);
        } else if (targetPageRotation == PDFRotation.ROTATE_180) {
            targetPageRotationMatrix = new ASMatrix(-1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(targetPageWidth, targetPageHeight);
        } else if (targetPageRotation == PDFRotation.ROTATE_270) {
            targetPageRotationMatrix = new ASMatrix(0.0, -1.0, 1.0, 0.0, 0.0, 0.0);
            alignmentMatrix = alignmentMatrix.translate(0.0, targetPageWidth);
        } else {
            targetPageRotationMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        }
        ASMatrix finalMatrix = ASMatrix.createIdentityMatrix();
        finalMatrix = alignmentMatrix.concat(finalMatrix);
        finalMatrix = targetPageRotationMatrix.concat(finalMatrix);
        finalMatrix = transMatrix.concat(finalMatrix);
        finalMatrix = rotationMatrix.concat(finalMatrix);
        finalMatrix = scaleMatrix.concat(finalMatrix);
        finalMatrix = overlayPageRotationMatrix.concat(finalMatrix);
        finalMatrix = overlayPageAlignmentMatrix.concat(finalMatrix);
        return finalMatrix;
    }

    private Map<PDFPage, PDFPage> createOverlayPageMap(PDFDocument srcDoc, Object overlayKey, PDFPage targetPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashMap<PDFPage, PDFPage> result = new HashMap<PDFPage, PDFPage>(1);
        if (srcDoc == null) {
            srcDoc = this.inDoc;
        }
        PDFNameDictionary nameDict = srcDoc.requireCatalog().getNameDictionary();
        PDFNamedTemplates templatesDict = null;
        if (nameDict != null) {
            templatesDict = nameDict.getNamedTemplates();
        }
        PDFPage overlayPage = null;
        if (overlayKey instanceof PDFPage) {
            overlayPage = (PDFPage)overlayKey;
        } else if (overlayKey instanceof ASString) {
            ASString templateName = (ASString)overlayKey;
            if (templatesDict != null) {
                overlayPage = (PDFPage)templatesDict.getEntry(templateName);
            }
        }
        if (overlayPage != null) {
            result.put(overlayPage, targetPage);
        }
        return result;
    }

    private PDFXObjectForm createContentXObjects(PDFPage overlayPage, PDFPage targetPage, Map<PDFPage, PDFXObjectForm> xObjectsMapping, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources clonedResources = null;
        PDFXObjectForm targetContentXObj = xObjectsMapping.get(overlayPage);
        PDFResources srcResources = overlayPage.getResources();
        PDFDocument targetDoc = targetPage.getPDFDocument();
        if (targetContentXObj == null) {
            XObjectUseOptions useOptions = null;
            if (options.hasClipBox()) {
                useOptions = new XObjectUseOptions(options.getClipBox());
            }
            targetContentXObj = PageContentXObject.generateContentXObject(targetDoc, overlayPage, this.getCloneManager(), useOptions);
            if (srcResources != null) {
                PDFResources targetXObjResources;
                PDFDocument sourceDoc = srcResources.getPDFDocument();
                if (overlayPage.getRotation().getValue() != 0) {
                    PDFXObjectForm internalTargetContentXObj = (PDFXObjectForm)targetContentXObj.getResources().getXObjectMap().get(ASName.create("Fm1"));
                    targetXObjResources = internalTargetContentXObj.getResources();
                } else {
                    targetXObjResources = targetContentXObj.getResources();
                }
                if (sourceDoc.requireCatalog().getOCProperties() != null) {
                    PDFOCProperties targetProperties;
                    PMMOptions overlayOptions = PMMOptions.newInstance(options);
                    if (overlayPage.getPDFDocument().equals(targetDoc)) {
                        overlayOptions.disable(PMMOptions.CopyAllOCGs);
                        overlayOptions.enable(PMMOptions.UseTargetOCConfig);
                    }
                    PMMOCManager ocManager = new PMMOCManager(sourceDoc, targetDoc, this.cloneHandler, overlayOptions);
                    clonedResources = targetXObjResources;
                    ocManager.mergeContentResourcesOC(srcResources, clonedResources);
                    if (targetDoc.requireCatalog().getOCProperties() == null && (targetProperties = ocManager.getTargetOCProperties()) != null) {
                        targetProperties.setDefaultOCConfigDict(ocManager.mergeSourceDefaultConfig(null, new HashMap()));
                        targetDoc.requireCatalog().setOCProperties(ocManager.getTargetOCProperties());
                    }
                }
            }
            if (targetContentXObj != null) {
                xObjectsMapping.put(overlayPage, targetContentXObj);
            }
        }
        if (PDFUtil.isPDFCosObjectRefEqual(targetPage, overlayPage)) {
            this.cleanupResourcesCosObjects(srcResources);
            xObjectsMapping.remove(overlayPage);
        }
        return targetContentXObj;
    }

    private void overlayContent(PDFXObjectForm xObject, PDFPage targetPage, boolean onTop, PMMOptions options, PDFExtGState pdfExtGState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (xObject == null) {
            return;
        }
        XObjectApplyOptions xObjectApplyOptions = new XObjectApplyOptions();
        xObjectApplyOptions.setHScale(options.getScalingFactor());
        xObjectApplyOptions.setVScale(options.getScalingFactor());
        xObjectApplyOptions.setPosition(options.getTranslationCoords().x(), options.getTranslationCoords().y());
        xObjectApplyOptions.setRotation(options.getRotation().getValue());
        xObjectApplyOptions.setOpacity(options.getOpacity());
        XObjectUseOptions useOptions = new XObjectUseOptions(onTop, null, XObjectContentType.General);
        xObjectApplyOptions.applyXObjectForm(targetPage, xObject, useOptions, pdfExtGState);
    }

    private void cleanupResourcesCosObjects(PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (resources == null) {
            return;
        }
        Iterator<ASName> resIter = resources.getCosDictionary().keyIterator();
        while (resIter.hasNext()) {
            ASName key = resIter.next();
            this.getCloneManager().removeMapping(resources.getDictionaryCosObjectValue(key));
        }
    }

    private PDFDocument extractPages(PDFPage[] pageList, boolean importAllBookmarks, PMMOptions pmmOptions, PDFOpenOptions openOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        if (pmmOptions == null) {
            pmmOptions = PMMOptions.newInstanceAll();
        }
        HashMap<ASString, PDFDestinationNamed> allDests = new HashMap<ASString, PDFDestinationNamed>();
        LinkedHashMap<PDFAction, PDFAction> allActions = new LinkedHashMap<PDFAction, PDFAction>();
        HashMap<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions = new HashMap<PDFAdditionalActions, PDFAdditionalActions>();
        PDFDocument newDoc = PDFDocument.newInstance(openOptions);
        String lang = this.inDoc.requireCatalog().getLang();
        if (lang != null) {
            newDoc.requireCatalog().setLang(lang);
        }
        CosCloneMgr extractCloneHandler = new CosCloneMgr(newDoc.getCosDocument());
        PMMPages pages = new PMMPages(newDoc, extractCloneHandler);
        Map<PDFPage, PDFPage> mapPages = pages.partiallyAppendPages(null, pageList);
        if (pmmOptions.contains(PMMOptions.BalancePageTree)) {
            newDoc.requirePages().balancePages();
        }
        PMMNamedDestinations curDests = new PMMNamedDestinations(newDoc, extractCloneHandler, false);
        Map<PDFAnnotation, PDFAnnotation> mapAnnots = null;
        if (pmmOptions.contains(PMMOptions.AnnotationsForms)) {
            mapAnnots = pages.propagateAnnots(mapPages, curDests, allDests, allActions, allAdditionalActions);
        }
        LinkedHashMap<PDFBookmarkNode, PDFBookmarkNode> allBookmarks = new LinkedHashMap<PDFBookmarkNode, PDFBookmarkNode>();
        if (pmmOptions.contains(PMMOptions.Bookmarks)) {
            PMMBookmark curMarks = new PMMBookmark(newDoc, extractCloneHandler, pages);
            curMarks.extractBookmarks(this.inDoc, allDests, importAllBookmarks, curDests, mapPages, allActions, allBookmarks);
        }
        Map<PDFFieldNode, PDFFieldNode> mapFields = null;
        if (pmmOptions.contains(PMMOptions.AnnotationsForms)) {
            PMMAcroForms forms = new PMMAcroForms(newDoc, extractCloneHandler, pages);
            mapFields = forms.extractAcroForms(this.inDoc, mapPages, mapAnnots, curDests, allDests, allActions, allAdditionalActions);
        }
        PMMStructure srcStruct = new PMMStructure(this.inDoc, extractCloneHandler);
        PMMStructure curStruct = new PMMStructure(newDoc, extractCloneHandler);
        if (pmmOptions.contains(PMMOptions.Structure) && srcStruct.getRootNode() != null) {
            try {
                curStruct.extractStructure(srcStruct, mapPages, mapFields, mapAnnots, pages.getClonedXObjects(), allBookmarks);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid Structure", e);
            }
        }
        if (pmmOptions.contains(PMMOptions.PageLabels)) {
            PMMPageLabels labelsHandler = new PMMPageLabels(newDoc);
            try {
                labelsHandler.extract(this.inDoc.requireCatalog().getPageLabels(), pageList);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid page labels", e);
            }
        }
        this.applyPageAdditionalActions(pages, mapPages, curDests, allDests, allActions, allAdditionalActions, extractCloneHandler);
        this.fixActionsAnnots(allActions, mapAnnots);
        this.copyAllNamedPages(mapPages, pageList[0].getPDFDocument(), newDoc);
        PMMEditablePDF pieceHandler = new PMMEditablePDF(newDoc, extractCloneHandler, mapPages, pages.getClonedXObjects(), null);
        pieceHandler.mergeWBPieceInfo(this.inDoc);
        PMMOCManager ocHandler = new PMMOCManager(this.inDoc, newDoc, extractCloneHandler, pmmOptions);
        if (ocHandler.getSourceOCProperties() != null) {
            ocHandler.mergePageOC(mapPages, mapAnnots, null);
        }
        return newDoc;
    }

    void insertPagesinRange(PDFPage afterPage, PDFXObject xObjectForPage, boolean appendToEnd, PDFPage startPage, int count, boolean importAllBookmarks, String title, PMMOptions options, String[] wrapOCOrderNames, boolean spawnTemplate, String templateName, String cesPrefix, boolean rename) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (startPage == null) {
            return;
        }
        PDFDocument srcDoc = startPage.getPDFDocument();
        if (options == null) {
            options = PMMOptions.newInstanceAll();
        }
        if (options.isRepairDocument() && !this.repaired) {
            PDFPageUtils.repairPageTree(this.inDoc);
            this.repaired = true;
        }
        HashMap<ASString, PDFDestinationNamed> allDests = new HashMap<ASString, PDFDestinationNamed>();
        LinkedHashMap<PDFAction, PDFAction> allActions = new LinkedHashMap<PDFAction, PDFAction>();
        HashMap<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions = new HashMap<PDFAdditionalActions, PDFAdditionalActions>();
        PMMPages pages = new PMMPages(this.inDoc, this.cloneHandler);
        Map<PDFPage, PDFPage> mapPages = null;
        mapPages = !spawnTemplate ? pages.partiallyAppendPages(srcDoc, afterPage, appendToEnd, startPage, count) : pages.partiallyAppendTemplate(srcDoc, xObjectForPage, afterPage, appendToEnd, startPage, count, templateName);
        if (options.contains(PMMOptions.BalancePageTree)) {
            this.inDoc.requirePages().balancePages();
        }
        PMMNamedDestinations curDests = new PMMNamedDestinations(this.inDoc, this.cloneHandler, true);
        Map<PDFAnnotation, PDFAnnotation> mapAnnots = null;
        if (options.contains(PMMOptions.AnnotationsForms)) {
            mapAnnots = pages.propagateAnnots(mapPages, curDests, allDests, allActions, allAdditionalActions);
        }
        LinkedHashMap<PDFBookmarkNode, PDFBookmarkNode> allBookmarks = new LinkedHashMap<PDFBookmarkNode, PDFBookmarkNode>();
        if (options.contains(PMMOptions.Bookmarks)) {
            PMMBookmark curMarks = new PMMBookmark(this.inDoc, this.cloneHandler, pages);
            curMarks.appendBookmarks(srcDoc, afterPage, startPage, importAllBookmarks, title, allDests, curDests, mapPages, allActions, allBookmarks, afterPage == null);
            PDFBookmarkRoot bRoot = this.inDoc.requireCatalog().getBookmarkRoot();
            if (bRoot != null) {
                int rootCount = 0;
                for (PDFBookmark kid = bRoot.getFirstKid(); kid != null; kid = kid.getNext()) {
                    int c;
                    ++rootCount;
                    if (!kid.hasCount() || (c = kid.getCount()) <= 0) continue;
                    rootCount += c;
                }
                bRoot.setCount(rootCount);
            }
        }
        Map<PDFFieldNode, PDFFieldNode> mapFields = null;
        if (options.contains(PMMOptions.AnnotationsForms)) {
            PMMAcroForms forms = new PMMAcroForms(this.inDoc, this.cloneHandler, pages);
            mapFields = spawnTemplate && rename ? forms.createNewFieldHierarchyForTemplate(srcDoc, mapPages, mapAnnots, curDests, allDests, allActions, allAdditionalActions, cesPrefix) : forms.appendAcroForms(srcDoc, mapPages, mapAnnots, curDests, allDests, allActions, allAdditionalActions);
        }
        if (options.contains(PMMOptions.Structure)) {
            PMMStructure srcStruct = new PMMStructure(srcDoc, this.cloneHandler);
            PMMStructure curStruct = new PMMStructure(this.inDoc, this.cloneHandler);
            if (srcStruct.getRootNode() != null) {
                if (this.maxMcid == null) {
                    this.maxMcid = new MaxMcid(this.inDoc);
                }
                curStruct.appendStructure(srcStruct, mapPages, mapAnnots, mapFields, null, allBookmarks, 0, this.maxMcid);
            }
        }
        if (options.contains(PMMOptions.PageLabels)) {
            PDFPageLabels srcLabels = srcDoc.requireCatalog().getPageLabels();
            int startPageIndex = startPage.getIndex();
            PMMPageLabels targetLabelsHandler = new PMMPageLabels(this.inDoc);
            try {
                targetLabelsHandler.insert(afterPage == null ? -1 : afterPage.getIndex(), startPage.getPDFDocument(), srcLabels, startPageIndex, startPageIndex + count - 1);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException("Invalid page labels cannot be inserted", e);
            }
        }
        this.applyPageAdditionalActions(pages, mapPages, curDests, allDests, allActions, allAdditionalActions, this.cloneHandler);
        this.fixActionsAnnots(allActions, mapAnnots);
        this.copyAllNamedPages(mapPages, startPage.getPDFDocument(), this.inDoc);
        PMMOCManager ocHandler = new PMMOCManager(srcDoc, this.inDoc, this.cloneHandler, options);
        if (ocHandler.getSourceOCProperties() != null) {
            ocHandler.mergePageOC(mapPages, mapAnnots, wrapOCOrderNames);
        }
    }

    private ArrayList<PDFPage> getPageRange(int startPage, int pageCount) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<PDFPage> pageIterator = this.inDoc.requirePages().iterator(startPage);
        ArrayList<PDFPage> pages = new ArrayList<PDFPage>(pageCount);
        while (pageCount-- > 0) {
            if (!pageIterator.hasNext()) continue;
            pages.add(pageIterator.next());
        }
        return pages;
    }

    private void applyPageAdditionalActions(PMMPages pagesHandler, Map<PDFPage, PDFPage> mapPages, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFAction, PDFAction> allActions, Map<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions, CosCloneMgr clonerToUse) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (Map.Entry<PDFPage, PDFPage> entry : mapPages.entrySet()) {
            PDFPage srcPage = entry.getKey();
            PDFPage clonedPage = entry.getValue();
            PDFAdditionalActionsPage clonedActions = (PDFAdditionalActionsPage)pagesHandler.cloneAdditionalActions(clonedPage.getPDFDocument(), clonerToUse, srcPage.getAdditionalActions(), curDests, allDests, mapPages, allActions, allAdditionalActions);
            if (clonedActions == null) continue;
            clonedPage.setAdditionalActions(clonedActions);
        }
    }

    private void fixDeletedDestination(PDFDestination dest, PDFPage[] existingPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDestinationExplicit explicitDest;
        if (dest == null) {
            return;
        }
        PDFDestinationExplicit pDFDestinationExplicit = explicitDest = dest instanceof PDFDestinationExplicit ? (PDFDestinationExplicit)dest : ((PDFDestinationNamed)dest).getExplicitDestination();
        if (explicitDest == null) {
            return;
        }
        PDFPage page = explicitDest.getPage();
        Arrays.sort(existingPages);
        if (Arrays.binarySearch(existingPages, page) < 0) {
            explicitDest.setPage(null);
        }
    }

    private void fixActionsAnnots(Map<PDFAction, PDFAction> allActions, Map<PDFAnnotation, PDFAnnotation> allAnnots) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (allActions == null || allAnnots == null) {
            return;
        }
        for (Map.Entry<PDFAction, PDFAction> entry : allActions.entrySet()) {
            PDFAnnotation refAnnot;
            PDFAction srcAction = entry.getKey();
            if (srcAction.getCosDictionary().containsKey(ASName.k_AN) && (refAnnot = allAnnots.get(PDFAnnotationFactory.getInstance(srcAction.getDictionaryCosObjectValue(ASName.k_AN)))) != null) {
                PDFAction clonedAction = entry.getValue();
                clonedAction.setDictionaryValue(ASName.k_AN, refAnnot);
            }
            if (!srcAction.getCosDictionary().containsKey(ASName.k_T)) continue;
            PDFAction clonedAction = entry.getValue();
            CosObject hide = srcAction.getDictionaryCosObjectValue(ASName.k_T);
            if (hide == null || clonedAction == null) continue;
            if (hide.getType() == 4) {
                clonedAction.setDictionaryASStringValue(ASName.k_T, ((CosString)hide).stringValue());
                continue;
            }
            if (hide.getType() == 6) {
                PDFAnnotation refAnnot2 = allAnnots.get(PDFAnnotationFactory.getInstance(hide));
                clonedAction.setDictionaryValue(ASName.k_T, refAnnot2);
                continue;
            }
            if (hide.getType() != 5) continue;
            Iterator<CosObject> arrayIter = ((CosArray)hide).iterator();
            CosArray hideArray = clonedAction.getPDFDocument().getCosDocument().createCosArray();
            while (arrayIter.hasNext()) {
                PDFAnnotation hideAnnot = PDFAnnotationFactory.getInstance(arrayIter.next());
                PDFAnnotation refAnnot3 = allAnnots.get(hideAnnot);
                if (refAnnot3 == null) continue;
                hideArray.add(refAnnot3.getCosObject());
            }
            if (hideArray.isEmpty()) continue;
            clonedAction.setDictionaryArrayValue(ASName.k_T, hideArray);
        }
    }

    private PDFPage[] populateListOfPages(PDFDocument inDoc, int fromPage, int pageCount) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage[] pageList = new PDFPage[pageCount];
        Iterator<PDFPage> pagesIter = inDoc.requirePages().iterator(fromPage);
        int index = 0;
        while (pagesIter.hasNext() && pageCount-- > 0) {
            pageList[index++] = pagesIter.next();
        }
        pageList = PMMPages.trimArray(pageList, index);
        return pageList;
    }

    public void fixAnnotationsDestinations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTree pageTree = this.getPDFDocument().requireCatalog().getPages();
        if (pageTree == null) {
            return;
        }
        int numPages = pageTree.getNumPages();
        if (numPages == 0) {
            return;
        }
        PDFPage[] allPages = this.populateListOfPages(this.getPDFDocument(), 0, numPages);
        PDFAnnotationIterator annotsIter = pageTree.getAnnotationsIterator();
        while (annotsIter.hasNext()) {
            PDFAdditionalActions widgetAction;
            PDFAnnotation curAnnot = annotsIter.next();
            PDFAction curAction = curAnnot.getAction();
            if (curAction != null) {
                this.checkAction(curAction, allPages);
            } else if (curAnnot instanceof PDFAnnotationLink) {
                PDFDestination dest = ((PDFAnnotationLink)curAnnot).getDestination();
                if (dest instanceof PDFDestinationNamed && (dest = ((PDFDestinationNamed)dest).getExplicitDestination()) == null) {
                    ((PDFAnnotationLink)curAnnot).removeDestination();
                } else {
                    this.fixDeletedDestination(dest, allPages);
                }
            }
            PDFAdditionalActions addAction = curAnnot.getAdditionalActions();
            if (addAction != null && addAction instanceof PDFAdditionalActionsAnnotation) {
                this.checkAction(((PDFAdditionalActionsAnnotation)addAction).getActionOnButtonDown(), allPages);
                this.checkAction(((PDFAdditionalActionsAnnotation)addAction).getActionOnButtonUp(), allPages);
                this.checkAction(((PDFAdditionalActionsAnnotation)addAction).getActionOnCursorEnters(), allPages);
                this.checkAction(((PDFAdditionalActionsAnnotation)addAction).getActionOnCursorExits(), allPages);
                this.checkAction(((PDFAdditionalActionsAnnotation)addAction).getActionOnPageClose(), allPages);
                this.checkAction(((PDFAdditionalActionsAnnotation)addAction).getActionOnPageInvisible(), allPages);
                this.checkAction(((PDFAdditionalActionsAnnotation)addAction).getActionOnPageOpen(), allPages);
                this.checkAction(((PDFAdditionalActionsAnnotation)addAction).getActionOnPageVisable(), allPages);
            }
            if (!(curAnnot instanceof PDFAnnotationWidget) || (widgetAction = ((PDFAnnotationWidget)curAnnot).getAdditionalActions()) == null || !(widgetAction instanceof PDFAdditionalActionsWidget)) continue;
            this.checkAction(((PDFAdditionalActionsWidget)widgetAction).getActionInFocus(), allPages);
        }
    }

    public void fixBookmarksDestinations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument inDoc = this.getPDFDocument();
        PDFBookmarkRoot root = inDoc.requireCatalog().getBookmarkRoot();
        if (root == null) {
            return;
        }
        PDFPage[] allPages = this.populateListOfPages(this.getPDFDocument(), 0, inDoc.requirePages().getNumPages());
        if (allPages.length > 0) {
            this.checkBookmarksDestinations(root.getFirstKid(), allPages);
        }
    }

    public void fixPagesDestinations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage[] allPages = this.populateListOfPages(this.getPDFDocument(), 0, this.inDoc.requirePages().getNumPages());
        if (allPages.length > 0) {
            Iterator<PDFPage> pagesIterator = this.getPDFDocument().requirePages().iterator();
            while (pagesIterator.hasNext()) {
                PDFPage curPage = pagesIterator.next();
                PDFAdditionalActionsPage addAction = curPage.getAdditionalActions();
                if (addAction == null) continue;
                this.checkAction(addAction.getActionOnClose(), allPages);
                this.checkAction(addAction.getActionOnOpen(), allPages);
            }
        }
    }

    private void checkBookmarksDestinations(PDFBookmark root, PDFPage[] existingPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (root == null) {
            return;
        }
        this.fixDeletedDestination(root.getDestination(), existingPages);
        this.checkBookmarksDestinations(root.getNext(), existingPages);
        this.checkBookmarksDestinations(root.getFirstKid(), existingPages);
    }

    private void checkAction(PDFAction curAction, PDFPage[] existingPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (curAction != null && curAction instanceof PDFActionGoTo) {
            this.fixDeletedDestination(((PDFActionGoTo)curAction).getDestination(), existingPages);
        }
    }

    private void copyAllNamedPages(Map<PDFPage, PDFPage> pagesMap, PDFDocument fromDoc, PDFDocument toDoc) throws PDFIOException, PDFUnsupportedFeatureException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFNameDictionary srcNames = fromDoc.requireCatalog().getNameDictionary();
        if (srcNames == null) {
            return;
        }
        PDFNamedPages srcPages = srcNames.getNamedPages();
        if (srcPages == null) {
            return;
        }
        PDFTree targetPages = null;
        Iterator<PDFTree.Entry> srcPagesIter = srcPages.iterator();
        while (srcPagesIter.hasNext()) {
            PDFPage sourcePage;
            PDFPage targetPage;
            PDFTree.Entry srcItem = srcPagesIter.next();
            ASString key = (ASString)srcItem.getKey();
            if (targetPages == null) {
                PDFNameDictionary targetNames = toDoc.requireCatalog().procureNameDictionary();
                targetPages = targetNames.procureNamedPages();
            }
            if (targetPages.getEntry(key) != null || (targetPage = pagesMap.get(sourcePage = (PDFPage)srcItem.getValue())) == null) continue;
            targetPages.addEntry(key, targetPage);
        }
    }

    public void copyAllTemplatePages(PDFDocument srcDoc) throws PDFIOException, PDFUnsupportedFeatureException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFInvalidParameterException {
        PDFNameDictionary srcNames = srcDoc.requireCatalog().getNameDictionary();
        if (srcNames == null) {
            return;
        }
        PDFNamedTemplates srcPages = srcNames.getNamedTemplates();
        if (srcPages == null) {
            return;
        }
        PDFTree targetPages = null;
        Iterator<PDFTree.Entry> srcPagesIter = srcPages.iterator();
        PMMPages pagesHandler = new PMMPages(this.inDoc, this.cloneHandler);
        LinkedHashMap<PDFPage, PDFPage> pagesMap = new LinkedHashMap<PDFPage, PDFPage>();
        HashMap<PDFAction, PDFAction> allActions = new HashMap<PDFAction, PDFAction>();
        HashMap<PDFAdditionalActions, PDFAdditionalActions> additionalActions = new HashMap<PDFAdditionalActions, PDFAdditionalActions>();
        while (srcPagesIter.hasNext()) {
            PDFTemplate sourcePage;
            PDFTemplate targetPage;
            PDFTree.Entry srcItem = srcPagesIter.next();
            ASString key = (ASString)srcItem.getKey();
            if (targetPages == null) {
                PDFNameDictionary targetNames = this.inDoc.requireCatalog().procureNameDictionary();
                targetPages = targetNames.procureNamedTemplates();
            }
            if (targetPages.getEntry(key) != null || (targetPage = (PDFTemplate)pagesHandler.clonePage(sourcePage = (PDFTemplate)srcItem.getValue())) == null) continue;
            targetPages.addEntry(key, targetPage);
            pagesMap.put(sourcePage, targetPage);
        }
        pagesHandler.propagateAnnots(pagesMap, new PMMNamedDestinations(this.inDoc, this.cloneHandler, false), null, allActions, additionalActions);
    }

    public void copyTemplatePage(PDFDocument srcDoc, byte[] srcName, byte[] targetName) throws PDFIOException, PDFUnsupportedFeatureException, PDFSecurityException, PDFConfigurationException, PDFUnableToCompleteOperationException, PDFInvalidDocumentException {
        PDFTemplate sourcePage;
        PDFTemplate targetPage;
        PDFNameDictionary srcNames = srcDoc.requireCatalog().getNameDictionary();
        if (srcNames == null) {
            return;
        }
        PDFNamedTemplates srcPages = srcNames.getNamedTemplates();
        if (srcPages == null) {
            return;
        }
        ASString srcKey = new ASString(srcName);
        ASString targetKey = new ASString(targetName);
        PDFNameDictionary targetNames = this.inDoc.requireCatalog().procureNameDictionary();
        PDFNamedTemplates targetPages = targetNames.getNamedTemplates();
        if (targetPages != null && targetPages.hasEntry(targetKey)) {
            return;
        }
        PMMPages pagesHandler = new PMMPages(this.inDoc, this.cloneHandler);
        LinkedHashMap<PDFPage, PDFPage> pagesMap = new LinkedHashMap<PDFPage, PDFPage>();
        HashMap<PDFAction, PDFAction> allActions = new HashMap<PDFAction, PDFAction>();
        HashMap<PDFAdditionalActions, PDFAdditionalActions> additionalActions = new HashMap<PDFAdditionalActions, PDFAdditionalActions>();
        if (targetPages == null) {
            targetPages = targetNames.procureNamedTemplates();
        }
        if ((targetPage = (PDFTemplate)pagesHandler.clonePage(sourcePage = (PDFTemplate)srcPages.getEntry(srcKey))) != null) {
            try {
                targetPages.addEntry(targetKey, targetPage);
                pagesMap.put(sourcePage, targetPage);
            }
            catch (PDFInvalidParameterException pDFInvalidParameterException) {
                // empty catch block
            }
        }
        pagesHandler.propagateAnnots(pagesMap, new PMMNamedDestinations(this.inDoc, this.cloneHandler, false), null, allActions, additionalActions);
    }

    public static void replaceDocumentOCGs(PDFDocument pdfDoc, Map ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<PDFPage> pageIter = pdfDoc.requirePages().iterator();
        while (pageIter.hasNext()) {
            PDFPage sourcePage = pageIter.next();
            PDFResources sourceResources = sourcePage.getResources();
            HashSet seenReplacedObjects = new HashSet();
            PMMOCManager.replaceResourcesOC(ocgs, sourceResources, seenReplacedObjects);
            PDFAnnotationList annots = sourcePage.getAnnotationList();
            if (annots == null) continue;
            PDFAnnotationIterator annotIter = annots.iterator();
            while (annotIter.hasNext()) {
                PDFAnnotation sourceAnnot = annotIter.next();
                PMMOCManager.replacePageAnnotationOC(ocgs, sourceAnnot, seenReplacedObjects);
            }
        }
        PMMOCManager.cleanupDocumentOCGs(ocgs, pdfDoc.requireCatalog().getOCProperties());
    }
}

