/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedPages;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedTemplates;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PMMPagesMapping {
    private Map<PDFPage, PDFPage[]> mMapping = new LinkedHashMap<PDFPage, PDFPage[]>();
    private PDFDocument mSrcDoc;
    private PDFDocument mTargetDoc;

    private PMMPagesMapping(PDFDocument srcDoc, PDFDocument targetDoc) {
        this.mSrcDoc = srcDoc;
        this.mTargetDoc = targetDoc;
    }

    public static PMMPagesMapping newInstance(PDFPage srcPage, PDFPage targetPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PMMPagesMapping mapping = new PMMPagesMapping(srcPage.getPDFDocument(), targetPage.getPDFDocument());
        mapping.add(srcPage, targetPage);
        return mapping;
    }

    public static PMMPagesMapping newInstance(PDFPage srcPage, PDFPage[] targetPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PMMPagesMapping mapping = new PMMPagesMapping(srcPage.getPDFDocument(), targetPages[0].getPDFDocument());
        mapping.add(srcPage, targetPages);
        return mapping;
    }

    public static PMMPagesMapping newInstance(PDFDocument srcDoc, byte[] srcTempate, PDFPage[] targetPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PMMPagesMapping mapping = new PMMPagesMapping(srcDoc, targetPages[0].getPDFDocument());
        mapping.add(srcTempate, targetPages);
        return mapping;
    }

    public static PMMPagesMapping newInstance(PDFDocument srcDoc, byte[] srcTempate, PDFPage targetPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PMMPagesMapping mapping = new PMMPagesMapping(srcDoc, targetPage.getPDFDocument());
        mapping.add(srcTempate, targetPage);
        return mapping;
    }

    public void add(byte[] srcTempate, PDFPage[] targetPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PDFNamedPages pages;
        PDFPage srcPage = null;
        PDFNameDictionary names = this.mSrcDoc.requireCatalog().getNameDictionary();
        if (names == null) {
            return;
        }
        PDFNamedTemplates templates = names.getNamedTemplates();
        if (templates != null) {
            srcPage = (PDFPage)templates.getEntry(new ASString(srcTempate));
        }
        if (srcPage == null && (pages = names.getNamedPages()) != null) {
            srcPage = (PDFPage)pages.getEntry(new ASString(srcTempate));
        }
        if (srcPage == null) {
            return;
        }
        this.add(srcPage, targetPages);
    }

    public void add(byte[] srcTempate, PDFPage targetPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnsupportedFeatureException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PDFPage[] pages = new PDFPage[]{targetPage};
        this.add(srcTempate, pages);
    }

    public void add(PDFPage srcPage, PDFPage[] targetPages) throws PDFInvalidParameterException {
        if (!srcPage.getPDFDocument().equals(this.mSrcDoc)) {
            throw new PDFInvalidParameterException("source page is not in the same document as other source pages");
        }
        for (int pagesInd = 0; pagesInd < targetPages.length; ++pagesInd) {
            if (targetPages[pagesInd].getPDFDocument().equals(this.mTargetDoc)) continue;
            throw new PDFInvalidParameterException("target page is not in the same document as other target pages");
        }
        this.mMapping.put(srcPage, targetPages);
    }

    public void add(PDFPage srcPage, PDFPage targetPage) throws PDFInvalidParameterException {
        PDFPage[] pages = new PDFPage[]{targetPage};
        this.add(srcPage, pages);
    }

    SourceToTargetPagesHandler getSourcePages() {
        return new SourceToTargetPagesHandler();
    }

    PDFDocument getSourceDocument() {
        return this.mSrcDoc;
    }

    PDFDocument getTargetDocument() {
        return this.mTargetDoc;
    }

    class SourceToTargetPagesHandler {
        private Iterator<PDFPage> mSrcPagesIter;
        private PDFPage mSrcPage = null;
        private PDFPage[] mTargetPages = null;

        private SourceToTargetPagesHandler() {
            this.mSrcPagesIter = PMMPagesMapping.this.mMapping.keySet().iterator();
        }

        boolean hasNext() {
            if (!this.mSrcPagesIter.hasNext()) {
                return false;
            }
            this.mSrcPage = this.mSrcPagesIter.next();
            this.mTargetPages = (PDFPage[])PMMPagesMapping.this.mMapping.get(this.mSrcPage);
            return true;
        }

        PDFPage getSourcePage() throws PDFInvalidParameterException {
            if (this.mSrcPage == null) {
                throw new PDFInvalidParameterException("Source Page not found");
            }
            return this.mSrcPage;
        }

        PDFPage[] getTargetPages() throws PDFInvalidParameterException {
            if (this.mTargetPages == null) {
                throw new PDFInvalidParameterException("Target Pages not found");
            }
            return this.mTargetPages;
        }
    }
}

