/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript.security;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import org.mozilla.javascript.GeneratedClassLoader;

public class JSClassLoader
extends SecureClassLoader
implements GeneratedClassLoader {
    protected URL documentURL;
    protected CodeSource codeSource;
    protected AccessControlContext rhinoAccessControlContext;

    public JSClassLoader(ClassLoader parent, ProtectionDomain permissions) {
        super(parent);
        this.rhinoAccessControlContext = new AccessControlContext(new ProtectionDomain[]{permissions});
    }

    static URL[] getURL(ClassLoader parent) {
        if (parent instanceof JSClassLoader) {
            URL documentURL = ((JSClassLoader)parent).documentURL;
            if (documentURL != null) {
                return new URL[]{documentURL};
            }
            return new URL[0];
        }
        return new URL[0];
    }

    public Class defineClass(String name, byte[] data) {
        return super.defineClass(name, data, 0, data.length, this.codeSource);
    }

    public void linkClass(Class clazz) {
        super.resolveClass(clazz);
    }

    public AccessControlContext getAccessControlContext() {
        return this.rhinoAccessControlContext;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection perms = null;
        if (codesource != null) {
            perms = super.getPermissions(codesource);
        }
        if (this.documentURL != null && perms != null) {
            int dirEnd;
            String path;
            Permission p = null;
            FilePermission dirPerm = null;
            try {
                p = this.documentURL.openConnection().getPermission();
            }
            catch (IOException e) {
                p = null;
            }
            if (p instanceof FilePermission && !(path = p.getName()).endsWith(File.separator) && (dirEnd = path.lastIndexOf(File.separator)) != -1) {
                path = path.substring(0, dirEnd + 1);
                path = path + "-";
                dirPerm = new FilePermission(path, "read");
                perms.add(dirPerm);
            }
        }
        return perms;
    }
}

