/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript.model;

import com.adobe.internal.pdftoolkit.services.javascript.EventObject;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.Wrapper;

public class JSUtils {
    private JSUtils() {
    }

    private static Object jsToJava(Object jsObj, Context context) {
        try {
            if (jsObj == null || jsObj == Undefined.instance || jsObj == Scriptable.NOT_FOUND) {
                return null;
            }
            if (jsObj instanceof Wrapper) {
                return ((Wrapper)jsObj).unwrap();
            }
            if (jsObj instanceof ScriptableObject) {
                ScriptableObject scriptObj = (ScriptableObject)jsObj;
                return JSUtils.scriptableToJava(scriptObj, context);
            }
            return jsObj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object scriptableToJava(ScriptableObject scriptObj, Context context) throws IllegalAccessException, NoSuchFieldException {
        if (ScriptRuntime.isArrayObject(scriptObj)) {
            Object[] arrayElements = context.getElements(scriptObj);
            if (scriptObj.getIds().length == 0 || arrayElements.length == scriptObj.getIds().length) {
                for (int i = 0; i < arrayElements.length; ++i) {
                    arrayElements[i] = JSUtils.jsToJava(arrayElements[i], context);
                }
                return arrayElements;
            }
            Object[] ids = scriptObj.getIds();
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < ids.length; ++i) {
                String key = ids[i].toString();
                Object value = scriptObj.get(key, (Scriptable)scriptObj);
                if (value.getClass().equals(UniqueTag.class)) {
                    value = scriptObj.get(Integer.parseInt(key), (Scriptable)scriptObj);
                }
                map.put(ids[i], JSUtils.jsToJava(value, context));
            }
            return map;
        }
        String jsClassName = scriptObj.getClassName();
        if ("Object".equals(jsClassName)) {
            Object[] ids = scriptObj.getIds();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < ids.length; ++i) {
                String key = ids[i].toString();
                Object value = scriptObj.get(key, (Scriptable)scriptObj);
                map.put(key, JSUtils.jsToJava(value, context));
            }
            return map;
        }
        if ("Function".equals(jsClassName) && scriptObj instanceof NativeFunction) {
            NativeFunction func = (NativeFunction)scriptObj;
            return Decompiler.decompile(func.getEncodedSource(), 2, new UintMap());
        }
        Class clazz = (Class)ScriptRuntime.class.getDeclaredField(jsClassName + "Class").get(scriptObj);
        return Context.jsToJava(scriptObj, clazz);
    }

    public static boolean esIsOperationAllowed(DocumentContext docContext, EventObject event, HashMap<ESTriggerType, String> valid, boolean bReaderIsOkay) {
        boolean bOkay = false;
        if (valid != null && event != null) {
            String esName = event.getName();
            String esType = event.getType();
            if (esName != null && esType != null) {
                Set<Map.Entry<ESTriggerType, String>> entrySet = valid.entrySet();
                Iterator<Map.Entry<ESTriggerType, String>> itr = entrySet.iterator();
                ESTriggerType triggerType = null;
                String triggerName = null;
                while (itr.hasNext()) {
                    Map.Entry<ESTriggerType, String> entry = itr.next();
                    triggerType = entry.getKey();
                    triggerName = entry.getValue();
                    if (triggerType == null || !triggerType.getValue().equals(esType) || triggerName != null && !triggerName.equals(esName)) continue;
                    bOkay = true;
                    break;
                }
            }
        } else {
            bOkay = true;
        }
        return bOkay;
    }

    public static EventObject setEventTargetToDoc(JavaScriptHandler jsHandler) {
        jsHandler.getContextFactory().enterContext();
        try {
            EventObject event = (EventObject)ESObject.create(jsHandler.getDocLevelScope(), true, "EventObject", true, "event");
            event.setTarget(jsHandler.getDocLevelScope());
            EventObject eventObject = event;
            return eventObject;
        }
        finally {
            Context.exit();
        }
    }

    public static enum ESTrigger {
        ESTRIGGER_KEYSTROKE_STR("Keystroke"),
        ESTRIGGER_VALIDATE_STR("Validate"),
        ESTRIGGER_FOCUS_STR("Focus"),
        ESTRIGGER_BLUR_STR("Blur"),
        ESTRIGGER_FORMAT_STR("Format"),
        ESTRIGGER_CALCULATE_STR("Calculate"),
        ESTRIGGER_MOUSEUP_STR("Mouse Up"),
        ESTRIGGER_MOUSEDOWN_STR("Mouse Down"),
        ESTRIGGER_MOUSEENTER_STR("Mouse Enter"),
        ESTRIGGER_MOUSEEXIT_STR("Mouse Exit"),
        ESTRIGGER_OPEN_STR("Open"),
        ESTRIGGER_CLOSE_STR("Close"),
        ESTRIGGER_WILLSAVE_STR("Will Save"),
        ESTRIGGER_DIDSAVE_STR("Did Save"),
        ESTRIGGER_WILLPRINT_STR("Will Print"),
        ESTRIGGER_DIDPRINT_STR("Did Print"),
        ESTRIGGER_INIT_STR("Init"),
        ESTRIGGER_EXEC_STR("Exec"),
        ESTRIGGER_INVIEW_STR("InView"),
        ESTRIGGER_OUTVIEW_STR("OutView");

        private String value;

        private ESTrigger(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ESTriggerType {
        ESTRIGGERTYPE_BATCH_STR("Batch"),
        ESTRIGGERTYPE_CONSOLE_STR("Console"),
        ESTRIGGERTYPE_APP_STR("App"),
        ESTRIGGERTYPE_DOC_STR("Doc"),
        ESTRIGGERTYPE_PAGE_STR("Page"),
        ESTRIGGERTYPE_EXTERNAL_STR("External"),
        ESTRIGGERTYPE_INTERNAL_STR("Internal"),
        ESTRIGGERTYPE_BOOKMARK_STR("Bookmark"),
        ESTRIGGERTYPE_LINK_STR("Link"),
        ESTRIGGERTYPE_FIELD_STR("Field"),
        ESTRIGGERTYPE_MENU_STR("Menu"),
        ESTRIGGERTYPE_SCREENANNOT_STR("Screen"),
        ESTRIGGERTYPE_MEDIAPLAYER_STR("MediaPlayer"),
        ESTRIGGERTYPE_SEARCH_STR("Search"),
        ESTRIGGERTYPE_OCG_STR("OCG"),
        AVTRIGGERTYPE_Annot_STR("Annot");

        private String value;

        private ESTriggerType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

