/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript.jsmesh;

import com.adobe.internal.pdftoolkit.services.javascript.jsmesh.JSMeshRow;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JSMesh
extends DefaultHandler {
    static Map<String, JSMeshRow> jsMap = new HashMap<String, JSMeshRow>();
    private static JSMeshRow currentRow;
    private int columnCount = 1;
    private boolean isFirstTime = true;
    private boolean rowStart = false;
    private boolean createJSRow = false;
    private boolean isInsideCell = false;
    private StringBuilder input = null;
    private boolean requireBuffer = false;
    private static FileWriter logWriter;
    private static HashMap<String, HashMap<String, HashMap<Integer, JSMeshRow>>> paramGeneratorMap;
    private static Set<String> functions;
    static Map<String, String> aliasMap;

    public static HashMap<String, HashMap<String, HashMap<Integer, JSMeshRow>>> getParamGeneratorMap() {
        return paramGeneratorMap;
    }

    public static void run() {
        functions.add("Icon");
        functions.add("Sound");
        functions.add("Bookmark");
        functions.add("App");
        functions.add("Console");
        functions.add("SeedValue");
        functions.add("Doc");
        functions.add("Error");
        functions.add("EScriptString");
        functions.add("Field");
        JSMesh jsMesh = new JSMesh();
        JSMesh.parseDocument(jsMesh);
        aliasMap = new HashMap<String, String>();
        JSMesh.putAliasNames();
    }

    private static void putAliasNames() {
        aliasMap.put("Annotation", "Markup");
    }

    private static void parseDocument(JSMesh jsMesh) {
        try {
            SAXParser sp = XMLUtils.getNonValidatingSaxParser();
            sp.parse(JSMesh.class.getResourceAsStream("JSAPI.xml"), (DefaultHandler)jsMesh);
        }
        catch (SAXException se) {
            throw new RuntimeException("A parsing error occurred. JS API XML file specified isn't a valid input", se);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Issues in parser configuration", pce);
        }
        catch (IOException ie) {
            throw new RuntimeException("Exception in accessing xml input files", ie);
        }
        finally {
            if (logWriter != null) {
                try {
                    logWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Map<String, JSMeshRow> getJSMap() {
        return jsMap;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempVal = new String(ch, start, length);
        this.input = this.requireBuffer ? this.input.append(tempVal) : new StringBuilder(tempVal);
        this.requireBuffer = true;
    }

    private void setCurrentRow() {
        if (this.input.length() != 0) {
            String value = this.input.toString();
            if (this.isInsideCell) {
                switch (this.columnCount) {
                    case 1: {
                        currentRow.setName(value);
                        break;
                    }
                    case 2: {
                        currentRow.setAccess(value);
                        break;
                    }
                    case 3: {
                        currentRow.setDeprecated(this.processBooleanValue(value));
                        break;
                    }
                    case 4: {
                        currentRow.setUndocumented(this.processBooleanValue(value));
                        break;
                    }
                    case 5: {
                        currentRow.setPref(this.processBooleanValue(value));
                        break;
                    }
                    case 6: {
                        currentRow.setPrivTriggers(this.processPrivilegeTriggers(value));
                        break;
                    }
                    case 7: {
                        currentRow.setType(value);
                        break;
                    }
                    case 8: {
                        currentRow.setElement(value);
                        break;
                    }
                    case 9: {
                        currentRow.setIndex(Integer.valueOf(value));
                        break;
                    }
                    case 10: {
                        currentRow.setOptional(this.processBooleanValue(value));
                        break;
                    }
                    case 11: {
                        currentRow.setDefault(this.processBooleanValue(value));
                        break;
                    }
                    case 12: {
                        currentRow.setRestrictedVal(this.processBooleanValue(value));
                        break;
                    }
                    case 13: {
                        currentRow.setForceDefault(this.processBooleanValue(value));
                        break;
                    }
                    case 14: {
                        currentRow.setExclusionVal(value);
                        break;
                    }
                    case 15: {
                        currentRow.setSafePath(value);
                        break;
                    }
                    case 16: {
                        currentRow.setFS(this.processBooleanValue(value));
                        break;
                    }
                    case 17: {
                        currentRow.setStringBufferSize(Integer.valueOf(value));
                        break;
                    }
                    case 18: {
                        currentRow.setNumberMaxValue(Double.valueOf(value));
                        break;
                    }
                    case 19: {
                        currentRow.setNumberMinValue(Double.valueOf(value));
                        break;
                    }
                    case 20: {
                        currentRow.setRequiredRights(value);
                        break;
                    }
                    case 21: {
                        currentRow.setAllowedFromEmbeddedScript(this.processBooleanValue(value));
                        break;
                    }
                    case 22: {
                        currentRow.setAllowedFromAcrobat(this.processBooleanValue(value));
                        break;
                    }
                    case 23: {
                        currentRow.setTargetDoc(value);
                        break;
                    }
                    case 24: {
                        currentRow.setURL(value);
                        break;
                    }
                    case 25: {
                        currentRow.setDNS(value);
                        break;
                    }
                    case 26: {
                        currentRow.setFileSys(value);
                        break;
                    }
                    case 27: {
                        currentRow.setDebug(this.processBooleanValue(value));
                        break;
                    }
                    case 28: {
                        currentRow.setDatabase(this.processBooleanValue(value));
                        break;
                    }
                    case 29: {
                        currentRow.setMedia(this.processBooleanValue(value));
                        break;
                    }
                    case 30: {
                        currentRow.setChrome(this.processBooleanValue(value));
                        break;
                    }
                    case 31: {
                        currentRow.setUI(this.processBooleanValue(value));
                        break;
                    }
                    case 32: {
                        currentRow.setTrust(this.processBooleanValue(value));
                        break;
                    }
                    case 33: {
                        currentRow.setInfoDisclosure(this.processBooleanValue(value));
                        break;
                    }
                    case 34: {
                        currentRow.setPersistence(this.processBooleanValue(value));
                        break;
                    }
                    case 35: {
                        currentRow.setDocAppear(this.processBooleanValue(value));
                        break;
                    }
                    case 36: {
                        currentRow.setMail(this.processBooleanValue(value));
                        break;
                    }
                    case 37: {
                        currentRow.setXDoc(this.processBooleanValue(value));
                        break;
                    }
                    case 38: {
                        currentRow.setDocName(value);
                        break;
                    }
                    case 39: {
                        currentRow.setRhino(this.processBooleanValue(value));
                        break;
                    }
                    case 40: {
                        currentRow.setNotes(value);
                    }
                }
            }
        }
    }

    private String[][] processPrivilegeTriggers(String privTrigger) {
        String[][] privilegesTriggers = null;
        String[] getterSetterPrivilegesTrigger = privTrigger.split(":");
        if (getterSetterPrivilegesTrigger != null && getterSetterPrivilegesTrigger.length > 0) {
            privilegesTriggers = new String[getterSetterPrivilegesTrigger.length][];
            for (int i = 0; i < getterSetterPrivilegesTrigger.length; ++i) {
                String[] privileges;
                if (getterSetterPrivilegesTrigger[i] == null || (privileges = getterSetterPrivilegesTrigger[i].split(",")) == null || privileges.length <= 0) continue;
                privilegesTriggers[i] = new String[privileges.length * 2];
                int count = 0;
                for (int j = 0; j < privileges.length; ++j) {
                    String[] currentPrivileges;
                    if (privileges[j] == null || (currentPrivileges = privileges[j].split("/")) == null || currentPrivileges.length <= 1 || currentPrivileges[0] == null) continue;
                    privilegesTriggers[i][count++] = currentPrivileges[0];
                    if (currentPrivileges[1] == null) continue;
                    privilegesTriggers[i][count++] = currentPrivileges[1];
                }
            }
        }
        return privilegesTriggers;
    }

    private Object processBooleanValue(String value) {
        if (value.equalsIgnoreCase("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("0")) {
            return false;
        }
        return value;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.requireBuffer) {
            this.setCurrentRow();
            this.requireBuffer = false;
        }
        if (qName.equalsIgnoreCase("Row")) {
            if (!this.isFirstTime && currentRow != null) {
                String name = currentRow.getName();
                if (name.startsWith("Net") && name.contains(".")) {
                    StringBuilder builder = new StringBuilder(name);
                    builder.delete(0, 4);
                    name = builder.toString();
                }
                String[] str = name.split("\\.");
                if (name.charAt(0) >= 'A' && name.charAt(0) <= 'Z') {
                    if (!"???".equals(name) && !name.contains(".")) {
                        paramGeneratorMap.put(name, new HashMap());
                    } else if (name != null) {
                        jsMap.put(name, currentRow);
                        int i = 0;
                        if (str.length == i + 3) {
                            HashMap<Integer, JSMeshRow> map;
                            if (str[i].equals("Doc") && str[i + 1].equals("print()") && str[i + 2].equals("printParams")) {
                                currentRow.setIndex(9);
                            }
                            if ((map = paramGeneratorMap.get(str[i]).get(str[i + 1])) == null) {
                                paramGeneratorMap.get(str[i + 0]).put(str[i + 1], new HashMap());
                            }
                            map = paramGeneratorMap.get(str[i + 0]).get(str[i + 1]);
                            map.put(currentRow.getIndex(), currentRow);
                        } else if (str.length == 2 && !str[1].contains("()")) {
                            HashMap<Integer, JSMeshRow> map = paramGeneratorMap.get(str[i]).get(str[i + 1]);
                            if (map == null) {
                                paramGeneratorMap.get(str[i + 0]).put(str[i + 1], new HashMap());
                            }
                            map = paramGeneratorMap.get(str[i]).get(str[i + 1]);
                            map.put(map.size() + 1, currentRow);
                        } else if (functions.contains(str[0])) {
                            HashMap<Integer, JSMeshRow> map = paramGeneratorMap.get(str[i]).get(str[i + 1]);
                            if (map == null) {
                                paramGeneratorMap.get(str[i + 0]).put(str[i + 1], new HashMap());
                            }
                            map = paramGeneratorMap.get(str[i]).get(str[i + 1]);
                            map.put(map.size() + 1, currentRow);
                        }
                    }
                }
            }
            this.isFirstTime = false;
            this.rowStart = false;
        }
        if (!this.isFirstTime && this.rowStart && qName.equalsIgnoreCase("Cell")) {
            ++this.columnCount;
            this.isInsideCell = false;
        }
        if (qName.equalsIgnoreCase("Worksheet")) {
            this.createJSRow = false;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.requireBuffer) {
            this.setCurrentRow();
            this.requireBuffer = false;
        }
        if (qName.equalsIgnoreCase("Worksheet") && attributes.getValue("ss:Name").equalsIgnoreCase("mesh")) {
            this.createJSRow = true;
        }
        if (qName.equalsIgnoreCase("Row") && this.createJSRow) {
            currentRow = new JSMeshRow();
            this.rowStart = true;
            this.columnCount = 1;
        }
        if (!this.isFirstTime && this.rowStart && qName.equalsIgnoreCase("Cell")) {
            this.isInsideCell = true;
            String value = attributes.getValue("ss:Index");
            if (value != null) {
                this.columnCount = Integer.valueOf(value);
            }
        }
    }

    static {
        logWriter = null;
        paramGeneratorMap = new HashMap();
        functions = new HashSet<String>();
    }
}

