/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;

public class PlaceHolderCompositeFontBuilder {
    private PDFDocument pdfDocument;

    public PlaceHolderCompositeFontBuilder(PDFDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    public PDFFontType0 createType0FontFromDict(Font afeFont, CosDictionary dict) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
        ASName fontDictName = ASName.create(afeFontDesc.getPostscriptName());
        PDFFontType0 type0Font = PDFFontType0.getInstance(dict);
        type0Font.setBaseFont(fontDictName);
        type0Font.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Type0);
        type0Font.setDictionaryNameValue(ASName.k_Type, ASName.k_Font);
        type0Font.setEncoding(PDFType0FontEncoding.newInstance(this.pdfDocument, ASName.k_Identity_H));
        PDFCIDFont descendant = this.createDescendantFont(fontDictName, afeFontDesc);
        type0Font.setDescendantFont(descendant);
        type0Font.setBaseFont(ASName.create(afeFontDesc.getPostscriptName()));
        return type0Font;
    }

    private PDFCIDFont createDescendantFont(ASName baseFontName, PDFFontDescription afeFontDesc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidParameterException {
        PDFCIDFont cidFont = PDFCIDFont.newInstance(this.pdfDocument, ASName.create(afeFontDesc.getPostscriptName()), ASName.k_CIDFontType0);
        cidFont.setDW(1000);
        cidFont.setFontDescriptor(PDFFontDescriptor.newInstance(this.pdfDocument, baseFontName, afeFontDesc));
        cidFont.setW(PDFCIDFontWidths.newInstance(this.pdfDocument));
        return cidFont;
    }
}

