/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.GlyphIDHolder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.SymbolEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.WinAnsiEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.ZapfDingbatsEncoding;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PDFSimpleFontBuilder
extends PDFFontBuilder {
    private static final int FIRST_CCODE_USED = 1;
    private static final int MAX_GLYPH_LIMIT = 255;

    public PDFSimpleFontBuilder(PDFDocument pdfDocument) {
        super(pdfDocument);
    }

    private void updateWidths(PDFFontSimple pdfFont, int[] widths) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int firstChar;
        int lastChar = widths.length - 1;
        for (firstChar = 0; firstChar <= lastChar && widths[firstChar] == 0; ++firstChar) {
        }
        while (firstChar <= lastChar && widths[lastChar] == 0) {
            --lastChar;
        }
        pdfFont.setWidths(widths, firstChar, lastChar);
        pdfFont.setFirstChar(firstChar + 1);
        pdfFont.setLastChar(lastChar + 1);
    }

    private PDFFontSimple makeNewFont(PDFFontDescription afeFontDesc, CharSetEncoding baseEncoding, Map differences, int[] widths) throws InvalidFontException, UnsupportedFontException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ASName psName = ASName.create(afeFontDesc.getPostscriptName());
        PDFFontSimple pdfFont = afeFontDesc.pdfFontIsTrueType() ? PDFFontSimple.newInstance(this.pdfDocument, psName, ASName.k_TrueType) : PDFFontSimple.newInstance(this.pdfDocument, psName, ASName.k_Type1);
        PDFSimpleFontEncoding fontEncoding = PDFSimpleFontEncoding.newInstance(this.pdfDocument, baseEncoding, differences);
        PDFFontDescriptor fontDescriptor = PDFFontDescriptor.newInstance(this.pdfDocument, psName, afeFontDesc);
        pdfFont.setEncoding(fontEncoding);
        pdfFont.setFontDescriptor(fontDescriptor);
        pdfFont.resetAFEFont();
        this.updateWidths(pdfFont, widths);
        return pdfFont;
    }

    private void updateFont(PDFFontSimple font, Map differences, int[] widths) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.updateWidths(font, widths);
        PDFEncodingDifferences fontDiffs = font.getEncoding().getDifferences();
        if (fontDiffs == null) {
            if (!differences.isEmpty()) {
                fontDiffs = PDFEncodingDifferences.newInstance(font.getPDFDocument(), differences);
                font.getEncoding().setDifferences(fontDiffs);
            }
            return;
        }
        for (Map.Entry entry : differences.entrySet()) {
            int key = (Integer)entry.getKey();
            ASName value = ASName.create((String)entry.getValue());
            if (fontDiffs.contains(key) && fontDiffs.toGlyphName(key).equals(value)) continue;
            fontDiffs.addDifference(key, value);
        }
    }

    private PDFFontSimple findNonFullFont(List<PDFFont> pdfFontList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontSimple currentFont = null;
        for (int i = 0; i < pdfFontList.size(); ++i) {
            PDFFontSimple thisFont = (PDFFontSimple)pdfFontList.get(i);
            if (thisFont.getLastChar() >= 255) continue;
            currentFont = thisFont;
            break;
        }
        return currentFont;
    }

    private int retrieveCurrentStateFromFont(PDFFontSimple currentFont, Map differences, int[] widths, boolean[] ccodeUsed) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFEncodingDifferences fontDiffs = currentFont.getEncoding().getDifferences();
        int glyphCount = 0;
        int firstCharInFont = currentFont.getFirstChar();
        int lastCharInFont = currentFont.getLastChar();
        if (fontDiffs != null) {
            for (Integer key : fontDiffs.keySet()) {
                ASName value = fontDiffs.toGlyphName(key);
                differences.put(key, value.asString());
                ccodeUsed[key.intValue() - 1] = true;
            }
        }
        for (int i = firstCharInFont; i <= lastCharInFont; ++i) {
            if (currentFont.hasZeroWidth(i)) continue;
            int width = (int)currentFont.getGlyphDisplacement(i);
            ccodeUsed[i - 1] = true;
            widths[i - 1] = width;
            ++glyphCount;
        }
        return glyphCount;
    }

    private static int charCodeInBaseEncoding(CharSetEncoding encoding, String glyphName) {
        int i = encoding.fromGlyphName(glyphName);
        if (i != 0) {
            return i;
        }
        return -1;
    }

    private static boolean useImplicitBaseEncoding(PDFFontDescription afeFontDesc) {
        String base14Name = afeFontDesc.getBase14Name();
        if (base14Name != null) {
            if ("ZapfDingbats".equals(base14Name)) {
                return true;
            }
            if ("Symbol".equals(base14Name)) {
                return true;
            }
        }
        return false;
    }

    private static CharSetEncoding getBaseEncoding(PDFFontDescription afeFontDesc) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        String base14Name = afeFontDesc.getBase14Name();
        if (base14Name != null) {
            if ("ZapfDingbats".equals(base14Name)) {
                return ZapfDingbatsEncoding.getEncoding();
            }
            if ("Symbol".equals(base14Name)) {
                return SymbolEncoding.getEncoding();
            }
        }
        return WinAnsiEncoding.getEncoding();
    }

    private static boolean glyphNameAlreadyHasCCode(List<PDFFont> fontList, String glyphName, Map differences, boolean[] ccodeUsed, CharSetEncoding baseEncoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int charCode;
        for (int i = 0; i < fontList.size(); ++i) {
            PDFFontSimple thisFont = (PDFFontSimple)fontList.get(i);
            charCode = thisFont.getEncoding().fromGlyphName(glyphName);
            if (charCode == 0 && !".notdef".equals(glyphName) || thisFont.hasZeroWidth(charCode)) continue;
            return true;
        }
        charCode = baseEncoding.fromGlyphName(glyphName);
        if (charCode != 0 && !differences.containsKey(charCode)) {
            if (ccodeUsed[charCode - 1]) {
                return true;
            }
        } else {
            for (String gname : differences.values()) {
                if (!gname.equals(glyphName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void buildFonts(Iterator<GlyphIDHolder> gidIter, Font afeFont, List<PDFFont> fontList) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
        boolean implicitBaseEncoding = PDFSimpleFontBuilder.useImplicitBaseEncoding(afeFontDesc);
        if (!implicitBaseEncoding && afeFontDesc.pdfFontIsTrueType()) {
            OpenTypeFont ttFont = (OpenTypeFont)((FontImpl)afeFont).getFontData();
            Cmap cmap = ttFont.cmap;
            if (cmap.getCmapSubtableIndex(1, 0) != -1 && cmap.getCmapSubtableIndex(3, 1) == -1) {
                implicitBaseEncoding = true;
            }
        }
        CharSetEncoding baseEncoding = PDFSimpleFontBuilder.getBaseEncoding(afeFontDesc);
        boolean[] ccodeUsed = new boolean[255];
        Arrays.fill(ccodeUsed, false);
        HashMap<Integer, String> differences = new HashMap<Integer, String>();
        int[] widths = new int[255];
        Arrays.fill(widths, 0);
        int glyphCount = 0;
        PDFFontSimple currentFont = this.findNonFullFont(fontList);
        if (currentFont != null) {
            glyphCount = this.retrieveCurrentStateFromFont(currentFont, differences, widths, ccodeUsed);
        }
        while (gidIter.hasNext()) {
            int glyphID = gidIter.next().getGlyphID();
            String glyphName = afeFontDesc.getGlyphName(glyphID);
            double width = afeFontDesc.getAdvance(glyphID);
            if (PDFSimpleFontBuilder.glyphNameAlreadyHasCCode(fontList, glyphName, differences, ccodeUsed, baseEncoding)) continue;
            int cCode = PDFSimpleFontBuilder.charCodeInBaseEncoding(baseEncoding, glyphName);
            if (cCode == -1 || ccodeUsed[cCode - 1]) {
                for (int i = 1; i <= 255; ++i) {
                    if (ccodeUsed[i - 1]) continue;
                    differences.put(i, glyphName);
                    ccodeUsed[i - 1] = true;
                    cCode = i;
                    break;
                }
            } else {
                ccodeUsed[cCode - 1] = true;
            }
            widths[cCode - 1] = (int)width;
            if (++glyphCount != 255) continue;
            if (currentFont == null) {
                currentFont = this.makeNewFont(afeFontDesc, implicitBaseEncoding ? null : baseEncoding, differences, widths);
                fontList.add(currentFont);
            } else {
                this.updateFont(currentFont, differences, widths);
            }
            currentFont = null;
            differences.clear();
            Arrays.fill(widths, 0);
            glyphCount = 0;
            Arrays.fill(ccodeUsed, false);
        }
        if (glyphCount > 0) {
            if (currentFont == null) {
                PDFFontSimple font = this.makeNewFont(afeFontDesc, implicitBaseEncoding ? null : baseEncoding, differences, widths);
                fontList.add(font);
            } else {
                this.updateFont(currentFont, differences, widths);
            }
        }
    }
}

