/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.GlyphIDHolder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontBuilder;
import java.util.Iterator;
import java.util.List;

public class PDFCompositeFontBuilder
extends PDFFontBuilder {
    public PDFCompositeFontBuilder(PDFDocument pdfDocument) {
        super(pdfDocument);
    }

    @Override
    public void buildFonts(Iterator<GlyphIDHolder> gidIter, Font afeFont, List<PDFFont> list) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
        if (list.size() == 0) {
            ASName fontDictName = ASName.create(afeFontDesc.getPostscriptName());
            PDFFontType0 type0Font = (PDFFontType0)PDFFontType0.newInstance(this.pdfDocument, fontDictName);
            type0Font.setEncoding(this.computeEncoding());
            PDFCIDFont descendant = this.createDescendantFont(fontDictName, afeFontDesc, gidIter);
            type0Font.setDescendantFont(descendant);
            type0Font.setBaseFont(ASName.create(afeFontDesc.getPostscriptName()));
            list.add(type0Font);
        } else {
            PDFCIDFont cidFont = ((PDFFontType0)list.get(0)).getDescendantFont();
            cidFont.getW().buildWidths(gidIter, afeFontDesc, cidFont.getDW());
        }
    }

    private PDFCIDSystemInfo createCIDSystemInfo(PDFFontDescription afeFontDesc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, UnsupportedFontException, InvalidFontException, FontLoadingException {
        ROS rosSetting = afeFontDesc.getROS();
        ASString registry = new ASString(rosSetting.registry);
        ASString ordering = new ASString(rosSetting.ordering);
        int supplement = rosSetting.supplement;
        PDFCIDSystemInfo cidSysInfo = PDFCIDSystemInfo.newInstance(this.pdfDocument, registry, ordering, supplement);
        return cidSysInfo;
    }

    private ASName computeCMAPName() {
        return ASName.k_Identity_H;
    }

    private PDFType0FontEncoding computeEncoding() throws PDFInvalidDocumentException {
        return PDFType0FontEncoding.newInstance(this.pdfDocument, this.computeCMAPName());
    }

    private PDFCIDFont createDescendantFont(ASName baseFontName, PDFFontDescription afeFontDesc, Iterator<GlyphIDHolder> gidIter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidParameterException {
        PDFCIDFont cidFont = PDFCIDFont.newInstance(this.pdfDocument, ASName.create(afeFontDesc.getPostscriptName()), ASName.k_CIDFontType0);
        cidFont.setDW(1000);
        cidFont.setCIDSystemInfo(this.createCIDSystemInfo(afeFontDesc));
        PDFFontDescriptor fontDescriptor = PDFFontDescriptor.newInstance(this.pdfDocument, baseFontName, afeFontDesc);
        cidFont.setFontDescriptor(fontDescriptor);
        PDFCIDFontWidths pdfWidths = PDFCIDFontWidths.newInstance(this.pdfDocument);
        pdfWidths.buildWidths(gidIter, afeFontDesc, cidFont.getDW());
        cidFont.setW(pdfWidths);
        return cidFont;
    }
}

