/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

class ByteGrowableArray {
    private static int BUFFER_SIZE = 2048;
    private static int BUFFER_INCR = 1024;
    private int bufferSize;
    private int bufferSizeIncrement;
    private byte[] buffer = new byte[BUFFER_SIZE];
    private int length = 0;

    public ByteGrowableArray() {
        this.bufferSize = BUFFER_SIZE;
        this.bufferSizeIncrement = BUFFER_INCR;
    }

    public void set(byte data, int index) {
        if (index >= this.bufferSize) {
            int newBufferSize;
            for (newBufferSize = this.bufferSize; index >= newBufferSize; newBufferSize += this.bufferSizeIncrement) {
            }
            byte[] newBuffer = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
            this.bufferSize = newBufferSize;
        }
        this.buffer[index] = data;
        if (this.length <= index) {
            this.length = index + 1;
        }
    }

    public byte get(int index) {
        if (index < this.length) {
            return this.buffer[index];
        }
        return 0;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.length;
    }
}

