/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFNamedPages;

public final class FDFAppearanceRef
extends PDFCosDictionary {
    private FDFAppearanceRef(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static FDFAppearanceRef getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        FDFAppearanceRef pdfObject = (FDFAppearanceRef)PDFCosObject.getCachedInstance(cosObject, FDFAppearanceRef.class);
        if (pdfObject == null) {
            pdfObject = new FDFAppearanceRef(cosObject);
        }
        return pdfObject;
    }

    static FDFAppearanceRef newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        FDFAppearanceRef pdfObject = new FDFAppearanceRef(cosObject);
        return pdfObject;
    }

    FDFNamedPages getNormalAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return FDFNamedPages.getInstance(this.getDictionaryCosObjectValue(ASName.k_N));
    }

    void setNormalAppearance(FDFNamedPages namedPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_N, namedPages);
    }

    FDFNamedPages getRolloverAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return FDFNamedPages.getInstance(this.getDictionaryCosObjectValue(ASName.k_R));
    }

    void setRolloverAppearance(FDFNamedPages namedPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_R, namedPages);
    }

    FDFNamedPages getDownAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return FDFNamedPages.getInstance(this.getDictionaryCosObjectValue(ASName.k_D));
    }

    void setDownAppearance(FDFNamedPages namedPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_D, namedPages);
    }
}

