/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;

public final class FDFAnnotation
extends PDFAnnotation {
    private FDFAnnotation(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static FDFAnnotation newInstance(PDFAnnotation pdfAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfAnnot == null) {
            return null;
        }
        return new FDFAnnotation(pdfAnnot.getCosObject());
    }

    public PDFAnnotation getPDFAnnotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationFactory.getInstance(this.getCosObject());
    }

    public boolean hasPageNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Page);
    }

    public int getPageNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Page);
    }

    public void setPageNumber(int page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Page, page);
    }

    public String getInReplyTo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_IRT);
    }

    public void setInReplyTo(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            this.removeValue(ASName.k_IRT);
        } else {
            this.setDictionaryStringValue(ASName.k_IRT, name);
        }
    }

    public void setInReplyTo(String name, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (name == null) {
            this.removeValue(ASName.k_IRT);
        } else {
            this.setDictionaryStringValue(ASName.k_IRT, name, unicode);
        }
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.getPDFAnnotation().transform(matrix, rotationAngle);
    }
}

