/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFCertificateSeedValue;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFieldSeedValue;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSubjectDN;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSubjectDNList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTimeStampSeed;
import com.adobe.internal.pdftoolkit.services.digsig.SigCertificateSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SigSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureSeedValueInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SignatureSeedValuePDF
implements SignatureSeedValueInterface {
    private PDFSignatureFieldSeedValue pdfSeedValue;
    private PDFCertificateSeedValue pdfCertificateSeedValue;

    public SignatureSeedValuePDF(PDFSignatureFieldSeedValue pdfSeedValue) throws PDFInvalidParameterException {
        if (pdfSeedValue == null) {
            throw new PDFInvalidParameterException("Seed Value can't be null");
        }
        this.pdfSeedValue = pdfSeedValue;
    }

    @Override
    public List<String> getDigestMethod() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] digestList = this.pdfSeedValue.getDigestMethod();
        if (digestList == null || digestList.length == 0) {
            return null;
        }
        return Arrays.asList(digestList);
    }

    @Override
    public ASName getFilter() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfSeedValue.getFilter();
    }

    @Override
    public Integer getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfSeedValue.getFlags();
    }

    @Override
    public String getAppearanceFilter() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfSeedValue.getAppearanceFilter();
    }

    @Override
    public String[] getLegalAttestations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfSeedValue.getLegalAttestations();
    }

    @Override
    public ASName getLockDocument() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfSeedValue.getLockDocument();
    }

    @Override
    public Integer getMDP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfSeedValue.getMDP();
    }

    @Override
    public List<String> getReasons() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String[] pdfSeedValueList = this.pdfSeedValue.getReasons();
        if (pdfSeedValueList == null || pdfSeedValueList.length == 0) {
            return null;
        }
        return Arrays.asList(pdfSeedValueList);
    }

    @Override
    public boolean getAddRevInfo() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfSeedValue.getAddRevInfo();
    }

    @Override
    public List<ASName> getSubFilters() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName[] subFilterList = this.pdfSeedValue.getSubFilters();
        if (subFilterList == null || subFilterList.length == 0) {
            return null;
        }
        return Arrays.asList(subFilterList);
    }

    @Override
    public String getTimeStampServerURL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFTimeStampSeed pdfTimeStamp = this.pdfSeedValue.getPDFTimeStamp();
        if (pdfTimeStamp == null) {
            return null;
        }
        return pdfTimeStamp.getURL();
    }

    @Override
    public boolean getTimeStampFlag() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTimeStampSeed pdfTimeStamp = this.pdfSeedValue.getPDFTimeStamp();
        if (pdfTimeStamp == null) {
            return false;
        }
        return pdfTimeStamp.requiresTimeStamp();
    }

    @Override
    public Double getVersion() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfSeedValue.getVersion();
    }

    @Override
    public void setDigestMethod(List<String> digestList) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        if (digestList == null || digestList.isEmpty()) {
            this.pdfSeedValue.setDigestMethod(null);
        } else {
            this.pdfSeedValue.setDigestMethod(digestList.toArray(new String[digestList.size()]));
        }
    }

    @Override
    public void setFilter(ASName filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (filter == null) {
            this.pdfSeedValue.setFilter(null);
        } else {
            this.pdfSeedValue.setFilter(filter);
        }
    }

    @Override
    public void setFlags(Integer flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfSeedValue.setFlags(flags);
    }

    @Override
    public void setAppearanceFilter(String appearanceFilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfSeedValue.setAppearanceFilter(appearanceFilter);
    }

    @Override
    public void setLegalAttestations(String[] attestations) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfSeedValue.setLegalAttestations(attestations);
    }

    @Override
    public void setLockDocument(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfSeedValue.setLockDocument(value);
    }

    @Override
    public void setMDP(Integer mdpValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (mdpValue != null && (mdpValue < 0 || mdpValue > 3)) {
            throw new PDFInvalidParameterException("MDP Value should have value in between 0 - 3 ");
        }
        this.pdfSeedValue.setMDP(mdpValue);
    }

    @Override
    public void setReasons(List<String> reasons) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        if (reasons == null || reasons.isEmpty()) {
            this.pdfSeedValue.setReasons(null);
        } else {
            this.pdfSeedValue.setReasons(reasons.toArray(new String[reasons.size()]));
        }
    }

    @Override
    public void setAddRevInfo(boolean value) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.pdfSeedValue.setRevInfoFlag(value);
    }

    @Override
    public void setSubFilters(List<ASName> subFilters) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        if (subFilters == null || subFilters.isEmpty()) {
            this.pdfSeedValue.setSubFilters(null);
        } else {
            this.pdfSeedValue.setSubFilters(subFilters.toArray(new ASName[subFilters.size()]));
        }
    }

    @Override
    public void setTimeStampServerURL(String timeStampValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        PDFTimeStampSeed pdfTimeStamp = this.pdfSeedValue.getPDFTimeStamp();
        if (pdfTimeStamp == null) {
            PDFTimeStampSeed timeStampSeed = PDFTimeStampSeed.newInstance(this.pdfSeedValue.getPDFDocument(), timeStampValue);
            this.pdfSeedValue.setPDFTimeStamp(timeStampSeed);
        } else {
            pdfTimeStamp.setURL(timeStampValue);
        }
    }

    @Override
    public void setTimeStampFlag(boolean timeFlag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTimeStampSeed pdfTimeStamp = this.pdfSeedValue.getPDFTimeStamp();
        pdfTimeStamp.setRequiresTimeStamp(timeFlag);
    }

    @Override
    public void setVersion(Double version) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.pdfSeedValue.setVersion(version);
    }

    PDFSignatureFieldSeedValue getPDFSignatureFieldSeedValue() {
        return this.pdfSeedValue;
    }

    @Override
    public SigSeedValue getSeedValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SigSeedValue seedValue = new SigSeedValue();
        seedValue.setFilter(this.getFilter());
        seedValue.setFlags(this.getFlags());
        seedValue.setLockDocument(this.getLockDocument());
        seedValue.setMDP(this.getMDP());
        seedValue.setAppearanceFilter(this.getAppearanceFilter());
        seedValue.setLegalAttestations(this.getLegalAttestations());
        seedValue.setRevInfo(this.getAddRevInfo());
        seedValue.setVersion(this.getVersion());
        seedValue.setDigestMethod(this.getDigestMethod());
        seedValue.setReasons(this.getReasons());
        seedValue.setSubFilters(this.getSubFilters());
        seedValue.setTimeStampUrl(this.getTimeStampServerURL());
        seedValue.setTimeStampFlag(this.getTimeStampFlag());
        seedValue.setCertificateSeedValue(this.getCertificateSeedValue());
        if (seedValue.getFilter() != null || seedValue.getFlags() != null || seedValue.getLockDocument() != null || seedValue.getMDP() != null || seedValue.getAppearanceFilter() != null || seedValue.getLegalAttestations() != null || seedValue.getVersion() != null || seedValue.getDigestMethod() != null || seedValue.getReasons() != null || seedValue.getSubFilters() != null || seedValue.getTimeStampURL() != null || seedValue.getCertificateSeedValue() != null) {
            return seedValue;
        }
        return null;
    }

    @Override
    public void setSeedValue(SigSeedValue seedValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            if (seedValue != null) {
                if (seedValue.getFilter() != this.getFilter()) {
                    this.setFilter(seedValue.getFilter());
                }
                if (seedValue.getLockDocument() != this.getLockDocument()) {
                    this.setLockDocument(seedValue.getLockDocument());
                }
                if (seedValue.getMDP() != null && !seedValue.getMDP().equals(this.getMDP())) {
                    this.setMDP(seedValue.getMDP());
                } else if (this.getMDP() != null) {
                    this.setMDP(null);
                }
                if (seedValue.getRevInfo() != this.getAddRevInfo()) {
                    this.setAddRevInfo(seedValue.getRevInfo());
                }
                if (seedValue.getVersion() != null) {
                    if (!seedValue.getVersion().equals(this.getVersion())) {
                        this.setVersion(seedValue.getVersion());
                    }
                } else if (this.getVersion() != null) {
                    this.setVersion(null);
                }
                if (seedValue.getAppearanceFilter() != null) {
                    if (!seedValue.getAppearanceFilter().equalsIgnoreCase(this.getAppearanceFilter())) {
                        this.setAppearanceFilter(seedValue.getAppearanceFilter());
                    }
                } else if (this.getAppearanceFilter() != null) {
                    this.setAppearanceFilter(null);
                }
                Object[] newArray = seedValue.getLegalAttestations();
                Object[] existingArray = this.getLegalAttestations();
                if (newArray != null && newArray.length > 0) {
                    if (existingArray != null && existingArray.length > 0) {
                        Arrays.sort(newArray);
                        Arrays.sort(existingArray);
                        if (!Arrays.equals(newArray, existingArray)) {
                            this.setLegalAttestations((String[])newArray);
                        }
                    } else {
                        this.setLegalAttestations((String[])newArray);
                    }
                } else if (existingArray != null && existingArray.length > 0) {
                    this.setLegalAttestations(null);
                }
                List<String> existingList = this.getDigestMethod();
                List<String> newList = seedValue.getDigestMethod();
                if (newList != null && !newList.isEmpty()) {
                    if (existingList != null && !existingList.isEmpty()) {
                        Collections.sort(newList);
                        Collections.sort(existingList);
                        if (!newList.equals(existingList)) {
                            this.setDigestMethod(newList);
                        }
                    } else {
                        this.setDigestMethod(newList);
                    }
                } else if (existingList != null && !existingList.isEmpty()) {
                    this.setDigestMethod(null);
                }
                List<ASName> existingASNameList = this.getSubFilters();
                List<ASName> newASNameList = seedValue.getSubFilters();
                if (newASNameList != null && !newASNameList.isEmpty()) {
                    if (existingASNameList != null && !existingASNameList.isEmpty()) {
                        Collections.sort(newASNameList);
                        Collections.sort(existingASNameList);
                        if (!newASNameList.equals(existingASNameList)) {
                            this.setSubFilters(newASNameList);
                        }
                    } else {
                        this.setSubFilters(newASNameList);
                    }
                } else if (existingASNameList != null && !existingASNameList.isEmpty()) {
                    this.setSubFilters(null);
                }
                newList = seedValue.getReasons();
                existingList = this.getReasons();
                if (newList != null && !newList.isEmpty()) {
                    if (existingList != null && !existingList.isEmpty()) {
                        Collections.sort(newList);
                        Collections.sort(existingList);
                        if (!newList.equals(existingList)) {
                            this.setReasons(newList);
                        }
                    } else {
                        this.setReasons(newList);
                    }
                } else if (existingList != null && !existingList.isEmpty()) {
                    this.setReasons(null);
                }
                if (seedValue.getTimeStampURL() != null && !seedValue.getTimeStampURL().equalsIgnoreCase(this.getTimeStampServerURL())) {
                    this.setTimeStampServerURL(seedValue.getTimeStampURL());
                }
                if (seedValue.getTimeStampFlag() != this.getTimeStampFlag()) {
                    this.setTimeStampFlag(seedValue.getTimeStampFlag());
                }
                this.setCertificateSeedValue(seedValue.getCertificateSeedValue());
                if (seedValue.getFlags() != null && !seedValue.getFlags().equals(this.getFlags())) {
                    this.setFlags(seedValue.getFlags());
                } else if (this.getFlags() != null) {
                    this.setFlags(null);
                }
                if (!Arrays.equals(this.getLegalAttestations(), seedValue.getLegalAttestations())) {
                    this.setLegalAttestations(seedValue.getLegalAttestations());
                }
            } else {
                this.setDigestMethod(null);
                this.setFilter(null);
                this.setLockDocument(null);
                this.setMDP(null);
                this.setAddRevInfo(false);
                this.setSubFilters(null);
                this.setTimeStampServerURL(null);
                this.setVersion(null);
                this.setReasons(null);
                this.setAppearanceFilter(null);
                this.setFlags(null);
                this.setCertificateSeedValue(null);
            }
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidParameterException(e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    private String getURL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfCertificateSeedValue.getURL();
    }

    private ASName getURLType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfCertificateSeedValue.getURLType();
    }

    private Integer getCertificateFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfCertificateSeedValue.getFlags();
    }

    private String[] getOIDS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfCertificateSeedValue.getOIDs();
    }

    private String[] getKeyUsage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfCertificateSeedValue.getKeyUsage();
    }

    private byte[][] getIssuers() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfCertificateSeedValue.getIssuers();
    }

    private byte[][] getSubjects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfCertificateSeedValue.getSubjects();
    }

    private List<Map> getSubjectDN() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFSubjectDNList.SubjectDNArrayListIterator subjectDNIter;
        PDFSubjectDNList subjectDNList = this.pdfCertificateSeedValue.getSubjectDN();
        if (subjectDNList != null && (subjectDNIter = subjectDNList.getIterator()) != null) {
            ArrayList<Map> subjectDNS = new ArrayList<Map>();
            while (subjectDNIter.hasNext()) {
                PDFSubjectDN subjectDN = subjectDNIter.next();
                Map<String, String> dnMap = subjectDN.getAttributes();
                subjectDNS.add(dnMap);
            }
            return subjectDNS;
        }
        return null;
    }

    private void setURL(String url) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfCertificateSeedValue.setURL(url);
    }

    private void setURLType(ASName urlType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfCertificateSeedValue.setURLType(urlType);
    }

    private void setCertificateFlags(Integer flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfCertificateSeedValue.setFlags(flags);
    }

    private void setOIDS(String[] oids) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfCertificateSeedValue.setOIDs(oids);
    }

    private void setKeyUsage(String[] keyUsage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.pdfCertificateSeedValue.setKeyUsage(keyUsage);
    }

    private void setIssuers(byte[][] issuers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfCertificateSeedValue.setIssuers(issuers);
    }

    private void setSubjects(byte[][] subjects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfCertificateSeedValue.setSubjects(subjects);
    }

    private void setSubjectDN(List<Map> subjectDN) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.pdfCertificateSeedValue.setSubjectDN(subjectDN);
    }

    @Override
    public SigCertificateSeedValue getCertificateSeedValue() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SigCertificateSeedValue certificateSeedValue = new SigCertificateSeedValue();
        this.pdfCertificateSeedValue = this.pdfSeedValue.getPDFCertificateSeedValue();
        if (this.pdfCertificateSeedValue == null) {
            return null;
        }
        certificateSeedValue.setIssuers(this.getIssuers());
        certificateSeedValue.setKeyUsages(this.getKeyUsage());
        certificateSeedValue.setOIDS(this.getOIDS());
        certificateSeedValue.setSubjectDN(this.getSubjectDN());
        certificateSeedValue.setSubjects(this.getSubjects());
        certificateSeedValue.setURL(this.getURL());
        certificateSeedValue.setURLType(this.getURLType());
        certificateSeedValue.setFlags(this.getCertificateFlags());
        if (certificateSeedValue.getIssuers() != null || certificateSeedValue.getKeyUsages() != null || certificateSeedValue.getOIDS() != null || certificateSeedValue.getSubjectDN() != null || certificateSeedValue.getURL() != null || certificateSeedValue.getFlags() != 0) {
            return certificateSeedValue;
        }
        return null;
    }

    @Override
    public void setCertificateSeedValue(SigCertificateSeedValue certificateSeedValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.pdfCertificateSeedValue = this.pdfSeedValue.getPDFCertificateSeedValue();
        if (certificateSeedValue != null) {
            String url;
            if (this.pdfCertificateSeedValue == null) {
                this.pdfCertificateSeedValue = PDFCertificateSeedValue.newInstance(this.pdfSeedValue.getPDFDocument());
            }
            if ((url = certificateSeedValue.getURL()) != null && url.length() > 0) {
                if (!url.equalsIgnoreCase(this.getURL())) {
                    this.setURL(url);
                }
            } else if (this.getURL() != null && this.getURL().length() > 0) {
                this.setURL(null);
            }
            if (certificateSeedValue.getURLType() != this.getURLType()) {
                this.setURLType(certificateSeedValue.getURLType());
            }
            byte[][] newIssuers = certificateSeedValue.getIssuers();
            byte[][] currentIssuers = this.getIssuers();
            if (newIssuers != null && newIssuers.length > 0) {
                if (currentIssuers != null && currentIssuers.length > 0) {
                    if (currentIssuers.length == newIssuers.length) {
                        for (int i = 0; i < currentIssuers.length; ++i) {
                            if (Arrays.equals(currentIssuers[i], newIssuers[i])) continue;
                            this.setIssuers(newIssuers);
                            break;
                        }
                    } else {
                        this.setIssuers(newIssuers);
                    }
                } else {
                    this.setIssuers(newIssuers);
                }
            } else if (newIssuers != null && newIssuers.length > 0) {
                this.setIssuers(null);
            }
            Object[] newList = certificateSeedValue.getKeyUsages();
            Object[] existingList = this.getKeyUsage();
            if (newList != null && newList.length > 0) {
                if (existingList != null && existingList.length > 0) {
                    Arrays.sort(newList);
                    Arrays.sort(existingList);
                    if (!newList.equals(existingList)) {
                        this.setKeyUsage((String[])newList);
                    }
                } else {
                    this.setKeyUsage((String[])newList);
                }
            } else if (existingList != null && existingList.length > 0) {
                this.setKeyUsage(null);
            }
            newList = certificateSeedValue.getOIDS();
            existingList = this.getOIDS();
            if (newList != null && newList.length > 0) {
                if (existingList != null && existingList.length > 0) {
                    Arrays.sort(newList);
                    Arrays.sort(existingList);
                    if (!newList.equals(existingList)) {
                        this.setOIDS((String[])newList);
                    }
                } else {
                    this.setOIDS((String[])newList);
                }
            } else if (existingList != null && existingList.length > 0) {
                this.setOIDS(null);
            }
            if (certificateSeedValue.getSubjectDN() != null) {
                if (!certificateSeedValue.getSubjectDN().equals(this.getSubjectDN())) {
                    this.setSubjectDN(certificateSeedValue.getSubjectDN());
                }
            } else if (this.getSubjectDN() != null) {
                this.setSubjectDN(null);
            }
            byte[][] newSubjects = certificateSeedValue.getSubjects();
            byte[][] currentSubjects = this.getSubjects();
            if (newSubjects != null && newSubjects.length > 0) {
                if (currentSubjects != null && currentSubjects.length > 0) {
                    if (currentSubjects.length == newSubjects.length) {
                        for (int i = 0; i < currentSubjects.length; ++i) {
                            if (Arrays.equals(currentSubjects[i], newSubjects[i])) continue;
                            this.setSubjects(newSubjects);
                            break;
                        }
                    } else {
                        this.setSubjects(newSubjects);
                    }
                } else {
                    this.setSubjects(newSubjects);
                }
            } else if (currentSubjects != null && currentSubjects.length > 0) {
                this.setSubjects(null);
            }
            if (certificateSeedValue.getFlags() != null && !certificateSeedValue.getFlags().equals(this.getCertificateFlags())) {
                this.setCertificateFlags(certificateSeedValue.getFlags());
            } else if (this.getCertificateFlags() != null) {
                this.setCertificateFlags(null);
            }
            this.pdfSeedValue.setPDFCertificateSeedValue(this.pdfCertificateSeedValue);
        } else if (this.pdfCertificateSeedValue != null) {
            this.pdfSeedValue.setPDFCertificateSeedValue(null);
        }
    }
}

