/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocumentInfo;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.HashMap;

public final class DocumentInfoDigester
extends ObjectDigester {
    private PDFDocumentInfo docInfo;

    public DocumentInfoDigester(PDFDocument pdfDoc, PDFDocumentInfo docInfo, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.docInfo = docInfo;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.docInfo != null) {
            CosDictionary dict = this.docInfo.getCosDictionary();
            try {
                CosString subject;
                CosString keywords;
                CosString author;
                CosString title;
                byte[] bytes;
                if (dict.containsKey(ASName.k_Title) && (bytes = (title = dict.getCosString(ASName.k_Title)).byteArrayValue()).length > 0) {
                    this.updateString(this.normalize(bytes));
                }
                if (dict.containsKey(ASName.k_Author) && (bytes = (author = dict.getCosString(ASName.k_Author)).byteArrayValue()).length > 0) {
                    this.updateString(this.normalize(bytes));
                }
                if (dict.containsKey(ASName.k_Keywords) && (bytes = (keywords = dict.getCosString(ASName.k_Keywords)).byteArrayValue()).length > 0) {
                    this.updateString(this.normalize(bytes));
                }
                if (dict.containsKey(ASName.k_Subject) && (bytes = (subject = dict.getCosString(ASName.k_Subject)).byteArrayValue()).length > 0) {
                    this.updateString(this.normalize(bytes));
                }
            }
            catch (PDFCosParseException e) {
                throw new PDFInvalidDocumentException("The PDF document being used is invalid ", e);
            }
            catch (PDFIOException e) {
                throw new PDFIOException("IO exception encountered when computing the digest", e);
            }
            catch (PDFSecurityException e) {
                throw new PDFSecurityException("Security exception encountered when computing the digest", e);
            }
        }
        byte[] digest = super.digest();
        return digest;
    }
}

