/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.digsig.XFAChangeLogger;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.XFAValidationContext;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.StringHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class XFAVersionComparator {
    AppModel currentAppModel;
    AppModel rollbackAppModel;
    Document currentXFADocument;
    Document rollbackXFADocument;
    PDFDocument currentPDFDocument;
    PDFDocument rollbackPDFDocument;
    XFAValidationContext xfaValidationContext;
    String[] packetList;
    XFAChangeLogger xfaChangeLogger;
    boolean logChanges = false;
    DocModAnalyzerParams.DocModAnalysisMode fieldMDPMode;
    String[] packetsAllowNone = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "datasets", "xfdf", "localeSet", "form"};
    String[] packetsDefault = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "xfdf", "localeSet", "dataDescription", null};
    String[] packetsCommentsAndDefault = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "localeSet", "dataDescription"};
    String[] packetsXFAKey = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "datasets", "form", null};
    private TreeMap<String, PacketInfo> moCurrentPackets;
    private TreeMap<String, PacketInfo> moRollbackPackets;

    public XFAVersionComparator() {
    }

    public XFAVersionComparator(PDFDocument currentPDFDocument, CosDocument rollbackCosDocument, DSMDPType compareType, XFAChangeLogger xfaChangeLogger, DocModAnalyzerParams.DocModAnalysisMode fieldMDPMode, XFAValidationContext xfaValidationContext) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        this.currentPDFDocument = currentPDFDocument;
        this.xfaValidationContext = xfaValidationContext;
        if (xfaValidationContext == null) {
            this.xfaValidationContext = new XFAValidationContext(currentPDFDocument, rollbackCosDocument, null, fieldMDPMode, false);
        }
        this.currentPDFDocument = this.xfaValidationContext.getCurrentPDFDoc();
        this.rollbackPDFDocument = this.xfaValidationContext.getRollbackPDFDoc();
        this.initComparator(compareType, xfaChangeLogger, fieldMDPMode);
    }

    public void initComparator(DSMDPType compareType, XFAChangeLogger logger, DocModAnalyzerParams.DocModAnalysisMode fieldMDPMode) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        this.packetList = null;
        this.setXFAChangeLogger(logger);
        this.setCompareType(compareType);
        this.fieldMDPMode = fieldMDPMode;
        Document currentXFADocument = this.xfaValidationContext.getCurrentXFADocument();
        Document rollbackXFADocument = this.xfaValidationContext.getRollbackXFADocument();
        if (this.logChanges) {
            this.xfaChangeLogger.setCurAppModel(this.xfaValidationContext.getCurrentXFADocument().getAppModel());
        }
        if (currentXFADocument != null) {
            this.currentAppModel = currentXFADocument.getAppModel();
        }
        if (this.currentAppModel == null) {
            this.currentAppModel = this.loadAppModel(currentXFADocument);
        }
        this.rollbackAppModel = this.loadAppModel(rollbackXFADocument);
        assert (this.currentAppModel != null && this.rollbackAppModel != null && currentXFADocument != null && rollbackXFADocument != null);
        this.moCurrentPackets = new TreeMap<String, PacketInfo>();
        this.expandPackets(this.currentAppModel, this.moCurrentPackets, DocumentContext.find(this.currentPDFDocument, false, null));
        this.moRollbackPackets = new TreeMap<String, PacketInfo>();
        this.expandPackets(this.rollbackAppModel, this.moRollbackPackets, DocumentContext.find(this.rollbackPDFDocument, false, null));
    }

    void setCompareType(DSMDPType compareType) {
        this.initPacketsToCompare(compareType);
    }

    void setXFAChangeLogger(XFAChangeLogger logger) {
        this.xfaChangeLogger = logger;
        if (logger != null) {
            this.logChanges = true;
            this.xfaChangeLogger.setCurAppModel(this.currentAppModel);
        }
    }

    private void initPacketsToCompare(DSMDPType compareType) {
        assert (compareType == DSMDPType.MDPAllowNone || compareType == DSMDPType.MDPCommentsAndDefault);
        if (compareType == DSMDPType.MDPCommentsAndDefault) {
            this.packetList = this.packetsCommentsAndDefault;
        }
    }

    public final boolean compareXFAVersions() throws PDFInvalidParameterException {
        if (this.packetList != null && this.hasPacket("form")) {
            throw new PDFInvalidParameterException("Form packet encountered in packet list");
        }
        if (this.packetList != null && !this.logChanges) {
            if (!this.compareXFAVersions(CompareType.EXCLUDE_FORM)) {
                return false;
            }
            return this.compareXFAVersions(CompareType.FORM);
        }
        return this.compareXFAVersions(CompareType.DEFAULT);
    }

    boolean compareXFAVersions(CompareType compareType) throws PDFInvalidParameterException {
        boolean returnValue = true;
        ArrayList<String> comparedPackets = new ArrayList<String>();
        Set<Map.Entry<String, PacketInfo>> entrySet = this.moCurrentPackets.entrySet();
        Iterator<Map.Entry<String, PacketInfo>> itr = entrySet.iterator();
        PacketInfo currentPacketInfo = null;
        String aCurrentPacketID = null;
        Map.Entry<String, PacketInfo> currentEntry = null;
        while (itr.hasNext()) {
            currentEntry = itr.next();
            aCurrentPacketID = currentEntry.getKey();
            currentPacketInfo = currentEntry.getValue();
            ObjectHolder<Node> currentPacket = new ObjectHolder<Node>(currentPacketInfo.moPacket);
            StringHolder currentPacketName = new StringHolder(currentPacketInfo.moPacketName);
            if (currentPacketName.value == null || currentPacketName.value.length() <= 0) {
                return false;
            }
            if (!this.shouldProcessPacket(this.currentAppModel, compareType, currentPacketName, currentPacket)) continue;
            PacketInfo rollbackPacketInfo = this.moRollbackPackets.get(aCurrentPacketID);
            Node rollbackPacket = null;
            if (rollbackPacketInfo != null) {
                rollbackPacket = rollbackPacketInfo.moPacket;
            }
            if (rollbackPacket != null) {
                if (currentPacketName.value.equals("xfdf")) {
                    this.SanitizeXFDF((Node)currentPacket.value);
                    this.SanitizeXFDF(rollbackPacket);
                }
                if (this.logChanges && this.xfaChangeLogger == null) {
                    this.xfaChangeLogger = new XFAChangeLogger();
                }
                if (!((Node)currentPacket.value).compareVersions(rollbackPacket, this.xfaChangeLogger, null)) {
                    if (this.logChanges) {
                        returnValue = false;
                    } else {
                        return false;
                    }
                }
                comparedPackets.add(currentPacketName.value);
                continue;
            }
            if (this.logChanges) {
                this.xfaChangeLogger.logChange("Misc:Create", (Node)currentPacket.value, "Create");
                returnValue = false;
                continue;
            }
            return false;
        }
        entrySet = this.moRollbackPackets.entrySet();
        itr = entrySet.iterator();
        PacketInfo rollbackPacketInfo = null;
        Map.Entry<String, PacketInfo> rollbackEntry = null;
        while (itr.hasNext()) {
            rollbackEntry = itr.next();
            rollbackPacketInfo = rollbackEntry.getValue();
            ObjectHolder<Node> rollbackPacket = new ObjectHolder<Node>(rollbackPacketInfo.moPacket);
            if (rollbackPacket.value == null) {
                return false;
            }
            StringHolder rollbackPacketName = new StringHolder(rollbackPacketInfo.moPacketName);
            if (rollbackPacketName.value == null || rollbackPacketName.value.length() <= 0) {
                return false;
            }
            if (!this.shouldProcessPacket(this.rollbackAppModel, compareType, rollbackPacketName, rollbackPacket)) continue;
            boolean packetCompared = false;
            for (int compareIndex = 0; compareIndex < comparedPackets.size(); ++compareIndex) {
                if (comparedPackets.get(compareIndex) != rollbackPacketName.value) continue;
                packetCompared = true;
                break;
            }
            if (packetCompared) continue;
            if (this.logChanges) {
                this.xfaChangeLogger.logChange("Misc:Delete", (Node)rollbackPacket.value, "Delete");
                returnValue = false;
                continue;
            }
            return false;
        }
        return returnValue;
    }

    private void SanitizeXFDF(Node xfdfPacket) {
        Node child = xfdfPacket.getFirstXMLChild();
        while (child != null) {
            Node nextNode = child.getNextXMLSibling();
            if (!(child instanceof Element) || !child.getName().equals("annots")) {
                child.remove();
            }
            child = nextNode;
        }
    }

    boolean shouldProcessPacket(AppModel appModel, CompareType compareType, StringHolder packetName, ObjectHolder<Node> packet) throws PDFInvalidParameterException {
        if (compareType == CompareType.FORM && !packetName.value.equals("form")) {
            return false;
        }
        if (compareType == CompareType.EXCLUDE_FORM && packetName.value.equals("form")) {
            return false;
        }
        if (packetName.value.equals("xmpmeta")) {
            return false;
        }
        return this.packetList == null || this.hasPacket(packetName.value);
    }

    AppModel loadAppModel(Document xfaDocument) throws PDFInvalidParameterException {
        AppModel appModel = xfaDocument.getAppModel();
        if (appModel == null) {
            throw new PDFInvalidParameterException("Null app model found in XFA Document");
        }
        if (appModel != null) {
            appModel.addFactory(new DataModelFactory());
        }
        return appModel;
    }

    boolean hasPacket(String packetName) {
        for (int index = 0; index < this.packetList.length; ++index) {
            if (!this.packetList[index].equals(packetName)) continue;
            return true;
        }
        return false;
    }

    private int expandPackets(AppModel oAppModel, SortedMap<String, PacketInfo> oPackets, DocumentContext mpoCurrent) {
        int nNumPackets = oAppModel.getXFAChildCount();
        for (int nPacketIndex = 0; nPacketIndex < nNumPackets; ++nPacketIndex) {
            String aPacketName;
            Node oPacket = oAppModel.getXFAChild(nPacketIndex);
            if (oPacket == null || mpoCurrent != null && mpoCurrent.getPacketToIgnoreWhileComparisonDuringSubmit() == oPacket || (aPacketName = oPacket.getName()) == null) continue;
            if (oPacket instanceof Model && aPacketName.equals("datasets")) {
                int nNumChildren = oPacket.getXFAChildCount();
                for (int nChildIndex = 0; nChildIndex < nNumChildren; ++nChildIndex) {
                    Node oChild = ((Model)oPacket).getXFAChild(nChildIndex);
                    if (oChild == null) continue;
                    String aChildName = oChild.getName();
                    if (oChild == null || oChild.getClassTag() != XFA.DATAGROUPTAG || !aChildName.equals("dataDescription")) continue;
                    PacketInfo poChildInfo = new PacketInfo(aChildName, oChild);
                    String sChildName = new String(aChildName);
                    while (oPackets.get(sChildName) != null) {
                        sChildName = sChildName + "_";
                    }
                    oPackets.put(sChildName, poChildInfo);
                }
            }
            PacketInfo poPacketInfo = new PacketInfo(aPacketName, oPacket);
            String sPacketName = new String(aPacketName);
            while (oPackets.get(sPacketName) != null) {
                sPacketName = sPacketName + "_";
            }
            oPackets.put(sPacketName, poPacketInfo);
        }
        return oPackets.size();
    }

    private class PacketInfo {
        String moPacketName;
        Node moPacket;

        PacketInfo(String name, Node packet) {
            this.moPacketName = name;
            this.moPacket = packet;
        }
    }

    public static enum DSMDPType {
        MDPNone(-1),
        MDPAllowAll(0),
        MDPAllowNone(1),
        MDPDefault(2),
        MDPCommentsAndDefault(3);

        public final int type;

        private DSMDPType(int type) {
            this.type = type;
        }
    }

    public static enum CompareType {
        DEFAULT,
        EXCLUDE_FORM,
        FORM;

    }
}

