/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Signer;

public final class SignerFactory {
    private PDFSignatureSubFilter subFilter;

    private SignerFactory() {
    }

    private SignerFactory(PDFSignatureSubFilter subFilter) {
        this.subFilter = subFilter;
    }

    public static SignerFactory newInstance(PDFSignatureSubFilter subFilter) {
        return new SignerFactory(subFilter);
    }

    public Signer newSigner(Credentials credentials, SignatureServiceProvider myProvider) throws PDFInvalidParameterException, PDFConfigurationException, PDFSignatureException {
        if (this.subFilter == PDFSignatureSubFilter.X509RSASha1) {
            if (!myProvider.getCryptoContext().getDigestAlgorithm().equals(PDFSignature.k_SHA1.asString(true)) && !myProvider.getCryptoContext().getDigestAlgorithm().equals(PDFSignature.k_MD5.asString(true))) {
                throw new PDFSignatureException("Only SHA1 and MD5 are allowed for the X509SHA1 signer");
            }
            return myProvider.getPKCS1Signer(credentials);
        }
        if (this.subFilter == PDFSignatureSubFilter.PKCS7Sha1) {
            if (!myProvider.getCryptoContext().getDigestAlgorithm().equals(PDFSignature.k_SHA1.asString(true)) && !myProvider.getCryptoContext().getDigestAlgorithm().equals(PDFSignature.k_MD5.asString(true))) {
                throw new PDFSignatureException("Only SHA1 and MD5 are allowed for the PKCS7SHA1 signer");
            }
            return myProvider.getPKCS7Signer(credentials, false);
        }
        if (this.subFilter == PDFSignatureSubFilter.PKCS7Detached) {
            return myProvider.getPKCS7Signer(credentials, true);
        }
        if (this.subFilter == PDFSignatureSubFilter.ETSIRFC3161) {
            return myProvider.getDocumentTimeStampSigner();
        }
        if (this.subFilter == PDFSignatureSubFilter.ETSICADESDetached) {
            return myProvider.getCADESDetachedSigner(credentials);
        }
        return null;
    }
}

