/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.PKCS7SignerInfo;
import com.adobe.internal.pdftoolkit.services.digsig.RevocationInfo;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.PKCS7SignerInfoParser;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.NonStandardAttribute;
import java.util.Vector;

public final class PKCS7Parser {
    boolean asn1ParseSignerInfo = true;
    byte[] encodedBytes = null;
    byte[] signedDataBytes = null;
    int version = 1;
    Vector digestIDs = new Vector();
    Vector certs = new Vector();
    Vector crls = new Vector();
    Vector signers = new Vector();

    public PKCS7Parser(byte[] encodedBytes) throws PDFSignatureException {
        this.encodedBytes = encodedBytes;
        this.parse();
    }

    public byte[] getEncodedBytes() {
        return this.encodedBytes;
    }

    public void setEncodedBytes(byte[] encodedBytes) {
        this.encodedBytes = encodedBytes;
    }

    public byte[] getSignedDataBytes() {
        return this.signedDataBytes;
    }

    public void setSignedDataBytes(byte[] signedDataBytes) {
        this.signedDataBytes = signedDataBytes;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Vector getDigestIDs() {
        return this.digestIDs;
    }

    public void setDigestIDs(Vector digestIDs) {
        this.digestIDs = digestIDs;
    }

    public Vector getCerts() {
        return this.certs;
    }

    public void setCerts(Vector certs) {
        this.certs = certs;
    }

    public Vector getCrls() {
        return this.crls;
    }

    public void setCrls(Vector crls) {
        this.crls = crls;
    }

    public Vector getSigners() {
        return this.signers;
    }

    public void setSigners(Vector signers) {
        this.signers = signers;
    }

    public void parse() throws PDFSignatureException {
        try {
            this.asn1ParseEncodedContent();
            this.asn1ParseSignedData();
        }
        catch (PDFSignatureException e) {
            throw new PDFSignatureException("Could not parse the pkcs7 bytes", e);
        }
    }

    private void asn1ParseEncodedContent() throws PDFSignatureException {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encContent = new EncodedContainer(10616576, true, 0, null, 0, 0);
            OIDContainer oidContainer = new OIDContainer(0, 0);
            ASN1Container[] asn1Def = new ASN1Container[]{sequenceContainer, oidContainer, encContent, endContainer};
            ASN1.berDecode((byte[])this.getEncodedBytes(), (int)0, (ASN1Container[])asn1Def);
            byte[] newdata = new byte[encContent.dataLen];
            if (newdata.length > 0) {
                System.arraycopy(encContent.data, encContent.dataOffset, newdata, 0, encContent.dataLen);
            }
            this.setSignedDataBytes(newdata);
        }
        catch (ASN_Exception e) {
            throw new PDFSignatureException("The data to be parsed is not in the  pkcs7 format. Cannot parse to obtain the encoded content", e);
        }
    }

    private void asn1ParseSignedData() throws PDFSignatureException {
        try {
            SequenceContainer seq = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0);
            EncodedContainer oidSet = new EncodedContainer(12544);
            EncodedContainer contentData = new EncodedContainer(12288, true, 0, this.getSignedDataBytes().length, null, 0, 0);
            EncodedContainer certSet = new EncodedContainer(8466688);
            EncodedContainer crlSet = new EncodedContainer(8466689);
            EncodedContainer infoSet = new EncodedContainer(12544);
            ASN1Container[] contentASN1Def = new ASN1Container[]{seq, intContainer, oidSet, contentData, certSet, crlSet, infoSet, endContainer};
            ASN1.berDecode((byte[])this.getSignedDataBytes(), (int)0, (ASN1Container[])contentASN1Def);
            this.setVersion(((IntegerContainer)contentASN1Def[1]).getValueAsInt());
            if (oidSet.dataPresent) {
                this.decodeDigestOIDs(contentASN1Def[2].data, contentASN1Def[2].dataOffset);
            }
            if (certSet.dataPresent) {
                this.decodeCerts(contentASN1Def[4].data, contentASN1Def[4].dataOffset);
            }
            if (crlSet.dataPresent) {
                this.decodeCRLs(contentASN1Def[5].data, contentASN1Def[5].dataOffset);
            }
            if (infoSet.dataPresent) {
                this.decodeSignerInfos(contentASN1Def[6].data, contentASN1Def[6].dataOffset);
            }
        }
        catch (ASN_Exception e) {
            throw new PDFSignatureException("Could not parse the SignedData bytes", e);
        }
    }

    private void decodeDigestOIDs(byte[] data, int offset) throws PDFSignatureException {
        if (data == null) {
            return;
        }
        try {
            OfContainer setOf = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int oidCount = setOf.getContainerCount();
            for (int index = 0; index < oidCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                EncodedContainer oid = new EncodedContainer(12288, true, 0, null, 0, 0);
                ASN1Container[] oidDef = new ASN1Container[]{oid};
                ASN1.berDecode((byte[])nextContainer.data, (int)nextContainer.dataOffset, (ASN1Container[])oidDef);
                byte[] digestOID = new byte[oid.dataLen];
                System.arraycopy(oid.data, oid.dataOffset, digestOID, 0, oid.dataLen);
                this.digestIDs.addElement(digestOID);
            }
        }
        catch (ASN_Exception asnException) {
            throw new PDFSignatureException("Cannot decode digest OIDs: " + asnException.getMessage(), asnException);
        }
    }

    private void decodeCerts(byte[] data, int offset) throws PDFSignatureException {
        if (data == null) {
            return;
        }
        try {
            OfContainer setOf = new OfContainer(0x810000, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int certCount = setOf.getContainerCount();
            for (int index = 0; index < certCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                X509Certificate cert = new X509Certificate(nextContainer.data, nextContainer.dataOffset, 0);
                if (cert == null) continue;
                this.certs.addElement(cert);
            }
        }
        catch (Exception e) {
            throw new PDFSignatureException("Cannot decode certs: " + e.getMessage(), e);
        }
    }

    private void decodeCRLs(byte[] data, int offset) throws PDFSignatureException {
        if (data == null) {
            return;
        }
        try {
            OfContainer setOf = new OfContainer(0x810001, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int crlCount = setOf.getContainerCount();
            for (int index = 0; index < crlCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                X509CRL crl = new X509CRL(nextContainer.data, nextContainer.dataOffset, 0);
                if (crl == null) continue;
                this.crls.addElement(crl);
            }
        }
        catch (Exception e) {
            throw new PDFSignatureException("Cannot decode crls: " + e.getMessage(), e);
        }
    }

    private void decodeSignerInfos(byte[] data, int offset) throws PDFSignatureException {
        if (data == null) {
            return;
        }
        try {
            OfContainer setOf = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int signerCount = setOf.getContainerCount();
            for (int index = 0; index < signerCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                if (!this.asn1ParseSignerInfo) continue;
                this.signers.addElement(this.createSignerInfo(nextContainer.data, nextContainer.dataOffset));
            }
        }
        catch (Exception e) {
            throw new PDFSignatureException("Cannot decode signerInfo: " + e.getMessage(), e);
        }
    }

    private PKCS7SignerInfo createSignerInfo(byte[] signerInfoBER, int offset) throws PDFSignatureException {
        try {
            PKCS7SignerInfoParser signerInfoParser = new PKCS7SignerInfoParser(signerInfoBER, offset);
            return signerInfoParser.getSignerInfo();
        }
        catch (Exception e) {
            throw new PDFSignatureException("Could not parse the signer Info structure", e);
        }
    }

    static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuilder out = new StringBuilder(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        return out.toString();
    }

    public byte[] getTimeStampAttribute(X501Attributes attrs) {
        byte[] oid = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 16, 2, 14};
        return this.getNonStandardAttributeValue(oid, attrs);
    }

    private byte[] getNonStandardAttributeValue(byte[] oid, X501Attributes attrs) {
        NonStandardAttribute timeAttrib;
        if (attrs != null && (timeAttrib = (NonStandardAttribute)attrs.getAttributeByOID(oid)) != null) {
            return timeAttrib.getValue();
        }
        return null;
    }

    public RevocationInfo getRevocationInfoAttribute(X501Attributes attrs) throws PDFSignatureException {
        byte[] oid = new byte[]{42, -122, 72, -122, -9, 47, 1, 1, 8};
        return this.getAdobeRevocationInfoValue(oid, attrs);
    }

    private RevocationInfo getAdobeRevocationInfoValue(byte[] oid, X501Attributes attrs) throws PDFSignatureException {
        NonStandardAttribute revInfoAttrib;
        if (attrs != null && (revInfoAttrib = (NonStandardAttribute)attrs.getAttributeByOID(oid)) != null) {
            return this.parseRevocationInfo(revInfoAttrib.getValue());
        }
        return new RevocationInfo();
    }

    private RevocationInfo parseRevocationInfo(byte[] revInfoBytes) throws PDFSignatureException {
        RevocationInfo revInfoArchivalObj = new RevocationInfo();
        try {
            ASN1Container nextContainer;
            int index;
            ASN1Container[] asn1Def;
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer crlSet = new EncodedContainer(10563584);
            EncodedContainer ocspSet = new EncodedContainer(10563585);
            EncodedContainer otherRevInfoSet = new EncodedContainer(10563586);
            ASN1Container[] contentASN1Def = new ASN1Container[]{seq, crlSet, ocspSet, otherRevInfoSet, endContainer};
            ASN1.berDecode((byte[])revInfoBytes, (int)0, (ASN1Container[])contentASN1Def);
            if (contentASN1Def[1].dataPresent) {
                OfContainer crl = new OfContainer(0xA10000, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
                asn1Def = new ASN1Container[]{crl};
                ASN1.berDecode((byte[])contentASN1Def[1].data, (int)contentASN1Def[1].dataOffset, (ASN1Container[])asn1Def);
                int crlCount = crl.getContainerCount();
                byte[][] crlData = new byte[crlCount][];
                for (index = 0; index < crlCount; ++index) {
                    nextContainer = crl.containerAt(index);
                    byte[] crlBytes = new byte[nextContainer.dataLen];
                    System.arraycopy(nextContainer.data, nextContainer.dataOffset, crlBytes, 0, nextContainer.dataLen);
                    crlData[index] = crlBytes;
                }
                revInfoArchivalObj.setCRLData(crlData);
            }
            if (contentASN1Def[2].dataPresent) {
                OfContainer ocsp = new OfContainer(0xA10001, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
                asn1Def = new ASN1Container[]{ocsp};
                ASN1.berDecode((byte[])contentASN1Def[2].data, (int)contentASN1Def[2].dataOffset, (ASN1Container[])asn1Def);
                int ocspCount = ocsp.getContainerCount();
                byte[][] ocspData = new byte[ocspCount][];
                for (index = 0; index < ocspCount; ++index) {
                    nextContainer = ocsp.containerAt(index);
                    byte[] ocspBytes = new byte[nextContainer.dataLen];
                    System.arraycopy(nextContainer.data, nextContainer.dataOffset, ocspBytes, 0, nextContainer.dataLen);
                    ocspData[index] = ocspBytes;
                }
                revInfoArchivalObj.setOCSPResponses(ocspData);
            }
            if (contentASN1Def[3].dataPresent) {
                OfContainer otherRevInfo = new OfContainer(10551298, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
                asn1Def = new ASN1Container[]{otherRevInfo};
                ASN1.berDecode((byte[])contentASN1Def[3].data, (int)contentASN1Def[3].dataOffset, (ASN1Container[])asn1Def);
                int otherRevInfoCount = otherRevInfo.getContainerCount();
                byte[][] otherRevInfoData = new byte[otherRevInfoCount][];
                for (index = 0; index < otherRevInfoCount; ++index) {
                    nextContainer = otherRevInfo.containerAt(index);
                    byte[] otherRevInfoBytes = new byte[nextContainer.dataLen];
                    System.arraycopy(nextContainer.data, nextContainer.dataOffset, otherRevInfoBytes, 0, nextContainer.dataLen);
                    otherRevInfoData[index] = otherRevInfoBytes;
                }
                revInfoArchivalObj.setOtherRevInfo(otherRevInfoData);
            }
            return revInfoArchivalObj;
        }
        catch (ASN_Exception e) {
            throw new PDFSignatureException("Cannot decode the BER of the AdobeRevocationInfoArchival attribute", e);
        }
    }
}

