/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.credentials.impl.HSMCredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.securityframework.CryptoMode;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsCADES;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAASNUtilities;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSARevInfoUtil;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSASigningUtils;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSATimeStampingUtil;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.ContentType;
import com.rsa.certj.cert.attributes.NonStandardAttribute;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.pkcs7.SignerInfo;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;

public final class RSAPKCS7SignedDataBuilder {
    private static final byte[] OID_SIGNING_CERTIFICATE_V2_ATTRIBUTE = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 16, 2, 47};
    private static final byte[] OID_SIGNING_CERTIFICATE_OLD_ATTRIBUTE = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 16, 2, 12};
    private static final byte[] OID_POLICY_IDENTIFIER_ATTRIBUTE = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 16, 2, 15};
    private static final byte[] OID_CONTENT_TYPE_DATA = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 1};
    private static final byte[] OID_CONTENT_TYPE = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 3};
    public static final String CERTIFICATE_HASH_ALGORITHM_NAME_FOR_OLD_SIGNING_CERTIFICATE_ATTRIBUTE = "SHA1";

    private byte[] buildSignedData(byte[] digestBytes, RSACredentials credentials, CryptoContext ctx, boolean isDummyDigest, boolean isDetached, SignatureOptionsCADES sigOptionsCADES) throws PDFSignatureException, JSAFE_InvalidUseException {
        boolean embedRevocationInfo = ctx.embedRevocationInfo();
        boolean applyTimestamp = ctx.applyTimestamp();
        byte[] pkcs7Bytes = null;
        try {
            int status;
            ContentInfo content;
            Certificate[] rsaCertChain = credentials.getRSAX509CertChain();
            SignedData signedData = this.constructSignedDataObject(credentials, ctx.getMode());
            if (isDetached) {
                if ("DSA".equals(ctx.getSignatureAlgorithm())) {
                    content = ContentInfo.getInstance((int)1, null, null);
                    ((Data)content).setContent(digestBytes, 0, digestBytes.length);
                    signedData.setContentInfo(content);
                } else {
                    signedData.setDigest(digestBytes, ctx.getDigestAlgorithm());
                }
            } else {
                content = ContentInfo.getInstance((int)1, null, null);
                ((Data)content).setContent(digestBytes, 0, digestBytes.length);
                signedData.setContentInfo(content);
            }
            SignerInfo signerInfo = this.constructSignerInfo(credentials, ctx.getSignatureAlgorithm(), ctx.getDigestAlgorithm());
            if (sigOptionsCADES != null) {
                RSAPKCS7SignedDataBuilder.addCaDesSpecificAttributesToSignerInfo(signerInfo, credentials.getRSAX509Cert(), sigOptionsCADES);
            }
            signedData.addSignerInfo(signerInfo);
            if (rsaCertChain != null) {
                for (int i = 0; i < rsaCertChain.length; ++i) {
                    signedData.addCertificate((X509Certificate)rsaCertChain[i]);
                }
            } else {
                signedData.addCertificate(credentials.getRSAX509Cert());
            }
            if (isDetached) {
                signedData.createDetachedSignature();
            }
            if (embedRevocationInfo) {
                RSARevInfoUtil.addRevocationAttributeToSignerInfo(signedData, ctx.getRevocationInfoProvider());
            }
            int pkcs7Size = signedData.getContentInfoDERLen();
            if (ctx.applyTimestamp() && (status = RSATimeStampingUtil.addTSAttributeToSignerInfo(signedData, ctx.getTimeStampProvider(), isDummyDigest)) == 1) {
                pkcs7Size = signedData.getContentInfoDERLen();
            }
            pkcs7Bytes = new byte[pkcs7Size];
            signedData.writeMessage(pkcs7Bytes, 0);
            signedData.clearSensitiveData();
        }
        catch (CertificateEncodingException e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object.", e);
        }
        catch (CertificateException e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object.The certificate used has a problem", e);
        }
        catch (JSAFE_UnimplementedException e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object.", e);
        }
        catch (InvalidParameterException e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object.Parameters sent to the rsa cert-j api's are incorrect", e);
        }
        catch (InvalidUseException e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object. We are using the rsa cert-j api's incorrectly. ", e);
        }
        catch (ProviderManagementException e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object.", e);
        }
        catch (PKCS7Exception e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object.", e);
        }
        catch (NameException e) {
            throw new PDFSignatureException("Error building PKCS#7 SignedData object.", e);
        }
        catch (PDFSignatureException e) {
            String error_msg = "attributes";
            if (embedRevocationInfo) {
                error_msg = "Revocation attribute";
            }
            if (applyTimestamp) {
                error_msg = "Timestamp attribute";
            }
            if (embedRevocationInfo && applyTimestamp) {
                error_msg = "Revocation and timestamp attributes";
            }
            throw new PDFSignatureException("Error adding " + error_msg + " to PKCS#7 SignedData object.", e);
        }
        return pkcs7Bytes;
    }

    private static void addCaDesSpecificAttributesToSignerInfo(SignerInfo signerInfo, X509Certificate signingCertificate, SignatureOptionsCADES sigOptionsCADES) throws PDFSignatureException {
        try {
            byte[] contentTypeAttributeValue;
            X501Attribute policyIdentiferAttribute;
            X501Attribute signingCertificateAttribute = RSAPKCS7SignedDataBuilder.createSigningCertificateAttribute(sigOptionsCADES.getCertificateHashAlgorithmName(), signingCertificate, sigOptionsCADES.isPolicyInformationInSigningCertificateAttributeEnabled());
            RSASigningUtils.addAuthenticatedAttribute(signerInfo, signingCertificateAttribute);
            if (sigOptionsCADES.isSignaturePolicyIdentifierAttributeEnabled() && (policyIdentiferAttribute = RSAPKCS7SignedDataBuilder.createPolicyIdentifierAttribute(sigOptionsCADES.getPolicyHashAlgorithmName(), signingCertificate, sigOptionsCADES.getPolicyID())) != null) {
                RSASigningUtils.addAuthenticatedAttribute(signerInfo, policyIdentiferAttribute);
            }
            if (!Arrays.equals(contentTypeAttributeValue = RSASigningUtils.getContentTypeAttributeValue(signerInfo), OID_CONTENT_TYPE_DATA)) {
                ContentType contentTypeAttribute = new ContentType(OID_CONTENT_TYPE_DATA, 0, OID_CONTENT_TYPE_DATA.length);
                RSASigningUtils.addAuthenticatedAttribute(signerInfo, (X501Attribute)contentTypeAttribute);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error adding authenticated attributes", e);
        }
    }

    static X501Attribute createPolicyIdentifierAttribute(String policyDigestHashAlgorithmName, X509Certificate signingCertificate, byte[] policyID) throws PDFSignatureException {
        NonStandardAttribute policyIdentifierAttribute = new NonStandardAttribute();
        policyIdentifierAttribute.setOID(OID_POLICY_IDENTIFIER_ATTRIBUTE, 0, OID_POLICY_IDENTIFIER_ATTRIBUTE.length);
        byte[] attributeValue = null;
        try {
            attributeValue = RSAASNUtilities.getPolicyIdentiferAttributeDerEncoded(policyDigestHashAlgorithmName, signingCertificate, policyID);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error creating signaturePolicyIdentifier attribute", e);
        }
        if (attributeValue == null) {
            return null;
        }
        policyIdentifierAttribute.setValue(attributeValue, 0, attributeValue.length);
        return policyIdentifierAttribute;
    }

    static X501Attribute createSigningCertificateAttribute(String certificateDigestHashAlgorithmName, X509Certificate signingCertificate, boolean isPolicyInformationRequired) throws PDFSignatureException {
        NonStandardAttribute signingCertificateAttribute = new NonStandardAttribute();
        if (certificateDigestHashAlgorithmName.equalsIgnoreCase(CERTIFICATE_HASH_ALGORITHM_NAME_FOR_OLD_SIGNING_CERTIFICATE_ATTRIBUTE)) {
            signingCertificateAttribute.setOID(OID_SIGNING_CERTIFICATE_OLD_ATTRIBUTE, 0, OID_SIGNING_CERTIFICATE_OLD_ATTRIBUTE.length);
        } else {
            signingCertificateAttribute.setOID(OID_SIGNING_CERTIFICATE_V2_ATTRIBUTE, 0, OID_SIGNING_CERTIFICATE_V2_ATTRIBUTE.length);
        }
        byte[] attributeValue = null;
        try {
            attributeValue = RSAASNUtilities.getSigningCertificateVXDerEncoded(certificateDigestHashAlgorithmName, signingCertificate, isPolicyInformationRequired);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error Creating SigningCertificate Attribute", e);
        }
        signingCertificateAttribute.setValue(attributeValue, 0, attributeValue.length);
        return signingCertificateAttribute;
    }

    private SignedData constructSignedDataObject(RSACredentials credentials, CryptoMode mode) throws CertificateEncodingException, JSAFE_UnimplementedException, InvalidParameterException, ProviderManagementException, InvalidUseException, PKCS7Exception, CertificateException, PDFSignatureException, JSAFE_InvalidUseException {
        if (credentials instanceof HSMCredentials) {
            try {
                return RSASigningUtils.buildRSASignedDataForHSM((HSMCredentials)credentials);
            }
            catch (Exception e) {
                throw new PDFSignatureException("Could not parse HSM credentials when constructing SignedData object", e);
            }
        }
        return RSASigningUtils.buildRSASignedDataWithMemoryDB(credentials, mode);
    }

    private SignerInfo constructSignerInfo(RSACredentials credentials, String signatureAlgorithm, String digestMethod) throws NameException, PKCS7Exception, CertificateException {
        SignerInfo signerInfo = new SignerInfo();
        if (credentials instanceof HSMCredentials) {
            X509Certificate cert = ((HSMCredentials)credentials).getRSAX509Cert();
            X500Name signerName = new X500Name();
            signerName = cert.getIssuerName();
            byte[] signerNumber = cert.getSerialNumber();
            signerInfo.setIssuerAndSerialNumber(signerName, signerNumber, 0, signerNumber.length);
        } else {
            X500Name signerName = new X500Name();
            signerName = credentials.getRSAX509Cert().getIssuerName();
            byte[] signerNumber = credentials.getRSAX509Cert().getSerialNumber();
            signerInfo.setIssuerAndSerialNumber(signerName, signerNumber, 0, signerNumber.length);
        }
        if (signatureAlgorithm.equalsIgnoreCase("EC")) {
            X501Attributes attributes = new X501Attributes();
            ContentType contentType = new ContentType(OID_CONTENT_TYPE, 0, OID_CONTENT_TYPE.length);
            attributes.addAttribute((X501Attribute)contentType);
            signerInfo.setAuthenticatedAttrs(attributes);
            signerInfo.setEncryptionAlgorithm("ECDSA");
        } else {
            signerInfo.setEncryptionAlgorithm(signatureAlgorithm);
        }
        signerInfo.setDigestAlgorithm(digestMethod);
        return signerInfo;
    }

    public byte[] buildPacket(byte[] signatureBytes, RSACredentials credentials, CryptoContext cryptoContext, boolean isDummyDigest, boolean isDetached) throws PDFSignatureException {
        try {
            return this.buildSignedData(signatureBytes, credentials, cryptoContext, isDummyDigest, isDetached, null);
        }
        catch (JSAFE_InvalidUseException e) {
            throw new PDFSignatureException(e);
        }
    }

    public byte[] buildPacketForCADES(byte[] signatureBytes, RSACredentials credentials, CryptoContext cryptoContext, boolean isDummyDigest, SignatureOptionsCADES sigOptionsCADES) throws PDFSignatureException {
        try {
            return this.buildSignedData(signatureBytes, credentials, cryptoContext, isDummyDigest, true, sigOptionsCADES);
        }
        catch (JSAFE_InvalidUseException e) {
            throw new PDFSignatureException(e);
        }
    }
}

