/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public final class JCETimeStampingUtil {
    public static Attribute createTSAttribute(SignerInformation signerInfo, TimeStampProvider tsProvider, boolean isDummyToken) throws PDFSignatureException {
        byte[] encryptedDigest = JCETimeStampingUtil.getEncryptedDigest(signerInfo);
        return JCETimeStampingUtil.createTSAttribute(encryptedDigest, tsProvider, isDummyToken);
    }

    public static Attribute createTSAttribute(byte[] encryptedDigest, TimeStampProvider tsProvider, boolean isDummyToken) throws PDFSignatureException {
        tsProvider.setDataToTimestamp(encryptedDigest);
        byte[] tstokenbytes = isDummyToken ? JCETimeStampingUtil.createDummyTimestampToken(tsProvider) : tsProvider.getTimestampToken();
        if (tstokenbytes == null || tstokenbytes.length == 0) {
            return null;
        }
        return new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DLSet((ASN1Encodable)ASN1Sequence.getInstance((Object)tstokenbytes)));
    }

    private static byte[] createDummyTimestampToken(TimeStampProvider tsProvider) throws PDFSignatureException {
        int timestampTokenSize = tsProvider.getTimestampTokenSize();
        if (timestampTokenSize == 0) {
            throw new PDFSignatureException("The timestamp token size is zero, The dummy pkcs#7 digest cannot be built");
        }
        return new byte[timestampTokenSize];
    }

    public static CMSSignedData addTSAttributeToSignedData(CMSSignedData signedData, TimeStampProvider tsProvider, boolean isDummyToken) throws PDFSignatureException {
        if (tsProvider == null) {
            throw new PDFSignatureException("No timestamp provider has been registered with the SignatureManager");
        }
        SignerInformationStore signerStore = signedData.getSignerInfos();
        ArrayList oldSigners = (ArrayList)signerStore.getSigners();
        ArrayList<SignerInformation> newSigners = new ArrayList<SignerInformation>();
        for (SignerInformation sigInfo : oldSigners) {
            newSigners.add(JCETimeStampingUtil.signTimeStamp(sigInfo, tsProvider, isDummyToken));
        }
        return CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)new SignerInformationStore(newSigners));
    }

    private static SignerInformation signTimeStamp(SignerInformation signer, TimeStampProvider tsProvider, boolean isDummyToken) throws PDFSignatureException {
        AttributeTable unsignedAttributes = signer.getUnsignedAttributes();
        ASN1EncodableVector attributeVector = null;
        attributeVector = unsignedAttributes != null ? unsignedAttributes.toASN1EncodableVector() : new ASN1EncodableVector();
        Attribute tsAttribute = JCETimeStampingUtil.createTSAttribute(signer, tsProvider, isDummyToken);
        attributeVector.add((ASN1Encodable)tsAttribute);
        unsignedAttributes = new AttributeTable(attributeVector);
        SignerInformation newSigner = SignerInformation.replaceUnsignedAttributes((SignerInformation)signer, (AttributeTable)unsignedAttributes);
        return newSigner;
    }

    private static byte[] getEncryptedDigest(SignerInformation signerInfo) {
        return signerInfo.getSignature();
    }
}

