/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.BCUtilities;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.SignerInformationUtility;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;

public class CADESDetachedVerifier
extends Verifier {
    private static byte[] CONTENT_TYPE_DATA_VALUE;
    private static final String DEFAULT_CERTIFICATE_HASH_ALGORITHM_NAME = "SHA256";
    private static final String CERTIFICATE_HASH_ALGORITHM_NAME_FOR_OLD_SIGNING_CERTIFICATE_ATTRIBUTE = "SHA";
    private static final Map<String, byte[]> knownViolators;

    @Override
    public boolean verify(InputStream inputStream, byte[] signaturePacketData) throws PDFSignatureException {
        try {
            byte[] dataToVerify = new byte[inputStream.available()];
            inputStream.read(dataToVerify);
            CMSSignedData s = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(dataToVerify), signaturePacketData);
            JcaCertStoreBuilder storeBuilder = new JcaCertStoreBuilder();
            storeBuilder.addCertificates(s.getCertificates());
            storeBuilder.addCRLs(s.getCRLs());
            CertStore certs = storeBuilder.build();
            SignerInformationStore signers = s.getSignerInfos();
            boolean verified = false;
            for (SignerInformation signer : signers.getSigners()) {
                SignerId signer_id = signer.getSID();
                JcaX509CertSelectorConverter conv = new JcaX509CertSelectorConverter();
                X509CertificateHolderSelector sel = new X509CertificateHolderSelector(signer_id.getIssuer(), signer_id.getSerialNumber());
                X509CertSelector signerConstraints = conv.getCertSelector(sel);
                Collection<? extends Certificate> certCollection = certs.getCertificates(signerConstraints);
                BcRSASignerInfoVerifierBuilder infoBuilder = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider());
                for (X509Certificate x509Certificate : certCollection) {
                    SignerInformationVerifier sigVerifier = infoBuilder.build(new X509CertificateHolder(x509Certificate.getEncoded()));
                    if (!signer.verify(sigVerifier) && this.isIssuerKnownViolator(x509Certificate)) {
                        signer = SignerInformationUtility.patchRsaDigestSignature(x509Certificate.getPublicKey(), signer);
                    }
                    if (!signer.verify(sigVerifier) || !(verified = this.verifySignedAttributes(signer, x509Certificate) && this.verifyUnsignedAttributes(signer))) continue;
                    return true;
                }
            }
        }
        catch (CMSException e) {
            return false;
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error Verifying CADES Detached Signature", e);
        }
        return false;
    }

    private boolean isIssuerKnownViolator(X509Certificate cert) {
        if (knownViolators.containsKey(cert.getIssuerX500Principal().getName())) {
            try {
                return Arrays.equals(cert.getEncoded(), knownViolators.get(cert.getIssuerX500Principal().getName()));
            }
            catch (CertificateEncodingException e) {
                return false;
            }
        }
        return false;
    }

    private boolean verifySignedAttributes(SignerInformation signer, X509Certificate verifyingCertificate) throws PDFSignatureException {
        AttributeTable signedAttributesTable = signer.getSignedAttributes();
        if (signedAttributesTable == null) {
            return false;
        }
        boolean result = this.verifyContentTypeAttribute(signedAttributesTable) && this.verifyMessageDigestAttribute(signedAttributesTable) && this.verifySigningCertificateAttribute(signedAttributesTable, verifyingCertificate);
        return result;
    }

    private boolean verifyUnsignedAttributes(SignerInformation signer) throws PDFSignatureException {
        AttributeTable unsignedAttributes = signer.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return true;
        }
        Attribute timeStampAttribute = unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        if (timeStampAttribute != null) {
            byte[] timeStampTokenValue = BCUtilities.getASN1EncodedAttributeValue(timeStampAttribute);
            if (timeStampTokenValue == null) {
                throw new PDFSignatureException("Time stamp attribute is present in the signature but the value corresponding to it is not.");
            }
            try {
                TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(timeStampTokenValue));
                boolean result = BCUtilities.verifyTimestampToken(timeStampToken);
                if (!result) {
                    return false;
                }
                byte[] messageImprintDigest = timeStampToken.getTimeStampInfo().getMessageImprintDigest();
                String messageImprintAlgorithmName = SignatureUtils.getAlgorithmName(timeStampToken.getTimeStampInfo().getMessageImprintAlgOID());
                MessageDigest digester = MessageDigest.getInstance(messageImprintAlgorithmName, BCUtilities.provider);
                byte[] signatureBytes = signer.getSignature();
                digester.update(signatureBytes);
                byte[] signatureDigest = digester.digest();
                return Arrays.equals(signatureDigest, messageImprintDigest);
            }
            catch (Exception e) {
                throw new PDFSignatureException("Error validating time stamp token attribute", e);
            }
        }
        return true;
    }

    private boolean verifyContentTypeAttribute(AttributeTable signedAttributesTable) {
        Attribute contentTypeAttribute = signedAttributesTable.get(CMSAttributes.contentType);
        if (contentTypeAttribute == null) {
            return false;
        }
        byte[] contentTypeAttributeValue = BCUtilities.getASN1EncodedAttributeValue(contentTypeAttribute);
        return Arrays.equals(contentTypeAttributeValue, CONTENT_TYPE_DATA_VALUE);
    }

    private boolean verifyMessageDigestAttribute(AttributeTable signedAttributesTable) {
        Attribute messageDigestAttribute = signedAttributesTable.get(CMSAttributes.messageDigest);
        if (messageDigestAttribute != null) {
            return BCUtilities.getASN1EncodedAttributeValue(messageDigestAttribute) != null;
        }
        return false;
    }

    private boolean verifySigningCertificateAttribute(AttributeTable signedAttributesTable, X509Certificate verifyingCertificate) throws PDFSignatureException {
        SigningCertificate signingCertificateOLD;
        Attribute signingCertificateAttribute;
        SigningCertificateV2 signingCertificateV2;
        boolean found = false;
        Attribute signingCertificateV2Attribute = signedAttributesTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
        if (signingCertificateV2Attribute != null && (signingCertificateV2 = SigningCertificateV2.getInstance((Object)BCUtilities.getASN1EncodableAttributeValue(signingCertificateV2Attribute))) != null) {
            found = true;
            if (!this.verifySigningCertificateV2Attribute(signingCertificateV2, verifyingCertificate)) {
                return false;
            }
        }
        if ((signingCertificateAttribute = signedAttributesTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate)) != null && (signingCertificateOLD = SigningCertificate.getInstance((Object)BCUtilities.getASN1EncodableAttributeValue(signingCertificateAttribute))) != null) {
            found = true;
            if (!this.verifySigningCertificateOLDAttribute(signingCertificateOLD, verifyingCertificate)) {
                return false;
            }
        }
        return found;
    }

    private boolean verifySigningCertificateV2Attribute(SigningCertificateV2 signingCertificateV2, X509Certificate verifyingCertificate) throws PDFSignatureException {
        ESSCertIDv2[] essCertsIDv2 = signingCertificateV2.getCerts();
        if (essCertsIDv2 == null || essCertsIDv2.length == 0) {
            return false;
        }
        ESSCertIDv2 essCertIDv2 = essCertsIDv2[0];
        try {
            String hashAlgorithmName = essCertIDv2.getHashAlgorithm() == null ? null : SignatureUtils.getAlgorithmName(essCertIDv2.getHashAlgorithm().getAlgorithm());
            boolean result = this.verifyCertificateHashValue(verifyingCertificate, essCertIDv2.getCertHash(), hashAlgorithmName) && this.verifyIssuerSerial(verifyingCertificate, essCertIDv2.getIssuerSerial()) && this.verifyPolicyInformation(verifyingCertificate, signingCertificateV2.getPolicies());
            return result;
        }
        catch (CertificateEncodingException e) {
            throw new PDFSignatureException("Error verifying Certifcate Hash Value in SigningCertificateV2 attribute", e);
        }
        catch (IOException e) {
            throw new PDFSignatureException("Error verifying Certifcate Hash Value in SigningCertificateV2 attribute", e);
        }
    }

    private boolean verifySigningCertificateOLDAttribute(SigningCertificate signingCertificateOLD, X509Certificate verifyingCertificate) throws PDFSignatureException {
        ESSCertID[] essCertsID = signingCertificateOLD.getCerts();
        if (essCertsID == null || essCertsID.length == 0) {
            return false;
        }
        ESSCertID essCertID = essCertsID[0];
        try {
            boolean result = this.verifyCertificateHashValue(verifyingCertificate, essCertID.getCertHash(), CERTIFICATE_HASH_ALGORITHM_NAME_FOR_OLD_SIGNING_CERTIFICATE_ATTRIBUTE) && this.verifyIssuerSerial(verifyingCertificate, essCertID.getIssuerSerial()) && this.verifyPolicyInformation(verifyingCertificate, signingCertificateOLD.getPolicies());
            return result;
        }
        catch (CertificateEncodingException e) {
            throw new PDFSignatureException("Error verifying Certifcate Hash Value in SigningCertificateV2 attribute", e);
        }
        catch (IOException e) {
            throw new PDFSignatureException("Error verifying Certifcate Hash Value in SigningCertificateV2 attribute", e);
        }
    }

    private boolean verifyCertificateHashValue(X509Certificate verifyingCertificate, byte[] signedCertificateHash, String hashAlgorithmName) throws PDFSignatureException {
        try {
            byte[] verifyingCertificateBytes = verifyingCertificate.getEncoded();
            if (hashAlgorithmName == null) {
                hashAlgorithmName = DEFAULT_CERTIFICATE_HASH_ALGORITHM_NAME;
            }
            MessageDigest digester = MessageDigest.getInstance(hashAlgorithmName, BCUtilities.provider);
            digester.update(verifyingCertificateBytes);
            byte[] verifyingCertificateHash = digester.digest();
            return Arrays.equals(verifyingCertificateHash, signedCertificateHash);
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error verifying cert hash value in ESSCertV2", e);
        }
    }

    private boolean verifyIssuerSerial(X509Certificate verifyingCertificate, IssuerSerial issuerSerial) throws PDFSignatureException, CertificateEncodingException, IOException {
        BigInteger verifyingCertificateIssuerSerialNumber;
        if (issuerSerial == null) {
            return true;
        }
        if (issuerSerial.getSerial() == null) {
            return false;
        }
        BigInteger signedIssuerSerialNumber = issuerSerial.getSerial().getValue();
        if (!signedIssuerSerialNumber.equals(verifyingCertificateIssuerSerialNumber = verifyingCertificate.getSerialNumber())) {
            return false;
        }
        X509CertificateHolder verifyingCertH = new X509CertificateHolder(verifyingCertificate.getEncoded());
        String verifyingCertificateIssuerName = new X500Name(verifyingCertH.getIssuer().getRDNs()).toString();
        GeneralNames issuerNames = issuerSerial.getIssuer();
        if (issuerNames == null) {
            return false;
        }
        GeneralName[] issuerNamesArray = issuerNames.getNames();
        if (issuerNamesArray == null || issuerNamesArray.length != 1) {
            return false;
        }
        String signedIssuerName = issuerNamesArray[0].getName().toString();
        return signedIssuerName.equals(verifyingCertificateIssuerName);
    }

    private boolean verifyPolicyInformation(X509Certificate verifyingCertificate, PolicyInformation[] signedPolicyInformationArray) throws PDFSignatureException {
        if (signedPolicyInformationArray == null) {
            return true;
        }
        try {
            ASN1Sequence verifyingCertificatePolicyList = CADESDetachedVerifier.getPolicyListFromCertificate(verifyingCertificate);
            if (verifyingCertificatePolicyList == null) {
                return false;
            }
            for (int j = 0; j < verifyingCertificatePolicyList.size(); ++j) {
                PolicyInformation verifyingCertificatePolicy = PolicyInformation.getInstance((Object)verifyingCertificatePolicyList.getObjectAt(j));
                for (int i = 0; i < signedPolicyInformationArray.length; ++i) {
                    if (!signedPolicyInformationArray[i].getPolicyIdentifier().getId().equals(verifyingCertificatePolicy.getPolicyIdentifier().getId())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error validating policy information in signingcertificateV2 attribute", e);
        }
        return false;
    }

    private static ASN1Sequence getPolicyListFromCertificate(X509Certificate certificate) throws IOException, PDFInvalidParameterException {
        byte[] certificatePoliciesExtensionValue = certificate.getExtensionValue(X509Extensions.CertificatePolicies.getId());
        if (certificatePoliciesExtensionValue == null) {
            return null;
        }
        ASN1OctetString localASN1OctetString = ASN1OctetString.getInstance((Object)new ASN1InputStream(certificatePoliciesExtensionValue).readObject());
        return ASN1Sequence.getInstance((Object)new ASN1InputStream(localASN1OctetString.getOctets()).readObject());
    }

    static {
        try {
            CONTENT_TYPE_DATA_VALUE = PKCSObjectIdentifiers.data.getEncoded("DER");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        knownViolators = new HashMap<String, byte[]>();
        knownViolators.put("C=IN,1.2.840.113549.1.9.1=#16054140532e53,OU=CT,O=ADBE,CN=Shantanu", new byte[]{48, -126, 2, 67, 48, -126, 1, -84, -96, 3, 2, 1, 2, 2, 10, 18, 34, -125, -118, 81, 79, 16, -71, 38, 85, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 82, 49, 17, 48, 15, 6, 3, 85, 4, 3, 19, 8, 83, 104, 97, 110, 116, 97, 110, 117, 49, 13, 48, 11, 6, 3, 85, 4, 10, 19, 4, 65, 68, 66, 69, 49, 11, 48, 9, 6, 3, 85, 4, 11, 19, 2, 67, 84, 49, 20, 48, 18, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 5, 65, 64, 83, 46, 83, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 73, 78, 48, 30, 23, 13, 48, 57, 48, 55, 51, 48, 49, 51, 53, 49, 51, 56, 90, 23, 13, 49, 52, 48, 55, 51, 48, 49, 51, 53, 49, 51, 56, 90, 48, 82, 49, 17, 48, 15, 6, 3, 85, 4, 3, 19, 8, 83, 104, 97, 110, 116, 97, 110, 117, 49, 13, 48, 11, 6, 3, 85, 4, 10, 19, 4, 65, 68, 66, 69, 49, 11, 48, 9, 6, 3, 85, 4, 11, 19, 2, 67, 84, 49, 20, 48, 18, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 5, 65, 64, 83, 46, 83, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 73, 78, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -63, 35, -66, 16, -10, 102, 23, 88, -89, -102, 57, -3, -83, 116, -116, 51, -91, 90, -99, 13, -103, 49, -118, -89, 104, -48, 93, -115, 2, 100, 118, 106, 124, -85, -30, 43, 106, 16, 99, -71, -49, -19, -35, -10, 112, 41, -127, 73, 72, -23, 61, 106, 71, 46, -67, 35, -99, -91, 25, -125, -60, 100, -37, -48, 33, 96, -11, 81, 4, -54, -51, 94, -62, -11, -120, 38, 37, -88, 108, 113, -71, -128, -119, -32, -18, 47, 110, 124, 45, -73, 55, -109, 14, -21, -3, -111, -83, 127, 33, 53, 120, 41, 99, -5, 65, 117, 48, 58, 30, -126, 38, 97, 13, -74, 8, -44, 115, -43, 81, 73, -70, -23, 39, -21, -127, 51, -43, 21, 2, 3, 1, 0, 1, -93, 32, 48, 30, 48, 15, 6, 9, 42, -122, 72, -122, -9, 47, 1, 1, 10, 4, 2, 5, 0, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -106, -60, -9, -114, 7, 107, 24, 78, -74, -22, -70, -84, 99, -84, -80, -17, -78, -33, -96, -115, -10, 81, -86, -6, -63, 21, -77, -15, 56, -36, 93, 35, 90, 28, -81, -64, -66, 67, 3, -118, 90, 120, 78, -113, 127, 14, 103, 26, 84, -47, 98, -1, -8, -1, -85, 35, 65, -119, -69, -75, -54, 84, -34, 124, 35, 66, -72, -88, -112, -69, -17, -89, 108, -94, -24, 86, -62, -2, -91, -24, 54, -22, 75, 1, -67, 68, 45, 0, 8, 115, 73, -9, 34, -91, 32, -82, 78, 95, 81, 67, 44, 89, -64, 69, 110, -101, 42, 98, -95, -21, 3, -81, -86, 17, 41, -14, -90, 32, 97, -26, -52, 114, -107, 68, 0, -33, 12, 6});
        knownViolators.put("CN=Enterprise Services CA,OU=Class 2 OnSite Individual Subscriber CA,OU=Terms of use at https://www.verisign.com/rpa (c)01,OU=VeriSign Trust Network,O=Adobe Systems Incorporated", new byte[]{48, -126, 4, 117, 48, -126, 3, -34, -96, 3, 2, 1, 2, 2, 16, 84, -17, 103, 84, -37, -81, 68, 28, 69, 115, -79, -119, -65, 98, 110, 93, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -42, 49, 35, 48, 33, 6, 3, 85, 4, 10, 19, 26, 65, 100, 111, 98, 101, 32, 83, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 111, 114, 112, 111, 114, 97, 116, 101, 100, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 59, 48, 57, 6, 3, 85, 4, 11, 19, 50, 84, 101, 114, 109, 115, 32, 111, 102, 32, 117, 115, 101, 32, 97, 116, 32, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 112, 97, 32, 40, 99, 41, 48, 49, 49, 48, 48, 46, 6, 3, 85, 4, 11, 19, 39, 67, 108, 97, 115, 115, 32, 50, 32, 79, 110, 83, 105, 116, 101, 32, 73, 110, 100, 105, 118, 105, 100, 117, 97, 108, 32, 83, 117, 98, 115, 99, 114, 105, 98, 101, 114, 32, 67, 65, 49, 31, 48, 29, 6, 3, 85, 4, 3, 19, 22, 69, 110, 116, 101, 114, 112, 114, 105, 115, 101, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 67, 65, 48, 30, 23, 13, 49, 48, 48, 57, 48, 51, 48, 48, 48, 48, 48, 48, 90, 23, 13, 49, 49, 48, 57, 48, 51, 50, 51, 53, 57, 53, 57, 90, 48, -127, -70, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 67, 80, 83, 32, 73, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 82, 101, 102, 46, 44, 76, 73, 65, 66, 46, 76, 84, 68, 40, 99, 41, 57, 57, 49, 55, 48, 53, 6, 3, 85, 4, 11, 20, 46, 65, 100, 111, 98, 101, 32, 67, 80, 83, 32, 45, 32, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 97, 100, 111, 98, 101, 46, 99, 111, 109, 47, 109, 105, 115, 99, 47, 67, 80, 83, 46, 104, 116, 109, 108, 49, 21, 48, 19, 6, 3, 85, 4, 3, 19, 12, 72, 111, 110, 101, 121, 32, 75, 97, 110, 115, 97, 108, 49, 32, 48, 30, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 17, 104, 107, 97, 110, 115, 97, 108, 64, 97, 100, 111, 98, 101, 46, 99, 111, 109, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -70, 32, 121, 24, -66, 96, -71, 74, -7, -49, -90, -127, -108, 33, -1, 111, 125, -65, 65, 86, -107, 42, -50, 11, 100, 41, -107, 98, -68, -74, -60, -28, 117, -100, -86, 67, -98, -31, 110, 48, 86, 87, 37, 5, -29, 25, -23, -61, 126, 20, -83, 34, -47, -34, -99, 37, 56, -45, -127, 72, -80, -36, -32, -79, 106, -69, 66, 64, 36, 109, -91, -27, 115, 46, 5, -85, 119, 123, 94, 31, 102, 7, -54, -87, 73, 21, 88, 81, 109, 85, 65, -41, 83, 19, 124, -87, -10, 73, -27, -70, 53, -46, -5, 122, -103, -27, 74, 48, -103, -97, 7, -14, 64, -47, 105, 20, 116, 90, -78, 69, 48, -41, 80, -23, -84, 31, -22, -61, 82, 16, -74, -74, -34, 27, 91, 19, -90, 101, -56, 72, 117, 65, 105, 69, -67, -4, -78, 110, -32, 123, -94, 88, -94, 71, -16, 125, -82, -103, 93, 40, -114, 104, -28, -2, -99, -53, -116, 49, 47, 89, 64, 16, 52, -14, -75, -124, -94, 59, -22, 92, -82, 62, -56, 77, -94, 70, 49, 49, -119, -119, 45, 7, -61, -115, 104, -58, 58, 78, -12, 59, 111, -36, 34, -88, 113, -22, -87, -17, -39, -100, -37, -115, -63, 87, -128, -110, 84, -98, -19, 8, 46, -71, 7, 82, 18, 41, -61, 54, 96, 62, 39, -123, -82, -86, 100, -79, -44, 108, 63, 43, 73, -45, -12, -66, -60, -101, 75, 123, -2, 71, -32, -60, -60, -59, -12, 41, 2, 3, 1, 0, 1, -93, -127, -39, 48, -127, -42, 48, 9, 6, 3, 85, 29, 19, 4, 2, 48, 0, 48, 99, 6, 3, 85, 29, 31, 4, 92, 48, 90, 48, 88, -96, 86, -96, 84, -122, 82, 104, 116, 116, 112, 58, 47, 47, 111, 110, 115, 105, 116, 101, 99, 114, 108, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 65, 100, 111, 98, 101, 83, 121, 115, 116, 101, 109, 115, 73, 110, 99, 111, 114, 112, 111, 114, 97, 116, 101, 100, 69, 110, 116, 101, 114, 112, 114, 105, 115, 101, 83, 101, 114, 118, 105, 99, 101, 115, 47, 76, 97, 116, 101, 115, 116, 67, 82, 76, 48, 68, 6, 3, 85, 29, 32, 4, 61, 48, 59, 48, 57, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 23, 2, 48, 42, 48, 40, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 28, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 112, 97, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 5, -96, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 7, -128, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 51, 96, -89, -8, -89, 27, -69, -90, -81, 33, 7, 122, 126, -76, 55, 12, 54, 68, 127, -110, -93, 89, -7, 52, -39, 60, -128, -125, -42, 109, 108, 14, 80, -49, 73, -119, -115, -72, 108, -88, -49, -102, -103, -59, 95, -75, -97, 10, -95, 46, -70, -37, 89, 119, 82, 63, -14, 7, -1, 3, -61, -107, 100, -115, -38, 72, -53, 12, 126, 59, 1, -2, 107, -96, 59, 49, -92, 110, 34, -28, 32, -3, -70, -22, -58, 47, -25, 99, -31, 110, 112, -117, 23, -69, 31, -78, -106, -45, 18, 105, 82, -107, 52, 61, -92, 20, 27, -118, -20, -29, -2, 81, -6, -120, -80, 25, -2, 86, -17, -86, -18, -53, -128, 111, 97, 17, -63, -46});
    }
}

