/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.services.digsig.DocModAnalysisStatus;
import com.adobe.internal.pdftoolkit.services.digsig.XFAChangeLogger;
import java.util.HashMap;
import java.util.Map;

public class SignatureValidationStatus {
    PDFSignature signature;
    boolean byteRangeValid = false;
    DocModAnalysisStatus docModAnalysisStatus;
    XFAChangeLogger xfaChangeLogger = null;
    private boolean xfaFormModified;

    public boolean isByteRangeValid() {
        return this.byteRangeValid;
    }

    public void setByteRangeValid(boolean byteRangeValid) {
        this.byteRangeValid = byteRangeValid;
    }

    public void setXFAFormModified(boolean xfaFormModified) {
        this.xfaFormModified = xfaFormModified;
    }

    public boolean isXFAFormModified() {
        return this.xfaFormModified;
    }

    public DocModAnalysisStatus getDocModAnalysisStatus() {
        return this.docModAnalysisStatus;
    }

    void setDocModAnalysisStatus(DocModAnalysisStatus docModAnalysisStatus) {
        this.docModAnalysisStatus = docModAnalysisStatus;
    }

    public PDFSignature getPDFSignature() {
        return this.signature;
    }

    void setSignature(PDFSignature signature) {
        this.signature = signature;
    }

    public boolean isValid() {
        return this.isByteRangeValid() && this.docModAnalysisStatus.valid();
    }

    public SignatureValidationStatus(PDFSignature signature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.signature = signature;
        this.docModAnalysisStatus = new DocModAnalysisStatus(0, signature);
    }

    public void setXFAChangeLogger(XFAChangeLogger changeLogger) {
        this.xfaChangeLogger = changeLogger;
    }

    public HashMap getXFAChanges() {
        if (this.xfaChangeLogger != null) {
            return this.xfaChangeLogger.getChanges();
        }
        return null;
    }

    void dumpLog(HashMap changes) {
        for (Map.Entry entry : changes.entrySet()) {
            System.out.println((String)entry.getKey() + " = " + (String)entry.getValue());
        }
    }

    public String toString() {
        StringBuilder resultBuf = new StringBuilder();
        if (this.signature == null) {
            return resultBuf.append("No signature present").toString();
        }
        resultBuf.append("Validation results \n");
        resultBuf.append("\tOverall Status - ").append(this.isValid() ? " valid " : " invalid ");
        resultBuf.append("\n \tByteRange  - ").append(this.isByteRangeValid() ? " valid " : " invalid ");
        resultBuf.append("\n \tXFA Form Modified  - ").append(this.isXFAFormModified() ? " yes " : " no ");
        resultBuf.append("\t").append(this.getDocModAnalysisStatus().toString());
        if (this.xfaChangeLogger != null) {
            resultBuf.append("\nXFAChangeLogs - ");
            for (Map.Entry entry : this.xfaChangeLogger.getChanges().entrySet()) {
                resultBuf.append("\n \t Change Type : ").append((String)entry.getKey()).append("\n \t New Value : ").append((String)entry.getValue()).append("\n");
            }
        }
        return resultBuf.toString();
    }
}

