/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureAppearanceDateFormatter;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureAppearanceDirectionality;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureAppearanceDisplayItemsSet;
import java.util.Locale;

public class SignatureAppearanceOptions {
    private ASRectangle invisibleAppearanceRect = null;
    private PDFPage logo = null;
    private double logoOpacity = 1.0;
    private PDFPage graphic = null;
    private double graphicOpacity = 1.0;
    private boolean graphicIsName = false;
    private SignatureAppearanceDisplayItemsSet displayItems = SignatureAppearanceDisplayItemsSet.newInstance();
    private PDFFontSet fontSet = null;
    private Locale locale = null;
    private Locale ambientLocale = null;
    private SignatureAppearanceDirectionality directionality = SignatureAppearanceDirectionality.LTR;
    private SignatureAppearanceDateFormatter dateFormat = null;

    private SignatureAppearanceOptions() {
    }

    public static SignatureAppearanceOptions newInstance() {
        return new SignatureAppearanceOptions();
    }

    public void setInvisibleAppearanceSize(ASRectangle rect) {
        this.invisibleAppearanceRect = rect;
    }

    public ASRectangle getInvisibleAppearanceSize() {
        return this.invisibleAppearanceRect;
    }

    public boolean hasInvisibleAppearanceSize() {
        return this.invisibleAppearanceRect != null;
    }

    public void removeInvisibleAppearanceSize() {
        this.invisibleAppearanceRect = null;
    }

    public void setLogo(PDFPage logo) {
        this.logo = logo;
    }

    public PDFPage getLogo() {
        return this.logo;
    }

    public boolean hasLogo() {
        return this.logo != null;
    }

    public void removeLogo() {
        this.logo = null;
    }

    public void setLogoOpacity(double opacity) {
        this.logoOpacity = opacity;
    }

    public double getLogoOpacity() {
        return this.logoOpacity;
    }

    public void setGraphicImage(PDFPage graphic) {
        this.graphic = graphic;
        this.graphicIsName = false;
    }

    public PDFPage getGraphicImage() {
        return this.graphic;
    }

    public boolean hasGraphicImage() {
        return this.graphic != null;
    }

    public void removeGraphicImage() {
        this.graphic = null;
    }

    public void setGraphicName() {
        this.graphic = null;
        this.graphicIsName = true;
    }

    public boolean hasGraphicName() {
        return this.graphicIsName;
    }

    public boolean hasGraphic() {
        return this.hasGraphicImage() || this.hasGraphicName();
    }

    public void removeGraphic() {
        this.graphic = null;
        this.graphicIsName = false;
    }

    public void setGraphicOpacity(double opacity) {
        this.graphicOpacity = opacity;
    }

    public double getGraphicsOpacity() {
        return this.graphicOpacity;
    }

    public void setDisplayItems(SignatureAppearanceDisplayItemsSet displayItems) {
        this.displayItems = displayItems;
    }

    public SignatureAppearanceDisplayItemsSet getDisplayItems() {
        return this.displayItems;
    }

    public boolean hasDisplayItems() {
        return this.displayItems != null;
    }

    public void setDirectionality(SignatureAppearanceDirectionality directionality) {
        this.directionality = directionality == null ? SignatureAppearanceDirectionality.LTR : directionality;
    }

    public SignatureAppearanceDirectionality getDirectionality() {
        return this.directionality;
    }

    public void setFontSet(PDFFontSet fontSet) {
        this.fontSet = fontSet;
    }

    public PDFFontSet getFontSet() {
        return this.fontSet;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setAmbientLocale(Locale ambientLocale) {
        this.ambientLocale = ambientLocale;
    }

    public Locale getAmbientLocale() {
        return this.ambientLocale;
    }

    public boolean hasDateFormat() {
        return this.dateFormat != null;
    }

    public SignatureAppearanceDateFormatter getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SignatureAppearanceDateFormatter dateFormat) {
        this.dateFormat = dateFormat;
    }
}

