/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldXFA;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.FormModelWorkFlow;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.containers.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

class DocSignatureFieldIterator {
    DocSignatureFieldIterator() {
    }

    Iterator<SignatureFieldInterface> getIterator(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidXMLException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        if (pdfDoc == null) {
            throw new PDFInvalidDocumentException("PDFDocument can't be null");
        }
        PDFDocument.PDFDocumentType docType = XFAService.getDocumentType(pdfDoc);
        if (docType == PDFDocument.PDFDocumentType.Flat || docType == PDFDocument.PDFDocumentType.Acroform) {
            return new AcroformIterator(pdfDoc);
        }
        XFADOMService.ensureXFADOMCreated(pdfDoc);
        if (docType == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            return new AcroformIterator(pdfDoc);
        }
        if (docType == PDFDocument.PDFDocumentType.DynamicNonShellXFA || docType == PDFDocument.PDFDocumentType.DynamicShellXFA || docType == PDFDocument.PDFDocumentType.StaticShellXFA) {
            return new XFAIterator(pdfDoc);
        }
        throw new PDFInvalidDocumentException("Document provided is neither of Acroform nor XFA type");
    }

    Iterator<SignatureFieldInterface> getAcroformIterator(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDoc == null) {
            throw new PDFInvalidDocumentException("PDFDocument can't be null");
        }
        return new AcroformIterator(pdfDoc);
    }

    private static class XFAIterator
    implements Iterator<SignatureFieldInterface> {
        private Field xfaSigField = null;
        private Stack<Field> xfaSignatureFields = new Stack();
        private PDFDocument pdfDoc = null;
        private PDFFieldSignature curSigField = null;
        private PDFFieldSignature nextSigField = null;
        private Iterator<PDFField> fieldsIter = null;
        private boolean isXFAProcessed = false;
        private Set<String> acroformFields = new HashSet<String>();
        private Set<String> ignoreFields = new HashSet<String>();
        private XFADOMServiceListener serviceListener = null;

        public XFAIterator(PDFDocument pdfDoc) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this(pdfDoc, null);
        }

        public XFAIterator(PDFDocument pdfDoc, Set<String> ignoreFields) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFInteractiveForm iform;
            this.pdfDoc = pdfDoc;
            if (pdfDoc != null && (iform = pdfDoc.getInteractiveForm()) != null) {
                this.fieldsIter = iform.iterator(PDFFieldType.Signature, true);
            }
            if (ignoreFields != null) {
                this.ignoreFields = ignoreFields;
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.isXFAProcessed) {
                try {
                    if (this.fieldsIter == null) {
                        return false;
                    }
                    if (this.curSigField != null) {
                        return true;
                    }
                    if (this.fieldsIter.hasNext()) {
                        Field sigField;
                        this.curSigField = (PDFFieldSignature)this.fieldsIter.next();
                        if (SignatureUtils.isSigned(this.curSigField) && ((sigField = XFAUtils.getXFASignatureField(this.pdfDoc, this.curSigField.getQualifiedName())) == null || XFAUtils.isSignatureFieldInGoodPosition(this.pdfDoc, sigField))) {
                            return true;
                        }
                        this.curSigField = null;
                        return this.hasNext();
                    }
                    List<Field> sigFields = XFAUtils.enumerateXFASignatureFields(this.pdfDoc);
                    if (sigFields != null) {
                        for (int i = 0; i < sigFields.size(); ++i) {
                            Field sigField = sigFields.get(i);
                            String qualifiedName = SOMExpressionUtils.trimSomExpression(sigField.getSOMExpression());
                            if (this.acroformFields != null && this.acroformFields.contains(qualifiedName) || this.ignoreFields != null && this.ignoreFields.contains(qualifiedName) || !XFAUtils.isSignatureFieldInGoodPosition(this.pdfDoc, sigField)) continue;
                            this.xfaSignatureFields.push(sigField);
                        }
                    }
                    this.isXFAProcessed = true;
                    this.curSigField = null;
                    this.fieldsIter = null;
                    if (this.acroformFields != null) {
                        this.acroformFields.clear();
                        this.acroformFields = null;
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    throw new RuntimeException(e);
                }
                catch (PDFIOException e) {
                    throw new RuntimeException(e);
                }
                catch (PDFSecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (PDFInvalidParameterException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.isXFAProcessed && !this.xfaSignatureFields.empty();
        }

        @Override
        public SignatureFieldInterface next() {
            try {
                if (this.serviceListener == null) {
                    DocumentListenerRegistry registry = this.pdfDoc.getListenerRegistry();
                    this.serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
                }
                if (this.isXFAProcessed) {
                    this.xfaSigField = this.xfaSignatureFields.pop();
                    this.serviceListener.setIteratedSignatureField(SOMExpressionUtils.trimSomExpression(this.xfaSigField.toString()), null, this.xfaSigField);
                    return new SignatureFieldXFA(this.pdfDoc, this.xfaSigField);
                }
                if (this.curSigField != null) {
                    this.acroformFields.add(this.curSigField.getQualifiedName());
                    this.nextSigField = this.curSigField;
                    this.curSigField = null;
                    this.serviceListener.setIteratedSignatureField(SOMExpressionUtils.trimSomExpression(this.nextSigField.toString()), this.nextSigField, null);
                    return new SignatureFieldPDF(this.nextSigField);
                }
                if (this.hasNext()) {
                    return this.next();
                }
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException(e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException(e);
            }
            catch (PDFInvalidParameterException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public void remove() {
            try {
                if (this.nextSigField == null && this.xfaSigField == null) {
                    throw new IllegalStateException();
                }
                if (this.nextSigField != null) {
                    SignatureFieldPDF pdfSigField = new SignatureFieldPDF(this.nextSigField);
                    this.xfaSigField = pdfSigField.getXFAField().getXFAFieldSignature();
                    SignatureManager sigMgr = SignatureManager.newInstance(this.pdfDoc);
                    sigMgr.removeSignatureField(new FormModelWorkFlow(pdfSigField), true, false);
                    this.nextSigField = null;
                    this.fieldsIter.remove();
                }
                if (this.xfaSigField != null) {
                    this.xfaSigField = !(this.xfaSigField instanceof FormField) || this.xfaSigField.getProto() == null ? this.xfaSigField : (Field)this.xfaSigField.getProto();
                    this.xfaSigField.remove();
                }
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException(e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException(e);
            }
            catch (PDFInvalidParameterException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class AcroformIterator
    implements Iterator<SignatureFieldInterface> {
        private Iterator<PDFField> fieldsIter = null;
        private SignatureFieldPDF curSigField = null;
        private PDFDocument pdfDoc = null;

        public AcroformIterator(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFInteractiveForm iform;
            this.pdfDoc = pdfDoc;
            if (pdfDoc != null && (iform = pdfDoc.getInteractiveForm()) != null) {
                this.fieldsIter = iform.iterator(PDFFieldType.Signature, true);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.fieldsIter == null) {
                return false;
            }
            return this.fieldsIter.hasNext();
        }

        @Override
        public SignatureFieldInterface next() {
            if (this.hasNext()) {
                try {
                    this.curSigField = new SignatureFieldPDF((PDFFieldSignature)this.fieldsIter.next());
                }
                catch (PDFInvalidParameterException e) {
                    throw new RuntimeException("Signature Field is null", e);
                }
                return this.curSigField;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.fieldsIter == null || this.curSigField == null) {
                throw new IllegalStateException();
            }
            try {
                SignatureFieldXFA xfaSigField;
                SignatureManager sigMgr = SignatureManager.newInstance(this.curSigField.getPDFDocument());
                if (XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA && (xfaSigField = this.curSigField.getXFAField()) != null) {
                    Field xfaField = xfaSigField.getXFAFieldSignature();
                    xfaField = !(xfaField instanceof FormField) || xfaField.getProto() == null ? xfaField : (Field)xfaField.getProto();
                    xfaField.remove();
                }
                sigMgr.removeSignatureField(new FormModelWorkFlow(this.curSigField), true, false);
                this.fieldsIter.remove();
                this.curSigField = null;
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException(e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

