/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUnderline;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;

class UnderlineAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationUnderline> {
    UnderlineAnnotApGenerator() {
    }

    private ASCoordinate[] quadToPoints(AnnotationAppearanceGenerator.Quad q) {
        return new ASCoordinate[]{new ASCoordinate((6.0 * q.bl.x() + q.tl.x()) / 7.0, (6.0 * q.bl.y() + q.tl.y()) / 7.0), new ASCoordinate((6.0 * q.br.x() + q.tr.x()) / 7.0, (6.0 * q.br.y() + q.tr.y()) / 7.0)};
    }

    @Override
    protected void generateAppearanceInternal(PDFAnnotationUnderline annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        PDFRectangle rectangle = annot.getRect();
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectangle);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix(fm.geta(), fm.getb(), fm.getc(), fm.getd(), fm.getx(), fm.gety()));
        }
        this.writer.writeGraphicsInfo(annot, true, annot.getColor(), null, annot.getOpacity(), null);
        double[] quadPoints = annot.getQuadPoints();
        int nSize = quadPoints.length;
        ASCoordinate[] fp = null;
        for (int n = 0; n < nSize; n += 8) {
            AnnotationAppearanceGenerator.Quad q = new AnnotationAppearanceGenerator.Quad(quadPoints, n);
            this.writer.lineWidth = (Math.abs(q.tr.y() - q.br.y()) + Math.abs(q.tr.x() - q.br.x())) / 16.0;
            this.writer.contentWriter.write(InstructionFactory.newLineWidth(this.writer.lineWidth));
            fp = this.quadToPoints(q);
            this.writer.moveTo(fp[0].x(), fp[0].y());
            this.writer.lineTo(fp[1].x(), fp[1].y());
            this.writer.fillStroke(false, this.writer.stroke);
            this.writer.updateBulgeto(q.bl.x(), q.bl.y(), q.tl.x(), q.tl.y());
            this.writer.updateBulgeto(q.tr.x(), q.tr.y(), q.br.x(), q.br.y());
        }
        PDFRectangle rectAfter = this.writer.getAdjustedBBox(annot.getPDFDocument());
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
            if (rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) {
                annot.setRotation(annot.getRotation() - annot.getPage().getRotation().getValue());
            }
            this.setRect(annot, annot.getPage().getCropBox(), null);
            this.createAndSetAppearance(annot, rectAfter, annot.getPage().getCropBox());
        } else {
            this.setRect(annot, rectAfter, null);
            this.createAndSetAppearance(annot, rectAfter);
        }
    }
}

