/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.filter.spi.ImageFilterInterface;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.AssociationBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.BinaryFilterBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.BitsPerComponentBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ChannelDefinitionBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CodestreamHeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ColourGroupBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ColourSpecificationBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ComponentMappingBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CompositingLayerHeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CompositionBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ContiguousCodestreamBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CrossReferenceBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.DataReferenceBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.DesiredReproductionsBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.DigitalSignatureBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.FileTypeBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.FragmentTableBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.FreeBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ImageHeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.IntellectualPropertyBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.JP2HeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxesList;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.MPEG7BinaryBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.MediaDataBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.PaletteBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ROIDescriptionBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ReaderRequirementsBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.SignatureBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.UUIDBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.UUIDInfoBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.XMLBox;
import java.io.IOException;
import java.util.ArrayList;

public class Jpeg2000Parser {
    public static Jpeg2000BoxesList<Jpeg2000Box> parse(InputByteStream data) throws IOException {
        Jpeg2000BoxesList<Jpeg2000Box> boxesList = new Jpeg2000BoxesList<Jpeg2000Box>();
        while (data.bytesAvailable() > 0L) {
            Jpeg2000Parser.processBox(boxesList, data);
        }
        return boxesList;
    }

    private static void processBox(Jpeg2000BoxesList<Jpeg2000Box> boxesList, InputByteStream data) throws IOException {
        Jpeg2000BoxInfo boxInfo = new Jpeg2000BoxInfo(data);
        Jpeg2000BoxType boxType = boxInfo.getType();
        if (boxType == null) {
            return;
        }
        switch (boxType) {
            case signatureBox: {
                boxesList.add(new SignatureBox(boxInfo));
                break;
            }
            case fileTypeBox: {
                boxesList.add(new FileTypeBox(boxInfo));
                break;
            }
            case readerRequirementsBox: {
                boxesList.add(new ReaderRequirementsBox(boxInfo));
                break;
            }
            case jp2HeaderBox: {
                boxesList.add(new JP2HeaderBox(boxInfo));
                break;
            }
            case codestreamHeaderBox: {
                boxesList.add(new CodestreamHeaderBox(boxInfo));
                break;
            }
            case compositingLayerHeaderBox: {
                boxesList.add(new CompositingLayerHeaderBox(boxInfo));
                break;
            }
            case dataReferenceBox: {
                boxesList.add(new DataReferenceBox(boxInfo));
                break;
            }
            case fragmentTableBox: {
                boxesList.add(new FragmentTableBox(boxInfo));
                break;
            }
            case contiguousCodeStreamBox: {
                boxesList.add(new ContiguousCodestreamBox(boxInfo));
                break;
            }
            case mediaDataBox: {
                boxesList.add(new MediaDataBox(boxInfo));
                break;
            }
            case compositionBox: {
                boxesList.add(new CompositionBox(boxInfo));
                break;
            }
            case desiredReproductionsBox: {
                boxesList.add(new DesiredReproductionsBox(boxInfo));
                break;
            }
            case roiDescriptionBox: {
                boxesList.add(new ROIDescriptionBox(boxInfo));
                break;
            }
            case crossReferenceBox: {
                boxesList.add(new CrossReferenceBox(boxInfo));
                break;
            }
            case associationBox: {
                boxesList.add(new AssociationBox(boxInfo));
                break;
            }
            case binaryFilterBox: {
                boxesList.add(new BinaryFilterBox(boxInfo));
                break;
            }
            case digitalSignatureBox: {
                boxesList.add(new DigitalSignatureBox(boxInfo));
                break;
            }
            case mpeg7BinaryBox: {
                boxesList.add(new MPEG7BinaryBox(boxInfo));
                break;
            }
            case freeBox: {
                boxesList.add(new FreeBox(boxInfo));
                break;
            }
            case intellectualPropertyBox: {
                boxesList.add(new IntellectualPropertyBox(boxInfo));
                break;
            }
            case xmlBox: {
                boxesList.add(new XMLBox(boxInfo));
                break;
            }
            case uuidBox: {
                boxesList.add(new UUIDBox(boxInfo));
                break;
            }
            case uuidInfoBox: {
                boxesList.add(new UUIDInfoBox(boxInfo));
            }
        }
    }

    public static ImageFilterInterface.ImageInfo getImageInfo(Jpeg2000BoxesList<Jpeg2000Box> topLevelBoxes) throws IOException {
        JP2HeaderBox jp2HeaderBox = null;
        CompositingLayerHeaderBox firstCompositingLayerHeaderBox = null;
        CodestreamHeaderBox firstCodestreamHeaderBox = null;
        block11: for (int i = 0; i < topLevelBoxes.size(); ++i) {
            switch (((Jpeg2000Box)topLevelBoxes.get(i)).getBoxInfo().getType()) {
                case jp2HeaderBox: {
                    jp2HeaderBox = (JP2HeaderBox)topLevelBoxes.get(i);
                    continue block11;
                }
                case compositingLayerHeaderBox: {
                    if (firstCompositingLayerHeaderBox != null) continue block11;
                    firstCompositingLayerHeaderBox = (CompositingLayerHeaderBox)topLevelBoxes.get(i);
                    continue block11;
                }
                case codestreamHeaderBox: {
                    if (firstCodestreamHeaderBox != null) continue block11;
                    firstCodestreamHeaderBox = (CodestreamHeaderBox)topLevelBoxes.get(i);
                    continue block11;
                }
            }
        }
        Jpeg2000BoxesList<Jpeg2000Box> requiredBoxesList = Jpeg2000Parser.getRequiredBoxesList(firstCompositingLayerHeaderBox, firstCodestreamHeaderBox, jp2HeaderBox);
        ChannelDefinitionBox channelDefinitionBox = null;
        Jpeg2000BoxesList<ColourSpecificationBox> csBoxesList = new Jpeg2000BoxesList<ColourSpecificationBox>();
        ImageHeaderBox imageHeaderBox = null;
        BitsPerComponentBox bitsPerComponentBox = null;
        block12: for (int i = 0; i < requiredBoxesList.size(); ++i) {
            switch (((Jpeg2000Box)requiredBoxesList.get(i)).getBoxInfo().getType()) {
                case channelDefinitionBox: {
                    channelDefinitionBox = (ChannelDefinitionBox)requiredBoxesList.get(i);
                    continue block12;
                }
                case colourSpecificationBox: {
                    csBoxesList.add((ColourSpecificationBox)requiredBoxesList.get(i));
                    continue block12;
                }
                case imageHeaderBox: {
                    imageHeaderBox = (ImageHeaderBox)requiredBoxesList.get(i);
                    continue block12;
                }
                case bitsPerComponentBox: {
                    bitsPerComponentBox = (BitsPerComponentBox)requiredBoxesList.get(i);
                    continue block12;
                }
            }
        }
        int numberOfColourChannels = -1;
        ColourSpecificationBox csBoxWithApproxSet = null;
        if (channelDefinitionBox != null) {
            int[] channelTypesList = channelDefinitionBox.getChannelTypeList();
            for (int i = 0; i < channelDefinitionBox.getNumberOfChannelDecriptions(); ++i) {
                if (channelTypesList[i] != 0) continue;
                ++numberOfColourChannels;
            }
        }
        if (numberOfColourChannels == -1) {
            for (int i = 0; i < csBoxesList.size(); ++i) {
                if (((ColourSpecificationBox)csBoxesList.get(i)).getApprox() != 1 || csBoxWithApproxSet != null) continue;
                csBoxWithApproxSet = (ColourSpecificationBox)csBoxesList.get(i);
            }
            if (csBoxesList.size() == 1) {
                csBoxWithApproxSet = (ColourSpecificationBox)csBoxesList.get(0);
            }
            numberOfColourChannels = Jpeg2000Parser.getNumberOfColorChannels(csBoxWithApproxSet);
        }
        ImageFilterInterface.ImageInfo imageInfo = new ImageFilterInterface.ImageInfo();
        imageInfo.setNumberOfColorComponents(numberOfColourChannels);
        int bpc = -1;
        if (bitsPerComponentBox == null) {
            bpc = imageHeaderBox.getBitsPerComponent() + 1;
        } else {
            ArrayList<Byte> bitDepths = bitsPerComponentBox.getBitDepthsList();
            for (int i = 0; i < bitDepths.size(); ++i) {
                if (bitDepths.get(i) + 1 <= bpc) continue;
                bpc = bitDepths.get(i) + 1;
            }
        }
        imageInfo.setBitDepth(bpc);
        return imageInfo;
    }

    public static int getNumberOfColorChannels(ColourSpecificationBox csBox) throws IOException {
        int method = csBox.getSpecificationMethod();
        if (method == 2 || method == 3) {
            return 3;
        }
        if (method == 1) {
            int enumeratedCS = (int)csBox.getEnumeratedColourSpace();
            switch (enumeratedCS) {
                case 0: 
                case 15: 
                case 17: {
                    return 1;
                }
                case 1: 
                case 3: 
                case 4: 
                case 9: 
                case 11: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    return 3;
                }
                case 12: 
                case 13: {
                    return 4;
                }
            }
        }
        return 0;
    }

    public static Jpeg2000BoxesList<Jpeg2000Box> getRequiredBoxesList(CompositingLayerHeaderBox compositingLayerHeaderBox, CodestreamHeaderBox codestreamHeaderBox, JP2HeaderBox jp2HeaderBox) throws IOException {
        ComponentMappingBox componentMappingBox;
        PaletteBox paletteBox;
        BitsPerComponentBox bitsperComponentBox;
        ImageHeaderBox imageHeaderBox;
        ChannelDefinitionBox channelDefinitionBox;
        Jpeg2000BoxesList<Jpeg2000Box> requiredBoxesList = new Jpeg2000BoxesList<Jpeg2000Box>();
        ChannelDefinitionBox channelDefinitionBox2 = channelDefinitionBox = compositingLayerHeaderBox != null ? compositingLayerHeaderBox.getChannelDefinitionBox() : null;
        if (channelDefinitionBox == null) {
            channelDefinitionBox = jp2HeaderBox.getChannelDefinitionBox();
        }
        if (channelDefinitionBox != null) {
            requiredBoxesList.add(channelDefinitionBox);
        }
        ColourGroupBox colourGroupBox = compositingLayerHeaderBox != null ? compositingLayerHeaderBox.getColourGroupBox() : null;
        Jpeg2000BoxesList<ColourSpecificationBox> colourSpecifications = null;
        colourSpecifications = colourGroupBox == null ? jp2HeaderBox.getColourSpecificationBoxesList() : colourGroupBox.getColourSpecificationBoxesList();
        if (colourSpecifications != null) {
            requiredBoxesList.addAll(colourSpecifications);
        }
        ImageHeaderBox imageHeaderBox2 = imageHeaderBox = codestreamHeaderBox != null ? codestreamHeaderBox.getImageHeaderBox() : null;
        if (imageHeaderBox == null) {
            imageHeaderBox = jp2HeaderBox.getImageHeaderBox();
        }
        if (imageHeaderBox != null) {
            requiredBoxesList.add(imageHeaderBox);
        }
        BitsPerComponentBox bitsPerComponentBox = bitsperComponentBox = codestreamHeaderBox != null ? codestreamHeaderBox.getBitsPerComponentBox() : null;
        if (bitsperComponentBox == null) {
            bitsperComponentBox = jp2HeaderBox.getBitsPerComponentBox();
        }
        if (bitsperComponentBox != null) {
            requiredBoxesList.add(bitsperComponentBox);
        }
        PaletteBox paletteBox2 = paletteBox = codestreamHeaderBox != null ? codestreamHeaderBox.getPaletteBox() : null;
        if (paletteBox == null) {
            paletteBox = jp2HeaderBox.getPaletteBox();
        }
        if (paletteBox != null) {
            requiredBoxesList.add(paletteBox);
        }
        ComponentMappingBox componentMappingBox2 = componentMappingBox = codestreamHeaderBox != null ? codestreamHeaderBox.getComponentMappingBox() : null;
        if (componentMappingBox == null) {
            componentMappingBox = jp2HeaderBox.getComponentMappingBox();
        }
        if (componentMappingBox != null) {
            requiredBoxesList.add(componentMappingBox);
        }
        return requiredBoxesList;
    }
}

