/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class Jpeg2000BoxInfo {
    private static final int LBOX_SIZE = 4;
    private static final int TBOX_SIZE = 4;
    private static final int XLBOX_SIZE = 8;
    private long length = 0L;
    private Jpeg2000BoxType type;
    private long extendedLength = 0L;
    private InputByteStream boxContents;

    Jpeg2000BoxInfo(InputByteStream data) throws IOException {
        int bytesRead = 0;
        this.length = Jpeg2000Utils.bytesToLong(data, 4);
        bytesRead += 4;
        if (this.length < 0L || this.length > 1L && this.length < 8L) {
            throw new IOException("box length invalid");
        }
        this.type = Jpeg2000BoxType.getInstance(data);
        bytesRead += 4;
        if (this.length == 0L) {
            this.length = data.bytesAvailable() + (long)bytesRead;
        }
        if (this.length == 1L) {
            this.extendedLength = Jpeg2000Utils.bytesToLong(data, 8);
            bytesRead += 8;
            if (this.extendedLength < 0L) {
                throw new IOException("very long file.");
            }
        }
        this.boxContents = data.slice(data.getPosition(), this.getActualLength() - (long)this.size());
        data.seek(data.getPosition() + this.getActualLength() - (long)this.size());
    }

    public long getLength() {
        return this.length;
    }

    public Jpeg2000BoxType getType() {
        return this.type;
    }

    public long getExtendedLength() {
        return this.extendedLength;
    }

    InputByteStream getBoxContents() {
        return this.boxContents;
    }

    void clearContents() throws IOException {
        if (this.boxContents != null) {
            this.boxContents.close();
        }
        this.boxContents = null;
    }

    long getActualLength() {
        return this.length + this.extendedLength;
    }

    int size() {
        return this.length == 1L ? 16 : 8;
    }
}

