/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class CompositionOptionsBox
extends Jpeg2000Box {
    private long height;
    private long width;
    private int loop;

    CompositionOptionsBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public long getHeight() throws IOException {
        this.lazilyPopulateFields();
        return this.height;
    }

    public long getWidth() throws IOException {
        this.lazilyPopulateFields();
        return this.width;
    }

    public int getLoop() throws IOException {
        this.lazilyPopulateFields();
        return this.loop;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.height = Jpeg2000Utils.bytesToLong(boxContents, 4);
            this.width = Jpeg2000Utils.bytesToLong(boxContents, 4);
            this.loop = Jpeg2000Utils.bytesToInteger(boxContents, 1);
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

