/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ChannelDefinitionBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CodestreamRegistrationBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ColourGroupBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CrossReferenceBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.IntellectualPropertyBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.LabelBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.OpacityBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ResolutionBox;
import java.io.IOException;

public class CompositingLayerHeaderBox
extends Jpeg2000Box {
    private LabelBox labelBox;
    private ColourGroupBox colourGroupBox;
    private OpacityBox opacityBox;
    private ChannelDefinitionBox channelDefinitionBox;
    private CodestreamRegistrationBox codestreamRegistrationBox;
    private ResolutionBox resolutionBox;
    private IntellectualPropertyBox intellectualPropertyBox;
    private CrossReferenceBox crossReferenceBox;

    CompositingLayerHeaderBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public LabelBox getLabelBox() throws IOException {
        this.lazilyPopulateFields();
        return this.labelBox;
    }

    public ColourGroupBox getColourGroupBox() throws IOException {
        this.lazilyPopulateFields();
        return this.colourGroupBox;
    }

    public OpacityBox getOpacityBox() throws IOException {
        this.lazilyPopulateFields();
        return this.opacityBox;
    }

    public ChannelDefinitionBox getChannelDefinitionBox() throws IOException {
        this.lazilyPopulateFields();
        return this.channelDefinitionBox;
    }

    public CodestreamRegistrationBox getCodestreamRegistrationBox() throws IOException {
        this.lazilyPopulateFields();
        return this.codestreamRegistrationBox;
    }

    public ResolutionBox getResolutionBox() throws IOException {
        this.lazilyPopulateFields();
        return this.resolutionBox;
    }

    public IntellectualPropertyBox getIntellectualPropertyBox() throws IOException {
        this.lazilyPopulateFields();
        return this.intellectualPropertyBox;
    }

    public CrossReferenceBox getCrossReferenceBox() throws IOException {
        this.lazilyPopulateFields();
        return this.crossReferenceBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            block13: while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                Jpeg2000BoxType innerBoxType = innerBoxInfo.getType();
                if (innerBoxType == null) continue;
                switch (innerBoxType) {
                    case labelBox: {
                        this.labelBox = new LabelBox(innerBoxInfo);
                        continue block13;
                    }
                    case colourGroupBox: {
                        this.colourGroupBox = new ColourGroupBox(innerBoxInfo);
                        continue block13;
                    }
                    case opacityBox: {
                        this.opacityBox = new OpacityBox(innerBoxInfo);
                        continue block13;
                    }
                    case codestreamRegistrationBox: {
                        this.codestreamRegistrationBox = new CodestreamRegistrationBox(innerBoxInfo);
                        continue block13;
                    }
                    case channelDefinitionBox: {
                        this.channelDefinitionBox = new ChannelDefinitionBox(innerBoxInfo);
                        continue block13;
                    }
                    case resolutionBox: {
                        this.resolutionBox = new ResolutionBox(innerBoxInfo);
                        continue block13;
                    }
                    case intellectualPropertyBox: {
                        this.intellectualPropertyBox = new IntellectualPropertyBox(innerBoxInfo);
                        continue block13;
                    }
                    case crossReferenceBox: {
                        this.crossReferenceBox = new CrossReferenceBox(innerBoxInfo);
                        continue block13;
                    }
                }
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.labelBox != null) {
                this.labelBox.close();
            }
        }
        finally {
            try {
                if (this.colourGroupBox != null) {
                    this.colourGroupBox.close();
                }
            }
            finally {
                try {
                    if (this.opacityBox != null) {
                        this.opacityBox.close();
                    }
                }
                finally {
                    try {
                        if (this.channelDefinitionBox != null) {
                            this.channelDefinitionBox.close();
                        }
                    }
                    finally {
                        try {
                            if (this.codestreamRegistrationBox != null) {
                                this.codestreamRegistrationBox.close();
                            }
                        }
                        finally {
                            try {
                                if (this.resolutionBox != null) {
                                    this.resolutionBox.close();
                                }
                            }
                            finally {
                                try {
                                    if (this.intellectualPropertyBox != null) {
                                        this.intellectualPropertyBox.close();
                                    }
                                }
                                finally {
                                    try {
                                        if (this.crossReferenceBox != null) {
                                            this.crossReferenceBox.close();
                                        }
                                    }
                                    finally {
                                        this.boxInfo.clearContents();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

