/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class ColourSpecificationBox
extends Jpeg2000Box {
    private int specificationMethod;
    private byte precedence;
    private int approx;
    private long enumeratedColourSpace;
    private InputByteStream enumeratedParameters;
    private InputByteStream iccProfile;
    private InputByteStream vendorDefinedCode;
    private InputByteStream vendorParameters;

    ColourSpecificationBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getSpecificationMethod() throws IOException {
        this.lazilyPopulateFields();
        return this.specificationMethod;
    }

    public byte getPrecedence() throws IOException {
        this.lazilyPopulateFields();
        return this.precedence;
    }

    public int getApprox() throws IOException {
        this.lazilyPopulateFields();
        return this.approx;
    }

    public long getEnumeratedColourSpace() throws IOException {
        this.lazilyPopulateFields();
        return this.enumeratedColourSpace;
    }

    public InputByteStream getICCProfile() throws IOException {
        this.lazilyPopulateFields();
        return this.iccProfile != null ? this.iccProfile.slice() : null;
    }

    public InputByteStream getEnumeratedParameters() throws IOException {
        this.lazilyPopulateFields();
        return this.enumeratedParameters != null ? this.enumeratedParameters.slice() : null;
    }

    public InputByteStream getVendorDefinedCode() throws IOException {
        this.lazilyPopulateFields();
        return this.vendorDefinedCode != null ? this.vendorDefinedCode.slice() : null;
    }

    public InputByteStream getVendorParameters() throws IOException {
        this.lazilyPopulateFields();
        return this.vendorParameters != null ? this.vendorParameters.slice() : null;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.specificationMethod = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            this.precedence = (byte)boxContents.read();
            this.approx = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            if (this.approx != 0) {
                if (this.specificationMethod == 1) {
                    this.enumeratedColourSpace = Jpeg2000Utils.bytesToInteger(boxContents, 4);
                    this.enumeratedParameters = boxContents.slice(boxContents.getPosition(), boxContents.bytesAvailable());
                } else if (this.specificationMethod == 2 || this.specificationMethod == 3) {
                    this.iccProfile = boxContents.slice(boxContents.getPosition(), boxContents.bytesAvailable());
                } else if (this.specificationMethod == 4) {
                    this.vendorDefinedCode = boxContents.slice(boxContents.getPosition(), 16L);
                    boxContents.seek(boxContents.getPosition() + 16L);
                    this.vendorParameters = boxContents.slice(boxContents.getPosition(), boxContents.bytesAvailable());
                }
                return;
            }
            if (this.specificationMethod != 2) {
                this.enumeratedColourSpace = Jpeg2000Utils.bytesToLong(boxContents, 4);
            }
            if (this.specificationMethod != 1) {
                this.iccProfile = boxContents.slice(boxContents.getPosition(), boxContents.bytesAvailable());
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.enumeratedParameters != null) {
                this.enumeratedParameters.close();
            }
        }
        finally {
            try {
                if (this.iccProfile != null) {
                    this.iccProfile.close();
                }
            }
            finally {
                try {
                    if (this.vendorDefinedCode != null) {
                        this.vendorDefinedCode.close();
                    }
                }
                finally {
                    try {
                        if (this.vendorParameters != null) {
                            this.vendorParameters.close();
                        }
                    }
                    finally {
                        this.boxInfo.clearContents();
                    }
                }
            }
        }
    }
}

