/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.utils;

import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class PDFUtil {
    private static final String RICH_TEXT_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><body xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\" xfa:APIVersion=\"2.2\"><p>";
    private static final String RICH_TEXT_END = "</p></body>";
    static int logNumCounter = 0;
    public static final int LOG_LEVEL_DEBUG = 0;
    public static final int LOG_LEVEL_INFO = 1;
    public static final int LOG_LEVEL_WARN = 2;
    public static final int LOG_LEVEL_FAIL = 3;
    public static int logLevel = 1;
    static FileWriter logFile;
    static int NUM_MESSAGES_FLUSH;
    static int charsWritten;
    static int FILE_ROLLOVER;
    static String logFileName;
    static int rolloverNum;
    static int fileLoggingErrCount;
    static boolean sysoutSink;
    static boolean fileSink;

    public static String toString(byte[] b) {
        StringBuilder rslt = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            rslt.append((char)b[i]);
        }
        return rslt.toString();
    }

    public static ArrayList<Double> parseNumbers(String numbersString, String separator) {
        StringTokenizer numbersTokens = new StringTokenizer(numbersString, separator);
        ArrayList<Double> numbers = new ArrayList<Double>();
        while (numbersTokens.hasMoreTokens()) {
            StringBuilder oneNumber = new StringBuilder(numbersTokens.nextToken());
            int numInd = 0;
            while (numInd < oneNumber.length()) {
                if (!ByteOps.isWhitespace(oneNumber.charAt(numInd))) {
                    ++numInd;
                    continue;
                }
                oneNumber.delete(numInd, numInd + 1);
            }
            numbers.add(new Double(oneNumber.toString()));
        }
        return numbers.isEmpty() ? null : numbers;
    }

    public static int findStringInArray(String look, String[] lookup) {
        for (int strInd = 0; strInd < lookup.length; ++strInd) {
            if (!look.equals(lookup[strInd])) continue;
            return strInd;
        }
        return -1;
    }

    public static String substituteStringFromArray(String look, String[] lookup, String[] substitute) {
        int arrayInd = PDFUtil.findStringInArray(look, lookup);
        return arrayInd == -1 ? null : substitute[arrayInd];
    }

    public static String makeRichTextFromString(String simpleString) {
        if (simpleString == null) {
            return null;
        }
        StringBuilder bufStr = new StringBuilder(RICH_TEXT_START.length() + RICH_TEXT_END.length() + simpleString.length());
        bufStr.append(RICH_TEXT_START);
        bufStr.append(simpleString);
        bufStr.append(RICH_TEXT_END);
        return bufStr.toString();
    }

    public static <T extends PDFCosObject> boolean containsPDFCosObjectRef(Collection<T> objectList, T obj) {
        for (PDFCosObject nextObject : objectList) {
            if (!PDFUtil.isPDFCosObjectRefEqual(obj, nextObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPDFCosObjectRefEqual(PDFCosObject pdfCosObject1, PDFCosObject pdfCosObject2) {
        if (pdfCosObject1 == null && pdfCosObject2 == null) {
            return true;
        }
        if (pdfCosObject1 == null || pdfCosObject2 == null) {
            return false;
        }
        if (pdfCosObject1.getClass() != pdfCosObject2.getClass()) {
            return false;
        }
        return pdfCosObject1.getCosObject() == pdfCosObject2.getCosObject();
    }

    public static <T extends PDFCosObject> int indexOfPDFCosObjectRef(Collection<T> objectList, T obj) {
        int index = 0;
        for (PDFCosObject nextObject : objectList) {
            if (PDFUtil.isPDFCosObjectRefEqual(obj, nextObject)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static String getLoggingPrefix() {
        return "Thread: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". " + Clock.systemUTC().instant() + ". " + System.nanoTime() + ". logNum: " + ++logNumCounter;
    }

    public static void logFailure(String msg) {
        if (logLevel <= 3) {
            PDFUtil.FinalLog(". FAIL: ", msg, false);
        }
    }

    public static void logWarning(String msg) {
        if (logLevel <= 2) {
            PDFUtil.FinalLog(", WARN: ", msg, false);
        }
    }

    public static void logInfo(String msg) {
        if (logLevel <= 1) {
            PDFUtil.FinalLog(", INFO: ", msg, false);
        }
    }

    public static void logDebug(String msg) {
        if (logLevel <= 0) {
            PDFUtil.FinalLog(", DEBG: ", msg, false);
        }
    }

    public static void logFailureFromTest(String msg) {
        if (logLevel <= 3) {
            PDFUtil.FinalLog(". FAIL: ", msg, true);
        }
    }

    public static void logWarningFromTest(String msg) {
        if (logLevel <= 2) {
            PDFUtil.FinalLog(", WARN: ", msg, true);
        }
    }

    public static void logInfoFromTest(String msg) {
        if (logLevel <= 1) {
            PDFUtil.FinalLog(", INFO: ", msg, true);
        }
    }

    public static void logDebugFromTest(String msg) {
        if (logLevel <= 0) {
            PDFUtil.FinalLog(", DEBG: ", msg, true);
        }
    }

    public static synchronized void FinalLog(String label, String msg, boolean fromTest) {
        try {
            String s = PDFUtil.getLoggingPrefix() + label + msg + "\n";
            if (fileSink && fileLoggingErrCount < 100) {
                if (logNumCounter == 1) {
                    PDFUtil.createLogFile();
                }
                if (charsWritten >= FILE_ROLLOVER) {
                    PDFUtil.rollOverLogFile();
                }
                if (logFile != null) {
                    logFile.write(s);
                    charsWritten += s.length();
                    if (logNumCounter % NUM_MESSAGES_FLUSH == 0) {
                        logFile.flush();
                    }
                }
            }
            if (sysoutSink) {
                System.out.print(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ++fileLoggingErrCount;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void rollOverLogFile() throws IOException {
        logFile.close();
        charsWritten = 0;
        logFile = new FileWriter(logFileName + "R" + ++rolloverNum + ".txt");
        logFile.write("********* Rolled Over ***************");
    }

    private static void createLogFile() throws IOException {
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter format1 = DateTimeFormatter.ofPattern("MM_dd_yyyy");
        String date = currentDateTime.format(format1);
        DateTimeFormatter format2 = DateTimeFormatter.ofPattern("HH_mm_ss_SSS");
        String time = currentDateTime.format(format2);
        String dir = "Logs/" + date;
        File f = new File(dir);
        f.mkdir();
        logFileName = dir + "/PDFUtilLogs" + time;
        logFile = new FileWriter(logFileName + "R" + rolloverNum + ".txt");
        logFile.write("********* Start Logging ***************");
    }

    public static boolean logDebugMessages() {
        return logLevel <= 0;
    }

    static {
        NUM_MESSAGES_FLUSH = 10000;
        charsWritten = 0;
        FILE_ROLLOVER = 10000000;
        rolloverNum = 0;
        fileLoggingErrCount = 0;
        sysoutSink = true;
        fileSink = false;
    }
}

