/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.utils;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;

public class ContentUtil {
    public static Content getContent(boolean canDirty, PDFXObjectForm form, PDFResources parentResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Content content = null;
        if (!canDirty) {
            PDFContents fContent = form.getContents();
            PDFResources fRes = form.getResources();
            if (form.getContents() != null) {
                if (fRes == null && parentResources == null) {
                    return null;
                }
                content = Content.newInstance(fContent, fRes == null ? parentResources : fRes);
            }
        } else {
            content = Content.newInstance(form);
        }
        return content;
    }

    public static Content getContent(boolean canDirty, PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(canDirty || page.getContents() != null && page.getResources() != null)) {
            return null;
        }
        return Content.newInstance(page);
    }

    public static ASMatrix computeMatrixFromBox(PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle cropBox = ContentUtil.getPageCropBox(pdfPage);
        ASMatrix matrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -cropBox.left(), -cropBox.bottom());
        double width = cropBox.width();
        double height = cropBox.height();
        PDFRotation rotate = pdfPage.getRotation();
        switch (rotate) {
            case ROTATE_0: {
                break;
            }
            case ROTATE_90: {
                ASMatrix m = new ASMatrix(0.0, -1.0, 1.0, 0.0, 0.0, width);
                matrix = matrix.concat(m);
                break;
            }
            case ROTATE_180: {
                ASMatrix m = new ASMatrix(-1.0, 0.0, 0.0, -1.0, width, height);
                matrix = matrix.concat(m);
                break;
            }
            case ROTATE_270: {
                ASMatrix m = new ASMatrix(0.0, 1.0, -1.0, 0.0, height, 0.0);
                matrix = matrix.concat(m);
            }
        }
        return matrix;
    }

    public static ASRectangle getPageCropBox(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle rect = page.getCropBox();
        if (rect == null || rect.getCosArray().size() != 4) {
            return new ASRectangle(-1.7976931348623157E308, -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        return rect.getRectangle();
    }
}

