/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.transparency;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectFactory;
import com.adobe.internal.pdftoolkit.pdf.transparency.PDFSoftMaskLuminosity;

public abstract class PDFSoftMask
extends PDFCosDictionary {
    protected PDFSoftMask(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSoftMask getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("CosDictionary expected");
        }
        ASName nameSubtype = ((CosDictionary)cosObject).getName(ASName.k_S);
        if (nameSubtype == null) {
            throw new PDFInvalidDocumentException("Unknown type.");
        }
        if (nameSubtype == ASName.k_Luminosity) {
            return PDFSoftMaskLuminosity.getInstance(cosObject);
        }
        throw new PDFInvalidDocumentException("Unknown type.");
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.create("Mask"))) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Type.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Subtype is a required key therefore cannot be removed.");
        }
        if (!value.equals(ASName.create("Alpha")) && !value.equals(ASName.create("Luminosity"))) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Subtype.");
        }
        this.setDictionaryNameValue(ASName.k_S, value);
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public PDFFunction getTRAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFunctionFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_TR));
    }

    public void setTR(PDFFunction value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_TR, value);
    }

    public ASName getTRAsName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_TR);
    }

    public void setTR(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_TR);
        } else if (value.equals(ASName.create("Identity"))) {
            this.setDictionaryNameValue(ASName.k_TR, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for TR.");
        }
    }

    public boolean hasTR() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TR);
    }

    public PDFXObject getG() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectFactory.getInstance(this.getDictionaryCosObjectValue(ASName.k_G));
    }

    public void setG(PDFXObject value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("G is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_G, value);
    }

    public boolean hasG() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_G);
    }
}

