/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFRichMediaAnimation
extends PDFCosDictionary {
    public static final ASName k_PlayCount = ASName.create("PlayCount");
    public static final ASName k_Speed = ASName.create("Speed");
    public static final ASName k_RichMediaAnimation = ASName.create("RichMediaAnimation");
    public static final ASName k_None = ASName.create("None");
    public static final ASName k_Linear = ASName.create("Linear");
    public static final ASName k_Oscillating = ASName.create("Oscillating");

    private PDFRichMediaAnimation(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaAnimation newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaAnimation pdfObject = new PDFRichMediaAnimation(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaAnimation getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaAnimation pdfObject = (PDFRichMediaAnimation)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaAnimation.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaAnimation(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(k_RichMediaAnimation)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidDocumentException("Type value is not valid. " + k_RichMediaAnimation + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    public void setSubtype(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(ASName.k_Subtype);
        } else if (value.equals(k_None) || value.equals(k_Linear) || value.equals(k_Oscillating)) {
            this.setDictionaryNameValue(ASName.k_Subtype, value);
        } else {
            throw new PDFInvalidDocumentException("Subtype value is out of bound.");
        }
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }

    public int getPlayCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(k_PlayCount);
    }

    public void setPlayCount(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_PlayCount, value);
    }

    public boolean hasPlayCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_PlayCount);
    }

    public double getSpeed() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_Speed);
    }

    public void setSpeed(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_Speed, value);
    }

    public boolean hasSpeed() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Speed);
    }
}

