/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaOffset;

public class PDFMediaOffsetMarker
extends PDFMediaOffset {
    private PDFMediaOffsetMarker(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMediaOffsetMarker newInstance(PDFDocument pdfDocument, ASString key_Marker) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Marker == null) {
            throw new PDFInvalidParameterException("Marker is required when creating newInstance of PDFMediaOffsetMarker.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMediaOffsetMarker pdfObject = new PDFMediaOffsetMarker(cosObject);
        pdfObject.setType();
        pdfObject.setSubtype();
        pdfObject.setMarker(key_Marker);
        return pdfObject;
    }

    public static PDFMediaOffsetMarker getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMediaOffsetMarker pdfObject = (PDFMediaOffsetMarker)PDFCosObject.getCachedInstance(cosObject, PDFMediaOffsetMarker.class);
        if (pdfObject == null) {
            pdfObject = new PDFMediaOffsetMarker(cosObject);
        }
        return pdfObject;
    }

    public ASString getMarker() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_M);
    }

    public void setMarker(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Marker is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_M, value);
    }

    public void setMarker(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Marker is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_M, value);
    }

    public ASString requireMarker() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString name = this.getDictionaryStringValue(ASName.k_M);
        if (name == null) {
            throw new PDFInvalidDocumentException("Could not get Marker");
        }
        return name;
    }

    public boolean hasMarker() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_M);
    }

    @Override
    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_MediaOffset);
    }

    @Override
    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    @Override
    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    private void setSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, ASName.k_M);
    }

    @Override
    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    @Override
    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }
}

