/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DNode;

public class PDF3DNodeArray
extends PDFCosArrayList<PDF3DNode> {
    private PDF3DNodeArray(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DNodeArray newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDF3DNodeArray pdfObject = new PDF3DNodeArray(cosObject);
        return pdfObject;
    }

    public static PDF3DNodeArray getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DNodeArray pdfObject = (PDF3DNodeArray)PDFCosObject.getCachedInstance(cosObject, PDF3DNodeArray.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DNodeArray(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDF3DNode itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DNode.getInstance(cosObject);
    }
}

