/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DRenderMode;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaInstance;

public class PDF3DNode
extends PDFCosDictionary {
    private PDF3DNode(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DNode newInstance(PDFDocument pdfDocument, ASString key_Name, double key_Opacity, boolean key_Visibility, double[] key_Matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Name == null) {
            throw new PDFInvalidParameterException("Name is required when creating newInstance of PDF3DNode.");
        }
        if (key_Matrix == null) {
            throw new PDFInvalidParameterException("Matrix is required when creating newInstance of PDF3DNode.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DNode pdfObject = new PDF3DNode(cosObject);
        pdfObject.setName(key_Name);
        pdfObject.setOpacity(key_Opacity);
        pdfObject.setVisibility(key_Visibility);
        pdfObject.setMatrix(key_Matrix);
        return pdfObject;
    }

    public static PDF3DNode getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DNode pdfObject = (PDF3DNode)PDFCosObject.getCachedInstance(cosObject, PDF3DNode.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DNode(cosObject);
        }
        return pdfObject;
    }

    public boolean getVisibility() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_V);
    }

    public void setVisibility(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_V, value);
    }

    public boolean requireVisibility() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasVisibility()) {
            return this.getDictionaryCosObjectValue(ASName.k_V).booleanValue();
        }
        throw new PDFInvalidDocumentException("Could not get Visibility");
    }

    public boolean hasVisibility() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_V);
    }

    public double getOpacity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_O);
    }

    public void setOpacity(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_O, value);
    }

    public double requireOpacity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_O);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Opacity.");
        }
        return ((CosNumeric)cosObject).doubleValue();
    }

    public boolean hasOpacity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_O);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_3DNode)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Type.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public double[] getMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(ASName.k_M);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble();
    }

    public void setMatrix(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Matrix is a required key therefore cannot be removed.");
        }
        this.setDictionaryArrayValue(ASName.k_M, value);
    }

    public boolean hasMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_M);
    }

    public ASString getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_N);
    }

    public void setName(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Name is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_N, value);
    }

    public void setName(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Name is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_N, value);
    }

    public ASString requireName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString name = this.getDictionaryStringValue(ASName.k_N);
        if (name == null) {
            throw new PDFInvalidDocumentException("Could not get Name");
        }
        return name;
    }

    public boolean hasName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_N);
    }

    public PDFRichMediaInstance getRichMediaInstance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaInstance.getInstance(this.getDictionaryCosObjectValue(ASName.k_Instance));
    }

    public void setRichMediaInstance(PDFRichMediaInstance value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null && this.hasData()) {
            throw new PDFInvalidParameterException("Instance is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Instance, value);
    }

    public boolean hasRichMediaInstance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Instance);
    }

    public PDFText getDataAsTextString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(ASName.k_Data));
    }

    public void setData(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(ASName.k_Data, value);
    }

    public PDFStream getDataAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getDictionaryCosObjectValue(ASName.k_Data));
    }

    public void setDataAsStream(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Data, value);
    }

    public boolean hasData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Data);
    }

    public PDF3DRenderMode getRM() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DRenderMode.getInstance(this.getDictionaryCosObjectValue(ASName.k_RM));
    }

    public void setRM(PDF3DRenderMode value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_RM, value);
    }

    public boolean hasRM() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_RM);
    }
}

