/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVDict;

public class PDF3DExDataMarkup3D
extends PDFExData {
    private PDF3DExDataMarkup3D(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DExDataMarkup3D newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DExDataMarkup3D pdfObject = new PDF3DExDataMarkup3D(cosObject);
        pdfObject.setSubtype();
        return pdfObject;
    }

    public static PDF3DExDataMarkup3D newInstance(PDFDocument pdfDocument, PDFAnnotation3D key_3DA, PDF3DVDict key_3DV) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_3DA == null) {
            throw new PDFInvalidDocumentException("3DA is required when creating newInstance of PDF3DExDataMarkup3D.");
        }
        if (key_3DV == null) {
            throw new PDFInvalidDocumentException("3DV is required when creating newInstance of PDF3DExDataMarkup3D.");
        }
        PDF3DExDataMarkup3D pdfObject = PDF3DExDataMarkup3D.newInstance(pdfDocument);
        pdfObject.set3DAAsDict(key_3DA);
        pdfObject.set3DV(key_3DV);
        return pdfObject;
    }

    public static PDF3DExDataMarkup3D getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DExDataMarkup3D pdfObject = (PDF3DExDataMarkup3D)PDFCosObject.getCachedInstance(cosObject, PDF3DExDataMarkup3D.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DExDataMarkup3D(cosObject);
        }
        return pdfObject;
    }

    private void setSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Subtype, PDFExData.k_Markup3D);
    }

    public PDFAnnotation3D get3DAAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getDictionaryCosObjectValue(ASName.k_3DA) == null || this.getDictionaryCosObjectValue(ASName.k_3DA).getType() != 6) {
            return null;
        }
        return PDFAnnotation3D.getInstance(this.getDictionaryCosObjectValue(ASName.k_3DA));
    }

    public void set3DAAsDict(PDFAnnotation3D value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("3DA is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_3DA, value);
    }

    public PDFText get3DAAsTextString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getDictionaryCosObjectValue(ASName.k_3DA) == null || this.getDictionaryCosObjectValue(ASName.k_3DA).getType() != 4) {
            return null;
        }
        return PDFText.getInstance(this.getDictionaryValue(ASName.k_3DA));
    }

    public void set3DAAsTextString(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("3DA is a required key therefore cannot be removed.");
        }
        this.setDictionaryTextValue(ASName.k_3DA, value);
    }

    public boolean has3DA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DA);
    }

    public PDF3DVDict get3DV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVDict.getInstance(this.getDictionaryCosObjectValue(ASName.k_3DV));
    }

    public void set3DV(PDF3DVDict value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("3DV is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_3DV, value);
    }

    public PDF3DVDict require3DV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDF3DVDict pdfObject = PDF3DVDict.getInstance(this.getDictionaryCosObjectValue(ASName.k_3DV));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get 3DV");
        }
        return pdfObject;
    }

    public boolean has3DV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_3DV);
    }

    public ASString getMD5() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_MD5);
    }

    public void setMD5(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_MD5, value);
    }

    public void setMD5(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_MD5, value);
    }

    public boolean hasMD5() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_MD5);
    }
}

